/*
License: GPLv2, read more from COPYING

This file contains the functionality of Workshops menu.
 */
#include <tangle.h>
#include <glib-object.h>
#include "workshops.h"
#include "communitymenu.h"
#include "../jammo.h"

void start_workshops(){

	puts("Starting Workshops\n");
	
	clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* workshop_view = jammo_get_actor_by_id("workshop-view");

	if(workshop_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(workshop_view));
	}

	else 
		puts("can't find 'workshop-view' ");
	
}
