/*
License: GPLv2, read more from COPYING

This file contains the functionality of the avatar editor.
 */

#ifndef AVATAR_EDITOR_H
#define AVATAR_EDITOR_H

#include <tangle.h>
#include "community_utilities.h"

/*
* Starts avatar editor.
*/
void start_avatar_editor();

/*
* Sets avatar picture and other widgets 
*
* parameters:
* -avatar    Avatar struct that contains avatar parts
* -avatarImage   Container where to put avatar parts
* -instrumentBackground   Background for favourite instrument image
* -widget     Other widgets to show (i.e. "avatar-widgets" in avatar_editor.json or 
*									 "user-profile-widgets" in profile_viewer.json
*
*/
void set_avatar(Avatar*, ClutterActor*, ClutterActor*, char*);


gboolean sendJammoUserProfile(gchar* user_profile);

gboolean avatar_goto_communitymenu(TangleButton *tanglebutton, gpointer none);

gboolean avatar_goto_startmenu(TangleButton *tanglebutton, gpointer none);


#endif
