 /*
License: GPLv2, read more from COPYING

This file contains the functionality of Help menu.
 */

#ifndef HELP_H_
#define HELP_H_

#include <glib-object.h>

#define MAX_QUESTIONS 15
#define MAX_COMMENTS 15

typedef struct {
	gchar *id;	
	gint  index;
	guint32 user_id;
	gchar sender[20];
	gchar title[80];	
	gchar *messages;
	gchar date[17];
}question_type;

void start_helpdesk(void);
gboolean helpdesk_goto_communitymenu(TangleButton *tanglebutton, gpointer none);
gboolean helpdesk_goto_startmenu(TangleButton *tanglebutton, gpointer none);
void end_helpdesk(void);
gboolean helpdesk_get_questions(void);
gboolean helpdesk_add_question_to_list(gpointer data, guint user_id);
void helpdesk_add_question(void);
void clear_questions(GList* questions_);
void helpdesk_show_question_view(ClutterActor *actor);
void helpdesk_show_helpdesk_view(void);
gboolean parse_questions_from_file(gchar * filename);
gboolean helpdesk_show_addquestion_view(TangleActor* actor, gpointer data);
gboolean helpview_send_question(gint index, guint32 userid, gchar* sender, gchar* title, gchar* msg, gchar* filepath, gchar* time, int type);

#endif 
