/*
License: GPLv2, read more from COPYING

This file contains the functionality of Workshops menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "workshops.h"
#include "community_utilities.h"

#include "../../configure.h"
#include "../file_helper.h"

void start_workshops(){

	puts("Starting Workshops\n");
	
	clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* workshop_view = jammo_get_actor_by_id("workshop-view");

	if(workshop_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(workshop_view));
	}

	else 
		puts("can't find 'workshop-view' ");
	
}
void workshop_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	start_communitymenu();
}

void workshop_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	startmenu_goto_startmenu(tanglebutton, none);
}

gboolean workshop_mentor_clicked (TangleButton *tanglebutton, gpointer data)
{
	printf("mentor clicked\n");
	return TRUE;
}
