/**sequencer_track_view.c is part of JamMo.
License: GPLv2, read more from COPYING

Call this: sequencer_track_view_tune_width
 */
#include <glib-object.h>
#include <clutter/clutter.h>
#include <string.h>
#include <stdlib.h>
#include <tangle.h>


#include "../../meam/jammo-track.h"
#include "../../meam/jammo-editing-track.h"
#include "../../meam/jammo-instrument-track.h"
#include "../../meam/jammo-slider-track.h"
#include "../../meam/jammo-backing-track.h"
#include "../../meam/jammo-midi.h"
#include "../../meam/jammo-meam.h" //JAMMO_DURATION_INVALID

#include "../jammo-track-view.h"
#include "../jammo-editing-track-view.h"
#include "../jammo-miditrack-view.h"
#include "../jammo.h"
#include "../jammo-cursor.h"
#include "../file_helper.h"
#include "../jammo-mentor.h"

#include "sequencer_track_view.h"
#include "sequencer.h"
#include "midi_editor.h"
#include "instrument_gui.h"
#include "jammer_view.h"
#include "startmenu.h"

#include "../../cem/cem.h"
static int width_of_slot = 40;




//We get these as parameters
static int number_of_slots = -1;

gboolean pressed_sequencer_button_mute (TangleButton *tanglebutton, gpointer user_data);
gboolean pressed_sequencer_button_volume (TangleButton *tanglebutton, gpointer user_data);
gboolean pressed_sequencer_button_track_label (TangleButton *tanglebutton, gpointer data);

//We want toggle this up, when next is clicked
TangleButton* last_pressed_volume_button = NULL;



/*
 * Event for pressing label of track.
 * data is track_view when saved game is loaded (and actors are created from c)
 * else name of buttons parent (=control-panel-widget) is used for jammo_get_actor_by_id (actors created from json)
 */
gboolean pressed_sequencer_button_track_label (TangleButton *tanglebutton, gpointer data) {
	ClutterActor* control_panel_for_this_track = clutter_actor_get_parent(CLUTTER_ACTOR(tanglebutton));
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(control_panel_for_this_track));
	TangleWidget* track_view;

	if (data) //Check if data contains track-view (when loading game from file)
		track_view = TANGLE_WIDGET(data);
	else //Check if name contains id of track-view (when starting from level.json)
		track_view = TANGLE_WIDGET(jammo_get_actor_by_id(name));

	if (track_view==NULL) {
		cem_add_to_log("Can't find what track is asked",J_LOG_USER_ACTION);
		return FALSE;
	}

	cem_add_to_log("Pressed track label",J_LOG_USER_ACTION);
	if (JAMMO_IS_MIDITRACK_VIEW(track_view))
	{
		cem_add_to_log("It is instrument track",J_LOG_USER_ACTION);
		tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));
		//We can start realtime jamming or midi-editor.
		//Midi-editor backs always to sequencer.
		//From Jamming we can go back to sequencer or reach editor
		//TODO: some way to go straight to editor.

		//jamming
		instrument_gui_start(JAMMO_MIDITRACK_VIEW(track_view), NULL); //NULL means no slider

		//editor
		//JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
		//midi_editor_start_with_miditrack_view(JAMMO_MIDITRACK_VIEW(track_view), sequencer);
	}
	else if (JAMMO_IS_TRACK_VIEW(track_view))
	{
		const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(track_view));
		//printf("It is slider track or backing-track\n");
		TangleWidget* container2 = TANGLE_WIDGET(track_view);
		JammoTrack* track;
		g_object_get(track_view,"track",&track,NULL);
		if (JAMMO_IS_SLIDER_TRACK(track)) {
			cem_add_to_log(" Slider_track pressed",J_LOG_USER_ACTION);
			tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));
			instrument_gui_start(NULL, container2); //NULL means no keyboard, but slider
		}
		else if (JAMMO_IS_BACKING_TRACK(track)){
			if (name && strcmp(name,"singing")==0)
				{
				cem_add_to_log(" Singing track pressed",J_LOG_USER_ACTION);
				clutter_actor_show(jammo_get_actor_by_id("singing-view"));
				clutter_actor_hide(jammo_get_actor_by_id("fullsequencer-view"));
				}
			else
			{
			cem_add_to_log(" Backing_track pressed",J_LOG_USER_ACTION);
			clutter_actor_show(jammo_get_actor_by_id("backingtrack-selection-view"));
			clutter_actor_hide(jammo_get_actor_by_id("fullsequencer-view"));
			}
		}

	}
	else if  (JAMMO_IS_EDITING_TRACK_VIEW(track_view)){
			cem_add_to_log(" Editing_track pressed",J_LOG_USER_ACTION);
			const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(track_view));
			if (name && strcmp(name,"jammer")==0)
				{
				cem_add_to_log("  Jammer_track pressed",J_LOG_USER_ACTION);
				tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));
				clutter_actor_show(jammo_get_actor_by_id("jammer-view"));
				clutter_actor_hide(jammo_get_actor_by_id("fullsequencer-view"));
				start_jammer();}
			else 
				{
				cem_add_to_log("  Do nothing",J_LOG_USER_ACTION);
				}
		}
	return TRUE;
}


/*JSON callback. TODO
*/
gboolean fullsequencer_mentor_clicked (TangleButton *tanglebutton, gpointer data)   {
	cem_add_to_log("fullsequencer_mentor_clicked",J_LOG_USER_ACTION);
	return TRUE;
}

/*
 * data is track_view when saved game is loaded (and actors are created from c)
 * else name of buttons parent (=control-panel-widget) is used for jammo_get_actor_by_id (actors created from json)
 */
gboolean pressed_sequencer_button_mute (TangleButton *tanglebutton, gpointer data)   {
	ClutterActor* control_panel_for_this_track = clutter_actor_get_parent(CLUTTER_ACTOR(tanglebutton));
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(control_panel_for_this_track));
	gchar* message = g_strdup_printf("mute clicked '%s'",name);
	cem_add_to_log(message,J_LOG_USER_ACTION);
	g_free(message);

	TangleWidget* track_view;

	ClutterActor* container = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	if (data)
		track_view=TANGLE_WIDGET(data);
	else
		track_view = TANGLE_WIDGET(tangle_widget_get_nth_child(TANGLE_WIDGET(container),atoi(name)));

	JammoPlayingTrack* jammotrack;

	//slider is inside tangle_widget, midi- and loop-tracks are inside of jammo-*track-view
	if (JAMMO_IS_EDITING_TRACK_VIEW(track_view) || JAMMO_IS_MIDITRACK_VIEW(track_view)  || JAMMO_IS_TRACK_VIEW(track_view) ) {
		g_object_get(track_view, "track", &jammotrack, NULL);
	} else if (TANGLE_IS_WIDGET(track_view)) {
		jammotrack = JAMMO_PLAYING_TRACK(g_object_get_data(G_OBJECT(track_view),"track"));
	} else  {
		return FALSE;
	}

	if (jammotrack)
		jammo_playing_track_set_muted(JAMMO_PLAYING_TRACK(jammotrack), tangle_button_get_selected(tanglebutton));

	return TRUE;
}



/**
This syncs scrollers offset to tracks volume.
*/
gboolean sequencer_volumebar_used (ClutterActor *scroll_action, gpointer none){
	//printf("sequencer_volumebar_used\n");
	if (!last_pressed_volume_button)
		return FALSE;

	ClutterActor* volume_scroller = clutter_actor_meta_get_actor(CLUTTER_ACTOR_META(scroll_action));
	//-50 is height of the visible marker.
	gfloat height = clutter_actor_get_height(CLUTTER_ACTOR(volume_scroller))-50;
	gfloat offset,not_used;
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(scroll_action), &not_used,&offset);

	JammoPlayingTrack* jammotrack = g_object_get_data(G_OBJECT(volume_scroller),"track");

	gfloat new_volume = offset/height; //This is between [0...1]
	if (jammo_playing_track_get_volume(jammotrack) == new_volume)
		return FALSE;

	jammo_playing_track_set_volume(jammotrack,new_volume);

	gchar* message = g_strdup_printf("Volume changed to %f",new_volume);
	cem_add_to_log(message,J_LOG_USER_ACTION);
	g_free(message);

	//These are for changing texture of volume-button
	ClutterActor* container = tangle_button_get_normal_background_actor(last_pressed_volume_button);
	ClutterActor* nub = tangle_widget_get_nth_child(TANGLE_WIDGET(container),0);

	ClutterActor* container2 = tangle_button_get_selected_background_actor(last_pressed_volume_button);
	ClutterActor* nub2 = tangle_widget_get_nth_child(TANGLE_WIDGET(container2),0);

	gfloat height_ = 36; //clutter_actor_get_height(container) - clutter_actor_get_height(nub); //If hided. container reports it's height wrongly
	//printf("height_: %f\n",height_);

	clutter_actor_set_y(nub,height_-new_volume*height_);
	clutter_actor_set_y(nub2,height_-new_volume*height_);
	return FALSE;
}



/**
Each tracks share one volumebar.
  data is track_view when saved game is loaded (and actors are created from c)
  else name of buttons parent (=control-panel-widget) is used for jammo_get_actor_by_id (actors created from json)
*/
gboolean pressed_sequencer_button_volume (TangleButton *tanglebutton, gpointer data) {

	ClutterActor* control_panel_for_this_track = clutter_actor_get_parent(CLUTTER_ACTOR(tanglebutton));
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(control_panel_for_this_track));
	gchar* message = g_strdup_printf("volume clicked '%s'",name);
	cem_add_to_log(message,J_LOG_USER_ACTION);
	g_free(message);

	TangleWidget* track_view;

	ClutterActor* container = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	if (data)
		track_view=TANGLE_WIDGET(data);
	else
		track_view = TANGLE_WIDGET(tangle_widget_get_nth_child(TANGLE_WIDGET(container),atoi(name)));

	JammoPlayingTrack* jammotrack;

	ClutterActor* volume_container = jammo_get_actor_by_id("fullsequencer-volumebar-container");
	ClutterActor* volume_scroller = jammo_get_actor_by_id("fullsequencer-volumebar-scroller");
	ClutterAction* scroll_action = tangle_actor_get_action_by_type(volume_scroller,TANGLE_TYPE_SCROLL_ACTION);


	//slider and backingtrack is inside tangle_widget, midi- and loop-tracks are inside of jammo-*track-view
	if (JAMMO_IS_EDITING_TRACK_VIEW(track_view) || JAMMO_IS_MIDITRACK_VIEW(track_view)  || JAMMO_IS_TRACK_VIEW(track_view) ) {
		g_object_get(track_view, "track", &jammotrack, NULL);
	} else if (TANGLE_IS_WIDGET(track_view)) {
		jammotrack = JAMMO_PLAYING_TRACK(g_object_get_data(G_OBJECT(track_view),"track"));
	} else  {
		return FALSE;
	}

	gfloat current_volume = jammo_playing_track_get_volume(jammotrack);
	//printf("volume of this track is :%f\n",current_volume);

	//When pressing already selected track, hide volume bar
	if (last_pressed_volume_button==tanglebutton) {
		clutter_actor_hide(volume_container);
		g_object_set_data(G_OBJECT(volume_scroller),"track",NULL);
		last_pressed_volume_button=NULL;
	}

	//Hide last pressed and put new value to volumebar from track
	else {
		clutter_actor_show(volume_container);
		//-50 is height of the visible marker.
		gfloat new_place = (clutter_actor_get_height(CLUTTER_ACTOR(volume_scroller))-50)*current_volume;
		//printf("new place: %f\n",new_place);
		tangle_object_animate(G_OBJECT(scroll_action),  CLUTTER_EASE_IN_OUT_QUAD, 50, "offset-y", new_place, NULL);
		g_object_set_data(G_OBJECT(volume_scroller),"track",jammotrack);
		if (last_pressed_volume_button)
			tangle_button_set_selected(last_pressed_volume_button,FALSE);
		last_pressed_volume_button=tanglebutton;
		}

	return FALSE;
}




//JSON callback
void fullsequencer_on_cursor_notify_x(GObject* object, GParamSpec* param_spec, gpointer user_data) {
	//printf("fullsequencer_on_cursor_notify_x\n");

	ClutterActor* scrolling_view = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	ClutterAction* scroll_action = tangle_actor_get_action_by_type(scrolling_view,TANGLE_TYPE_SCROLL_ACTION);

	gfloat x, visible, offset, max;

	g_object_get(object, "x", &x, NULL);
	g_object_get(scrolling_view, "width", &visible, NULL);
	g_object_get(scroll_action, "offset-x", &offset, "max-offset-x", &max, NULL);
	//printf("x=%f, visible-width =%f, offset=%f, max=%f\n",x,visible,offset,max);

	if (x < offset) {
		offset = x - visible + 80.0;
		if (offset < 0.0) {
			offset = 0.0;
		}
		tangle_object_animate(G_OBJECT(scroll_action),  CLUTTER_EASE_IN_OUT_QUAD, 250, "offset-x", offset, NULL);
	} else if (x > offset + visible - 80.0) {
		offset += 160.0;
		if (offset > max) {
			offset = max;
		}
		tangle_object_animate(G_OBJECT(scroll_action),  CLUTTER_EASE_IN_OUT_QUAD, 250, "offset-x", offset, NULL);
	}
}

/***************************
Functions for json
**************************/



void fullsequencer_play_clicked (TangleButton* tanglebutton, gpointer none){
	gchar* message = g_strdup_printf("fullsequencer: Play-Stop-Button pressed clicked");
	cem_add_to_log(message,J_LOG_USER_ACTION);
	g_free(message);

	//Button is (tangle-)binded to sequencer, so there are nothing to do.
}


/*
Play-button is made by template. When it is taken in use, this function is called.
*/
void fullsequencer_play_loaded (TangleButton* tanglebutton, gpointer none){
	//printf("fullsequencer: Play-Stop-Button LOADED\n");
	g_signal_handlers_disconnect_by_func(tanglebutton, fullsequencer_play_loaded, NULL);
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));

 TangleBinding* binding;
 binding = tangle_binding_new(G_OBJECT(tanglebutton), "selected", G_OBJECT(sequencer), "play");
}



void fullsequencer_community_clicked (TangleButton* tanglebutton, gpointer none){
	printf("fullsequencer: Community pressed. Doesn't do anything\n");
}




/*
Also prepare cursor.
*/

void sequencer_track_view_tune_width() {
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	guint64 duration;
	duration = jammo_sequencer_get_duration(sequencer);

	g_print("Duration: %" G_GUINT64_FORMAT "\n", duration);

	gint tempo_factory = 4;
	//We want operate whole time with guint64.
	guint64 temp=60*tempo_factory;
	guint64 one_second = 1000000000L;
	guint64 big = temp * one_second;
	guint64 duration_of_one_slot = big / jammo_sequencer_get_tempo(sequencer);

	gint n_slots = duration/duration_of_one_slot;
	printf("*number_of_slots (in backing-track / for editing-track): %d\n",n_slots);


	//Set static
	number_of_slots = n_slots;

	//CURSOR IS NOT USED
	//CURSOR
//	gfloat width_of_area = number_of_slots*width_of_slot;
//	ClutterActor* cursor;
//	cursor = jammo_get_actor_by_id("fullsequencer_cursor");
//	if (cursor)
//		clutter_actor_set_size(cursor, width_of_area, 80.0); //width is important, height is not used
}





//Loading saved games
static int track_height=50;

//Creates control-panel for given track_view.
static void create_control_panel_entry(ClutterActor* track_view_actor, ClutterActor* label, gchar* name_of_track_view, gboolean muted, gfloat volume) {

	ClutterActor* panel_widget = tangle_widget_new();
	tangle_widget_set_layout(TANGLE_WIDGET(panel_widget), tangle_box_layout_new());
	//default direction is good: "direction": "ltr-ttb"

	//This is only for log-messages
	g_object_set(panel_widget, "name",name_of_track_view, NULL);

	//Label
	tangle_widget_add(TANGLE_WIDGET(panel_widget),label,NULL);

	//Mute
	ClutterActor* mute_button = tangle_button_new_selectable_with_background_actors (
       clutter_texture_new_from_file("/opt/jammo/sequencer/button_mute.png", NULL), /* normal */
       clutter_texture_new_from_file("/opt/jammo/sequencer/button_mute_pressed.png", NULL),  /* interactive */
       clutter_texture_new_from_file("/opt/jammo/sequencer/button_mute_pressed.png", NULL)); /* selected */
	clutter_actor_set_size(mute_button, track_height-4,track_height-4); //it is square. Four pixels marginal
	tangle_button_set_selected(TANGLE_BUTTON(mute_button),muted);

	g_signal_connect(mute_button, "clicked", G_CALLBACK(pressed_sequencer_button_mute), track_view_actor);
	tangle_widget_add(TANGLE_WIDGET(panel_widget),mute_button,NULL);

	//Volume-button
	// It is toggle-button. Both states are tangle_widgets with background+nub
	ClutterActor* volume_background = clutter_texture_new_from_file("/opt/jammo/sequencer/small_volume_background.png", NULL);
	ClutterActor* volume_background2 = clutter_texture_new_from_file("/opt/jammo/sequencer/small_volume_background.png", NULL);
	ClutterActor* volume_nub = clutter_texture_new_from_file("/opt/jammo/sequencer/small_volume_button.png", NULL);
	ClutterActor* volume_nub_selected = clutter_texture_new_from_file("/opt/jammo/sequencer/small_volume_button_selected.png", NULL);

	ClutterActor* volume_button_idle = tangle_widget_new();
	ClutterActor* volume_button_selected = tangle_widget_new();

	g_object_set(volume_button_idle, "background-actor", volume_background, NULL);
	g_object_set(volume_button_selected, "background-actor", volume_background2,NULL);

	tangle_widget_add(TANGLE_WIDGET(volume_button_idle),volume_nub,NULL);
	tangle_widget_add(TANGLE_WIDGET(volume_button_selected),volume_nub_selected,NULL);

	ClutterActor* volume_button = tangle_button_new_selectable_with_background_actors (
       volume_button_idle,/* normal */
       volume_button_selected,  /* interactive */
       volume_button_selected); /* selected */

	clutter_actor_set_size(volume_button, track_height-4,track_height-4); //it is square. Four pixels marginal
	tangle_button_set_selected(TANGLE_BUTTON(volume_button),muted);

	g_signal_connect(volume_button, "clicked", G_CALLBACK(pressed_sequencer_button_volume), track_view_actor);
	tangle_widget_add(TANGLE_WIDGET(panel_widget),volume_button,NULL);


	ClutterActor* container;
	container = jammo_get_actor_by_id("fullsequencer-track-control-panel");
	clutter_container_add_actor(CLUTTER_CONTAINER(container),panel_widget);
	clutter_actor_set_height(container,clutter_actor_get_height(container)+track_height);
}



ClutterActor* sequencer_track_view_create_editing_track(gboolean muted, gfloat volume, gint e_type, gchar* name_of_track_view) {
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	guint64 duration_of_tracks = jammo_sequencer_get_duration(sequencer);
	//printf("Making editing track (duration: %" G_GUINT64_FORMAT ")\n", duration_of_tracks);

	guint64 duration_of_one_slot = duration_of_tracks / number_of_slots;
	ClutterActor *label;
	gchar* name_of_label_button="";
	JammoTrack* track;

	//MEAM-track
	track = JAMMO_TRACK(jammo_editing_track_new_fixed_duration(duration_of_tracks));
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track));

	//CHUM-track-view
	ClutterActor* track_view_actor = jammo_editing_track_view_new(JAMMO_EDITING_TRACK(track),
          number_of_slots, duration_of_one_slot, width_of_slot, track_height);
	clutter_actor_set_reactive(track_view_actor, TRUE);
	g_object_set(track_view_actor, "line-every-nth-slot", 1, "sample-type", e_type,
        "name", name_of_track_view,
        "reactive", TRUE,
        NULL);
	//logging of this track:
	g_signal_connect(track_view_actor, "show-completed", G_CALLBACK(fullsequencer_trackview_loaded), NULL);

	//Add track-view to container
	ClutterActor* container = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	clutter_container_add_actor(CLUTTER_CONTAINER(container),track_view_actor);
	clutter_actor_set_height(container,clutter_actor_get_height(container)+(float)track_height);


	//Choose label-image and set color of track
	ClutterColor sample_color =  { 0, 0, 0, 255 };
	if (e_type == JAMMO_SAMPLE_RHYTMICAL) {
		name_of_label_button = "/opt/jammo/sequencer/label_loop_rhythm.png";
		sample_color.red   = 255;
		sample_color.green = 155;
		sample_color.blue  = 0;
	}
	else if (e_type == JAMMO_SAMPLE_MELODICAL) {
		name_of_label_button = "/opt/jammo/sequencer/label_loop_melody.png";
		sample_color.red   = 0;
		sample_color.green = 0;
		sample_color.blue  = 155;
	}
	else if (e_type == JAMMO_SAMPLE_HARMONICAL) {
		name_of_label_button = "/opt/jammo/sequencer/label_loop_harmony.png";
		sample_color.red   = 200;
		sample_color.green = 0;
		sample_color.blue  = 0;
	}
	else if (e_type == JAMMO_SAMPLE_EFFECT) {
		name_of_label_button = "/opt/jammo/sequencer/label_loop_effect.png";
		sample_color.red    = 0;
		sample_color.green  = 155;
		sample_color.blue   = 0;
	}
	else {//Some sane default value
		name_of_label_button = "/opt/jammo/sequencer/label_loop_effect.png";
		sample_color.alpha   = 0;
	}

	g_object_set(track_view_actor, "sample-color", &sample_color, NULL);

	label = tangle_button_new_with_background_actors (
       clutter_texture_new_from_file(name_of_label_button, NULL), /* normal */
       clutter_texture_new_from_file(name_of_label_button, NULL));  /* interactive TODO*/
	g_signal_connect(label, "clicked", G_CALLBACK(pressed_sequencer_button_track_label), track_view_actor);

	create_control_panel_entry(track_view_actor, label, name_of_track_view, muted, volume);


	return track_view_actor;
}

ClutterActor* sequencer_track_view_create_instrument_track(gboolean muted, gfloat volume, gint instrument_type, gchar* name_of_track_view) {
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	guint64 duration_of_tracks = jammo_sequencer_get_duration(sequencer);
	//printf("Making editing track (duration: %" G_GUINT64_FORMAT ")\n", duration_of_tracks);

	guint64 duration_of_one_slot = duration_of_tracks / number_of_slots;
	ClutterActor *label;
	gchar* name_of_label_button="";
	JammoTrack* track;
	ClutterActor* track_view_actor;

	//MEAM-track
	track = JAMMO_TRACK(jammo_instrument_track_new(instrument_type));
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track));

	// TODO set transpose. Key of the song should be stored somewhere
	//instrument_gui_set_transpose('c'); This might be useless?

	//CHUM-track-view
	//TODO: we need to know highest_note and lowest_note for this instrument!
	track_view_actor = jammo_miditrack_view_new(JAMMO_INSTRUMENT_TRACK(track),
				number_of_slots*4,       //Miditrack-view uses more narrow slots
				duration_of_one_slot/4,
				width_of_slot, track_height, //height can be anything, we zoom it
				59,36);  //Highest-note and lowest-note. TODO: should be asked from instrumet
	jammo_miditrack_view_zoom_to_fit(JAMMO_MIDITRACK_VIEW(track_view_actor), number_of_slots*width_of_slot,track_height);
	jammo_miditrack_view_set_show_grid(JAMMO_MIDITRACK_VIEW(track_view_actor),FALSE);

	//Add track-view to container
	ClutterActor* container = jammo_get_actor_by_id("fullsequencer-container-for-tracks");
	clutter_container_add_actor(CLUTTER_CONTAINER(container),track_view_actor);
	clutter_actor_set_height(container,clutter_actor_get_height(container)+(float)track_height);

	if (instrument_type==1) //Drum
		name_of_label_button = "/opt/jammo/sequencer/label_drum.png";
	else
		name_of_label_button = "/opt/jammo/sequencer/label_keyboard.png";

	label = tangle_button_new_with_background_actors (
       clutter_texture_new_from_file(name_of_label_button, NULL), /* normal */
       clutter_texture_new_from_file(name_of_label_button, NULL));  /* interactive TODO*/
	g_signal_connect(label, "clicked", G_CALLBACK(pressed_sequencer_button_track_label), track_view_actor);


	create_control_panel_entry(track_view_actor, label, name_of_track_view, muted, volume);

	return track_view_actor;
}

