#ifndef COMMUNITY_UTILITIES_H
#define COMMUNITY_UTILITIES_H

#include "../jammo.h"
#include "../../configure.h"
#include <libintl.h>
#include "../../gems/gems_profile_manager.h"

#define DESTROY_ACTOR(x) {if(x==0); else{clutter_actor_destroy(x); x = 0;}}
#define TEXT_COMMENT 1
#define VOICE_COMMENT 2
#define MAX_FILES_IN_DIR 50
#define MAX_FILE_NAME_LEN 60

typedef struct{
	ClutterActor *body;
	ClutterActor *hair;
	ClutterActor *head;
	ClutterActor *instrument;
}Avatar; 


typedef struct forum_msg {
	gint  index;
	guint32 user_id;
	gchar sender[20];	
	gchar title[100];
	gchar time[17];
	gchar *msg;
	gchar *filepath;
	int type;
}message;


typedef struct {
	ClutterActor *text;
	int lineCount;
	gulong handler_id;
}TextField;

typedef struct{
	char time[19];
}time_type;

/*
*Function computes the length of the click.
*If the length of the click is more than 1 seconds, function to rename the item is called.
*Otherwise a function to play the appropriate music piece is called. 
*/
void song_name_press_action(ClutterActor*);
void rename_loop(ClutterActor *loopName, int type); 
void play_selected_loop(gchar* loopName);
void show_song_label(ClutterActor*);
void show_music_video(ClutterActor*);

/*
* Function clears container that may contain other containers.
*
* parameters:
* -listToClear is the container to be cleared
*
*/
void clear_container(ClutterContainer* listToClear);

/*
* Function creates buttons from each .png type file in the directory.
* 
* parameters:
* -path is the path of the directory
* -list is a container where the buttons are added
* -funtion is a pointer to a function which handles button press events
* -width is the width of the button
* -height is the height of the button
*
*/
gboolean add_images_from_directory(const char* path, ClutterContainer *list, GCallback function, int width, int height);

/*
* Function creates and adds a single button into container.
*
*parameters:
* -button is null pointer to a button to be created
* -list is a container where button is added
* -path is a path to image of the button
* -width is the width of the button
* -height is the height of the button
* -funtion is a pointer to a function which handles button press events
*
*/
gboolean add_single_button(ClutterActor* button, ClutterContainer* list, char* path, int width,int height, GCallback function);


time_type get_current_time();

/*
* A callback funtion that limits the line count of editable textfield.
*
*parameters:
*-pointer to a textfield structure
*
*/
void limit_line_count(TextField *text);

/*
* Frees dynamically allocated memory from GList that contains pointers to message structures.
*/
void clear_messagelist(GList*);

/*
* Computes the avatar from guint32 type number.
*
*paramters:
* -avatar is pointer to a Avatar struct, where the avatar will be created.
* -avatar_id tells the avatar type.
*/
gboolean community_get_avatar(Avatar* avatar, guint32 avatar_id);

/*
* Computes and saves guint32 type number from user avatar
*
*paramters:
* -avatar is pointer to a Avatar struct, which contains user avatar
*/
gboolean community_save_avatar(Avatar* avatar);

/*
* This function opens directory, and sorts files in alphabetical order.
* Files must be sorted because file order from opendir() may be different in each device.
*
*parameters: 
* -path is full path of directory to be opened
* -suffix defines which type files will be sorted, other files are ignored
*   (if suffix is "DIR", only directories are listed)
* -result is an array of strings that contains filenames in order when this funtion returns
*
* returns number of files found
*/
int community_open_and_arrange_dir(char* path, char* suffix, char result[MAX_FILES_IN_DIR][MAX_FILE_NAME_LEN]);

/*
* Transforms avatar into smaller scale, so it can be used in thread-views.
*
*parameters:
* -avatar is the avatar to be scaled
* -avatarBackground is container, where avatar will be set
*/
void community_shrink_and_set_avatar(Avatar* avatar, ClutterContainer *avatarBackground);

/*
* Funtion frees GList that contains pointers to dynamically allocated profile_view_params structures
*/
void community_clear_paramslist(GList* paramsList);

#endif
