#include <stdlib.h> //getenv(home)
#include "configure.h"
#include <glib.h>
#include <stdio.h>

static gchar* JAMMO_DIRECTORY=NULL;        //This is used on both games (e.g for log-files)
static gchar* COMPOSITIONS_DIRECTORY=NULL; //3-6 composings
static gchar* SINGINGS_DIRECTORY=NULL;     //3-6 singings
static gchar* PROJECTS_DIRECTORY=NULL;     //7-12 working versions
static gchar* FINALIZED_DIRECTORY=NULL;    //7-12 audio files
static gchar* LOG_DIRECTORY=NULL;    	   //Log files

static void make_directory(gchar* directory) {
	gchar* cmd;

	cmd= g_strdup_printf("mkdir -p %s",directory);
	if (system(cmd)) {
		printf("Configure: Can't call '%s' \n", cmd);
	}
	g_free(cmd);
}

/*
 * TRUE = 3-6 game
 * FALSE = 7-12 game
 */
void configure_init_directories(gboolean small_game){
	gchar* home = getenv ("HOME");

	#ifdef N900
	JAMMO_DIRECTORY = g_strdup_printf("%s/MyDocs/jammo",home);
	#else
	JAMMO_DIRECTORY = g_strdup_printf("%s/.jammo",home);
	#endif

	make_directory(JAMMO_DIRECTORY);


	if (small_game) {
		COMPOSITIONS_DIRECTORY = g_strdup_printf("%s/compositions",JAMMO_DIRECTORY);
		SINGINGS_DIRECTORY = g_strdup_printf("%s/singings",JAMMO_DIRECTORY);
		LOG_DIRECTORY = g_strdup_printf("%s/logs3_6",JAMMO_DIRECTORY);

		make_directory(COMPOSITIONS_DIRECTORY);
		make_directory(SINGINGS_DIRECTORY);

		//file for pen-gesture-login
		gchar* cmd;
		cmd = g_strdup_printf("touch %s/pg-passwords",configure_get_jammo_directory());
		if (system(cmd)) {
			printf("Configure: Can't call '%s' \n", cmd);
		}
		g_free(cmd);
	}

	else	{
		PROJECTS_DIRECTORY = g_strdup_printf("%s/projects",JAMMO_DIRECTORY);
		FINALIZED_DIRECTORY = g_strdup_printf("%s/finalized",JAMMO_DIRECTORY);
		LOG_DIRECTORY = g_strdup_printf("%s/logs7_12",JAMMO_DIRECTORY);

		make_directory(PROJECTS_DIRECTORY);
		make_directory(FINALIZED_DIRECTORY);
	}

	make_directory(LOG_DIRECTORY);
}

void configure_release_directories(){
	if (JAMMO_DIRECTORY) g_free(JAMMO_DIRECTORY);
	if (COMPOSITIONS_DIRECTORY) g_free(COMPOSITIONS_DIRECTORY);
	if (SINGINGS_DIRECTORY) g_free(SINGINGS_DIRECTORY);
	if (PROJECTS_DIRECTORY) g_free(PROJECTS_DIRECTORY);
	if (FINALIZED_DIRECTORY) g_free(FINALIZED_DIRECTORY);
	if (LOG_DIRECTORY) g_free(LOG_DIRECTORY);
}



gchar* configure_get_jammo_directory(){
	return JAMMO_DIRECTORY;
}

gchar* configure_get_compositions_directory(){
	return COMPOSITIONS_DIRECTORY;
}

gchar* configure_get_singings_directory(){
	return SINGINGS_DIRECTORY;
}

gchar* configure_get_projects_directory(){
	return PROJECTS_DIRECTORY;
}

gchar* configure_get_finalized_directory(){
	return FINALIZED_DIRECTORY;
}
gchar* configure_get_log_directory(){
	return LOG_DIRECTORY;
}
