/*
License: GPLv2, read more from COPYING

This file contains the functionality of help menu.
 */
#include <tangle.h>
#include <string.h>
#include "communitymenu.h"
#include "startmenu.h"
#include "../jammo.h"
#include "mysongs.h"
#include "community_utilities.h"

#include "../../configure.h"
#include "../file_helper.h"
#include "sequencer.h" //From mysongs to sequencer

static ClutterContainer *songlist = 0;
static gint listItemHeight = 0;
int linenum = 1;

void start_mysongs()
{
	puts("Starting Mysongs\n");

	int numberOfLoops = 0;
	GList* l; //Iterator
	GList* projects=NULL;
	GList* finalized=NULL;

	clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");

	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* help_view = jammo_get_actor_by_id("mysongs-view");

	if(help_view)
	{
		clutter_actor_show(CLUTTER_ACTOR(help_view));
		//Project-files:
		projects = file_helper_get_all_files(configure_get_projects_directory());

		//Audio-files:
		finalized = file_helper_get_all_files(configure_get_finalized_directory());

		numberOfLoops += g_list_length (projects) + g_list_length (finalized);


		if(numberOfLoops > 5)
			songlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-scrollable"));	

		else
			songlist = CLUTTER_CONTAINER(jammo_get_actor_by_id("mysongs-songs-list-unscrollable"));	

		clutter_actor_lower(CLUTTER_ACTOR(songlist),jammo_get_actor_by_id("mysongs_down-index"));
		for (l = projects ; l; l = l->next)
		{
			mysongs_add_loop_to_list(l->data, 0); //0=project-file
		}

		for (l = finalized; l; l = l->next)
		{
			mysongs_add_loop_to_list(l->data, 1); //1=finalized file
		}

		if(numberOfLoops <= 6)
			clutter_actor_set_height(CLUTTER_ACTOR(songlist), listItemHeight * numberOfLoops);

		else
			clutter_actor_set_height(CLUTTER_ACTOR(songlist), listItemHeight * 6);


		ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(songlist), TANGLE_TYPE_SCROLL_ACTION);

		g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(mysongs_autoscroll_to_correct_pos), songlist);


	}

	else 	puts("can't find 'mysongs-view' ");
}

void mysongs_goto_communitymenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(songlist);
	start_communitymenu();
}

void mysongs_goto_startmenu(TangleButton *tanglebutton, gpointer none)
{
	clear_container(songlist);
	startmenu_goto_startmenu(tanglebutton, none);
}

gboolean mysongs_mentor_clicked (TangleButton *tanglebutton, gpointer data)   {
	printf("mentor clicked\n");

	return TRUE;
}

void mysongs_autoscroll_to_correct_pos(ClutterActor *listToScroll)
{
	gint slot;
	gfloat not_used, offset;

	ClutterAction *action = tangle_actor_get_action_by_type(listToScroll, TANGLE_TYPE_SCROLL_ACTION);
	
	tangle_scroll_action_get_offsets(TANGLE_SCROLL_ACTION(action), &not_used, &offset);

	slot = (gint)offset % (gint)listItemHeight < listItemHeight / 2 ? (gint)(offset) / listItemHeight  
							  		: (gint)(offset) / listItemHeight + 1;

	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_OUT_QUAD, 300, "offset-y", (gfloat)(slot*listItemHeight), NULL);
}

static void start_sequencer_with_this_file(ClutterActor *actor, gpointer none) {
	const char* filename = clutter_actor_get_name(actor);
	sequencer_start_with_file((char*)filename);
}

/*
 * Filename: contains fullpath
 * Type:
 * 0=work in progress (project)
 * 1=finalized work (no editing anymore)
 *
 *TODO: filename is just printed.
 */
gboolean mysongs_add_loop_to_list(char* filename, int type)
{
	ClutterColor text_color = { 255, 255, 255, 255 };
	ClutterActor *colorbar;

	switch (linenum){
		case 1:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar1.png",NULL);
			linenum++;
			break;
		case 2:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar4.png",NULL);
			linenum++;
			break;
		case 3:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar5.png",NULL);
			linenum++;
			break;
		case 4:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar7.png",NULL);
			linenum = 1;
			break;
		default:
			colorbar = clutter_texture_new_from_file("/opt/jammo/communitymenu/colorbar12.png",NULL);
			break;
	}

	int i, length; //29
	int y = 0;
	length = strlen(filename);

	char temp[length];
	char filename_for_textbutton[length];
	strcpy(temp, filename);

	if(type == 0){ //projects

		for(i=28; i<length-5; i++){
			filename_for_textbutton[y] = temp[i];
			y++;
		}
		filename_for_textbutton[y] = '\0';

	}else if(type == 1){ //songs

		for(i=29; i<length-4; i++){
			filename_for_textbutton[y] = temp[i];
			y++;
		}
		filename_for_textbutton[y] = '\0';
	}else{
		strcpy(filename_for_textbutton, filename);
	}

	ClutterActor *label = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
			"/opt/jammo/communitymenu/community_cdlabel_small.png", NULL));

	ClutterActor *video = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
			"/opt/jammo/communitymenu/community_videocamera_icon_small.png", NULL));

	ClutterActor *text = clutter_text_new_full("Comic Sans MS 14", filename_for_textbutton, &text_color);

	ClutterActor *infoButton = NULL;
	ClutterActor *textButton = NULL;

	textButton = tangle_button_new_with_background_actor(text);
	clutter_actor_set_name(textButton,filename);

	ClutterActor *arrowImage = clutter_texture_new_from_file("/opt/jammo/communitymenu/community_rightarrow.png", NULL);

	//Additinally of type, there can be another icon e.g. video missing, new comments
		if(type == 0) {//TODO
			infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_backtosequencer.png", NULL));

			clutter_actor_set_position(infoButton, 690, 1);

			g_signal_connect (textButton, "clicked", G_CALLBACK (start_sequencer_with_this_file),NULL);
		}
		else if(type == 1) {
			infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_comment_icon.png", NULL));

			clutter_actor_set_position(infoButton, 690, 15);

			//infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				//"/opt/jammo/communitymenu/community_cdlabel.png", NULL));

			//clutter_actor_set_height(infoButton, clutter_actor_get_height(colorbar));
			//g_signal_connect (textButton, "clicked", G_CALLBACK (jukebox_play_this),NULL); //TODO: implement	

			g_signal_connect_swapped(CLUTTER_ACTOR(textButton), "clicked", G_CALLBACK(play_selected_loop), filename);

			clutter_actor_set_position(label, 500, 15);
			clutter_actor_set_position(video, 580, 15);

		}
		else {
			infoButton = tangle_button_new_with_background_actor(clutter_texture_new_from_file(
				"/opt/jammo/communitymenu/community_avatarbackground_small.png", NULL));
		}


	ClutterContainer *listContainer = CLUTTER_CONTAINER(clutter_group_new());

	if(colorbar == NULL || infoButton == NULL || arrowImage == NULL)
	{
		printf("Failed to load Colorbar or infoButton\n");
		return FALSE;	
	}

	if(listItemHeight == 0) listItemHeight = clutter_actor_get_height(colorbar);

	clutter_container_add_actor(listContainer, colorbar);	//Add components inside the container

	if(type == 1){
		clutter_container_add_actor(listContainer, label);
		clutter_container_add_actor(listContainer, video);
	}

	clutter_actor_set_position(textButton, 60, 23);			
	clutter_container_add_actor(listContainer, textButton);
	
	clutter_actor_set_position(arrowImage, 653, 15);
	clutter_container_add_actor(listContainer, arrowImage);
	
	clutter_container_add_actor(listContainer, infoButton);

	g_signal_connect_swapped(label, "clicked", G_CALLBACK(show_song_label), filename);
	g_signal_connect_swapped(video, "clicked", G_CALLBACK(show_music_video), filename);
	g_signal_connect_swapped(CLUTTER_ACTOR(infoButton), "clicked", G_CALLBACK(mysongs_comment), 
						clutter_actor_get_parent(infoButton));

	clutter_container_add_actor(songlist, CLUTTER_ACTOR(listContainer));

	return TRUE;
}

void mysongs_comment(ClutterActor *actor)
{
	GList *children = clutter_container_get_children(songlist); //Get list of actors
	GList *node = children;

	int index = 0;
	int found = 0;
	
	while(node != NULL)
	{
		index++;

		if(actor == node->data)
		{
			printf("Found it. Index %d\n", index);
			found = 1;
			break;
		}

		node = node->next;
	}

	g_list_free(children);
}
