 /*
License: GPLv2, read more from COPYING

This file contains the functionality of Help menu.
 */

#ifndef HELP_H_
#define HELP_H_

#include <glib-object.h>

#define MAX_QUESTIONS 15
#define MAX_COMMENTS 15

void start_helpdesk();
void helpdesk_goto_communitymenu(TangleButton *tanglebutton, gpointer none);
void helpdesk_goto_startmenu(TangleButton *tanglebutton, gpointer none);

void helpdesk_get_questions(void);
GList* helpdesk_get_number_of_questions(void);

//Functions for creating and moving loops
gboolean helpdesk_add_question_to_list(gpointer data, int index);
void helpdesk_autoscroll_to_correct_pos(ClutterActor *listToScroll);
void helpdesk_find_selected_actor(ClutterActor *actor);

//Signal functions
void helpdesk_add_question(void);

void helpdesk_show_question_view(ClutterActor *actor);
void helpdesk_show_helpdesk_view(void);
void helpdesk_show_addquestion_view(void);

void helpdesk_return_from_threads_view(GList *messagelist);
#endif 
