/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is center of 7-12 years full sequencer view.
View contains three part:
 *wheel-game (loop-view)
 *track-view
 *general-view (settings)

*/

#include <glib-object.h>
//#include <clutter/clutter.h>
#include <math.h>
#include <string.h>

#include <tangle.h>

#include "../../meam/jammo-meam.h"
#include "../../meam/jammo-slider-event.h"
#include "../../meam/jammo-slider-track.h"
#include "../../meam/jammo-backing-track.h"
#include "../../meam/jammo-metronome-track.h"

#include "../jammo.h"
#include "../jammo-mentor.h"
#include "../jammo-editing-track-view.h"
#include "../jammo-miditrack-view.h"
#include "../../cem/cem.h"

#include "sequencer.h"
#include "sequencer_loop.h"
#include "sequencer_track_view.h"
#include "startmenu.h"

#include "../jammo-game-task.h"
#include "../jammo-game-level.h"
#include "../jammo-game-level-view.h"

/*
Sequencer and sequencer-track-view-area are defined in json.

When sequencer starts: it calls load_state_from_file(load_only_backingtrack=TRUE)
 It starts loading backing-track.
 When backing_track is loaded (on_duration_notify)
  Tell sequencer_track_view_area that now duration is known (used e.g. with cursor)
  Then load_state_from_file(load_only_backingtrack=FALSE) loads another tracks.
*/

//This is The sequencer of the game. All 'play'-buttons should play this.
//All new tracks are added to this
//If metronome is enabled it is added to this
JammoSequencer* static_sequencer;
JammoMetronomeTrack* static_metronome_track;




gboolean sequencer_change_to_loop_view(TangleActor *actor, gpointer data) {
	printf("changing view to loop \n");
	ClutterActor* scrolling_view = jammo_get_actor_by_id("fullsequencer-view-container");
	ClutterAction* action = tangle_actor_get_action_by_type(scrolling_view,TANGLE_TYPE_SCROLL_ACTION);
	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_CIRC, 400, "offset-y", 0.0, NULL);
	return TRUE;
}

gboolean sequencer_change_to_sequencer_view(TangleActor *actor, gpointer data) {
	printf("changing view to sequencer \n");
	ClutterActor* scrolling_view = jammo_get_actor_by_id("fullsequencer-view-container");
	ClutterAction* action = tangle_actor_get_action_by_type(scrolling_view,TANGLE_TYPE_SCROLL_ACTION);
	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_CIRC, 400, "offset-y", 480.0, NULL);
	return TRUE;
}

gboolean sequencer_change_to_bottom_view (TangleActor *actor, gpointer data) {
	printf("changing view to bottom \n");
	ClutterActor* scrolling_view = jammo_get_actor_by_id("fullsequencer-view-container");
	ClutterAction* action = tangle_actor_get_action_by_type(scrolling_view,TANGLE_TYPE_SCROLL_ACTION);
	tangle_object_animate(G_OBJECT(action), CLUTTER_EASE_IN_CIRC, 400, "offset-y", 960.0, NULL);
	return TRUE;
}



//We want load saved composition only first time
static gboolean first_time = TRUE;


/* JSON callback when sequencer-view is showed*/
void start_sequencer_full_sequencer (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	if (first_time){
		gchar* filename = tangle_lookup_filename("seq.json"); //This is default
		start_sequencer(filename);
		g_free(filename);
	}
	first_time=FALSE;

}

/*
This actor is visible when starting jammo_get_actor_by_id("fullsequencer-view");
*/
void start_sequencer(gpointer filename)
{
	printf("Starting sequencer GUI\n");
	ClutterAction* action = tangle_actor_get_action_by_type(jammo_get_actor_by_id("fullsequencer-view-container"), TANGLE_TYPE_SCROLL_ACTION);
	g_signal_connect_swapped(action, "clamp-offset-y", G_CALLBACK(tangle_widget_clamp_child_boundaries), jammo_get_actor_by_id("fullsequencer-view-container"));

	static_sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	static_metronome_track = NULL;

	//inputFilename is global! (from sequencer.h)
	if (filename == NULL)
		inputFilename = NULL;
	else {
		inputFilename = malloc(strlen((gchar*) filename) + 1);
		memcpy(inputFilename, (gchar*) filename, strlen((gchar*) filename) + 1);
		printf("The filename is '%s'\n",inputFilename);
	}



	tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));


	JammoGameTask* task = jammo_game_level_get_active_task(JAMMO_GAME_LEVEL(jammo_get_object_by_id("game-level")));
	JammoGameTask* task2 = JAMMO_GAME_TASK(jammo_get_object_by_id("level1-task1.json"));
	if (task==task2)
		sequencer_loop_tune_wheels(task);
	else
		sequencer_loop_tune_wheels(NULL);

	sequencer_track_view_tune_width();


	sequencer_change_to_sequencer_view(NULL,NULL); //Start to middle view.
}

/*
void leave_sequencer()
{
	clutter_actor_hide(CLUTTER_ACTOR(sequencer_view));

	start_startmenu();
}
*/






/*
 * CallBack for JSON
 */
void fullsequencer_general_arrow_clicked (TangleButton *tanglebutton, gpointer user_data){
printf("up\n");
sequencer_change_to_sequencer_view(NULL,NULL);
}


void fullsequencer_general_tempo_clicked(TangleButton *tanglebutton, gpointer user_data) {
	const gchar* name=clutter_actor_get_name(CLUTTER_ACTOR(tanglebutton));
	printf("tempo clicked '%s'\n",name);
	if (name==NULL)
		return;

	int new_tempo = 110;
	if (strncmp(name,"fast",4)==0)
			new_tempo=130;
	else if (strncmp(name,"normal",6)==0)
			new_tempo=110;
	else if (strncmp(name,"slow",4)==0)
			new_tempo=90;
	printf("new tempo:%d\n",new_tempo);
	jammo_sequencer_set_tempo(static_sequencer, new_tempo);
}


void fullsequencer_general_pitch_clicked(TangleButton *tanglebutton, gpointer user_data) {
	const gchar* name=clutter_actor_get_name(CLUTTER_ACTOR(tanglebutton));
	printf("pitch clicked '%s'\n",name);
	if (name==NULL)
		return;

	gchar* new_pitch = "G";
	if (strncmp(name,"high",4)==0)
			new_pitch = "G";
	else if (strncmp(name,"normal",6)==0)
			new_pitch = "D";
	else if (strncmp(name,"low",3)==0)
			new_pitch = "A";
	printf("new pitch:'%s'\n",new_pitch);

	jammo_sequencer_set_pitch(static_sequencer, new_pitch);
}


void sequencer_render_button_pressed (TangleButton* tanglebutton, gpointer none){
	cem_add_to_log("sequencer_render_button_pressed",LOG_USER_ACTION);
}

void fullsequencer_metronome_clicked (TangleButton* tanglebutton, gpointer none){
	printf("fullsequencer: Metronome pressed\n");
	if (static_metronome_track==NULL) {
		static_metronome_track = jammo_metronome_track_new();
		jammo_sequencer_add_track(static_sequencer, JAMMO_TRACK(static_metronome_track));
		jammo_metronome_track_set_time_signature_beats(static_metronome_track,4);
		jammo_metronome_track_set_time_signature_note_value(static_metronome_track,4);
		jammo_metronome_track_set_accent(static_metronome_track,FALSE);
		jammo_playing_track_set_muted(JAMMO_PLAYING_TRACK(static_metronome_track), FALSE);
	}
	else
		jammo_playing_track_set_muted(JAMMO_PLAYING_TRACK(static_metronome_track), !tangle_button_get_selected(tanglebutton));
}
