#!/bin/sh

FOUND=no

if [ ! -f "$HOME/.ja2/ja2.ini" ]; then 
        mkdir -p $HOME/.ja2
	if [ -d "$HOME/MyDocs/ja2data/Data" ]; then 
		echo "data_dir = $HOME/MyDocs/ja2data" > $HOME/.ja2/ja2.ini
	fi
fi

if [ -f "$HOME/.ja2/ja2.ini" -a -d "`grep data_dir $HOME/.ja2/ja2.ini | awk '{print $3}'`/Data" ]; then 
        FOUND=yes
fi

if [ x"$FOUND" = x"no" ]; then
        cat <<EOF > /tmp/notice.txt
The Jagged Alliance 2 data files were not found on either
memory card.

JA2 expects a "ja2data" folder on MyDocs with
a "Data" folder from the CD present.
EOF
        maemo-confirm-text "Data files not found." /tmp/notice.txt
        rm -f /tmp/notice.txt
        exit 1
elif [ x"$FOUND" = x"yes" ]; then
	LAYOUT=`/usr/bin/gconftool-2 -g /apps/osso/inputmethod/int_kb_layout`
	/usr/bin/gconftool-2 -s /apps/osso/inputmethod/int_kb_layout us -t string
        /bin/sh -c "/usr/bin/ja2 -fullscreen"
        /usr/bin/gconftool-2 -s /apps/osso/inputmethod/int_kb_layout $LAYOUT -t string
fi
