#ifndef _SHOPKEEPER_QUOTES_H_
#define _SHOPKEEPER_QUOTES_H_


// COMMON shop keeper quote enums
enum
{
	// Quotes 0-9 are generic NPC quotes common to everyone and controlled by the normal NPC Dialogue system.
	//10
	SK_QUOTES_DEALER_OFFERED_MONEY_AS_A_GIFT = 10,
	SK_QUOTES_PLAYER_FIRST_ENTERS_SKI,
	SK_QUOTES_RANDOM_QUOTE_WHILE_PLAYER_DECIDING_1,
	SK_QUOTES_RANDOM_QUOTE_WHILE_PLAYER_DECIDING_2,
	SK_QUOTES_RANDOM_QUOTE_WHILE_ITEMS_CHOSEN_TO_TRADE,
	//15
	SK_QUOTES_RANDOM_QUOTE_WHILE_ITEMS_CHOSEN_TO_SELL_OR_REPAIR,
	SK_QUOTES_PLAYER_REQUESTED_EVALUATION,
	SK_QUOTES_DURING_EVALUATION_STUFF_REJECTED,
	SK_QUOTES_EVALUATION_RESULT_VALUE_OF_ZERO,
	SK_QUOTES_EVALUATION_RESULT_SOME_REALLY_DAMAGED_ITEMS,
	//20
	SK_QUOTES_EVALUATION_RESULT_NORMAL,
	SK_QUOTES_EVAULATION_PLAYER_DOESNT_HAVE_ENOUGH_VALUE,
	SK_QUOTES_PLAYER_HAS_EXACTLY_ENOUGH_MONEY_FOR_TRANSACTION,
	SK_QUOTES_PLAYER_HAS_TOO_MUCH_MONEY_FOR_TRANSACTION,
	SK_QUOTES_PRESSES_DONE_HAS_AT_LEAST_1_TRANSACTION,
	//25
	SK_QUOTES_PRESSED_DONE_HASNT_MADE_TRANSACTION,
	SK_QUOTES_PRESSED_DONE_STILL_HAS_STUFF_IN_OFFER_AREA,
	SK_QUOTES_CANT_AFFORD_TO_BUY_OR_TOO_MUCH_TO_REPAIR,

	NUM_COMMON_SK_QUOTES,

	// Quotes 28+ are NPC Specific, and are not under direct control of the SKI system.  The get used by .COD files
};


// Common quotes needed by SKI
#define SK_QUOTES_NOT_INTERESTED_IN_THIS_ITEM		4

// NPC SPECIFIC shopkeeper_quotes

#define FREDO_QUOTE_CAN_RESET_IMPRINTING				31

#define FREDO_PERKO_SORRY_REPAIR_DELAYED				29

#define ARNIE_QUOTE_NOT_REPAIRED_YET						33

#endif
