/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XEmbedCanvasPeer;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XException;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XDropTargetRegistry {
    private static final Logger logger = Logger.getLogger("sun.awt.X11.xembed.xdnd.XDropTargetRegistry");
    private static final long DELAYED_REGISTRATION_PERIOD = 200L;
    private static final XDropTargetRegistry theInstance = new XDropTargetRegistry();
    private final HashMap<Long, Runnable> delayedRegistrationMap = new HashMap();
    private final HashMap<Long, EmbeddedDropSiteEntry> embeddedDropSiteRegistry = new HashMap();
    private static final boolean XEMBED_PROTOCOLS = true;
    private static final boolean NON_XEMBED_PROTOCOLS = false;

    private XDropTargetRegistry() {
    }

    static XDropTargetRegistry getRegistry() {
        return theInstance;
    }

    private long getToplevelWindow(long window) {
        XWindowPeer toplevel;
        XBaseWindow candWindow = XToolkit.windowToXWindow(window);
        if (candWindow != null && (toplevel = candWindow.getToplevelXWindow()) != null && !(toplevel instanceof XEmbeddedFramePeer)) {
            return toplevel.getWindow();
        }
        do {
            if (!XlibUtil.isTrueToplevelWindow(window)) continue;
            return window;
        } while ((window = XlibUtil.getParentWindow(window)) != 0L);
        return window;
    }

    static final long getDnDProxyWindow() {
        return XWindow.getXAWTRootWindow().getWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EmbeddedDropSiteEntry registerEmbedderDropSite(long embedder) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
        List<XDropTargetProtocol> embedderProtocols = new ArrayList();
        while (dropTargetProtocols.hasNext()) {
            XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
            if (!dropTargetProtocol.isProtocolSupported(embedder)) continue;
            embedderProtocols.add(dropTargetProtocol);
        }
        embedderProtocols = Collections.unmodifiableList(embedderProtocols);
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            long root = 0L;
            long event_mask = 0L;
            XWindowAttributes wattr = new XWindowAttributes();
            try {
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                int status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), embedder, wattr.pData);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (status == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("XGetWindowAttributes failed");
                }
                event_mask = wattr.get_your_event_mask();
                root = wattr.get_root();
            }
            finally {
                wattr.dispose();
            }
            if ((event_mask & 0x400000L) == 0L) {
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), embedder, event_mask | 0x400000L);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("XSelectInput failed");
                }
            }
            EmbeddedDropSiteEntry embeddedDropSiteEntry = new EmbeddedDropSiteEntry(root, event_mask, embedderProtocols);
            return embeddedDropSiteEntry;
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProtocols(long embedder, boolean protocols, List<XDropTargetProtocol> supportedProtocols) {
        Iterator<XDropTargetProtocol> dropTargetProtocols = null;
        dropTargetProtocols = !supportedProtocols.isEmpty() ? supportedProtocols.iterator() : XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (dropTargetProtocols.hasNext()) {
                XDropTargetProtocol dropTargetProtocol;
                if (protocols != (dropTargetProtocol = dropTargetProtocols.next()).isXEmbedSupported()) continue;
                dropTargetProtocol.registerEmbedderDropSite(embedder);
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEmbedderDropSite(long embedder) {
        XBaseWindow xbaseWindow = XToolkit.windowToXWindow(embedder);
        if (xbaseWindow != null) {
            return;
        }
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        Iterator<XDropTargetProtocol> dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
        List<XDropTargetProtocol> embedderProtocols = new ArrayList();
        while (dropTargetProtocols.hasNext()) {
            XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
            if (!dropTargetProtocol.isProtocolSupported(embedder)) continue;
            embedderProtocols.add(dropTargetProtocol);
        }
        embedderProtocols = Collections.unmodifiableList(embedderProtocols);
        Long lToplevel = new Long(embedder);
        boolean isXEmbedServer = false;
        XDropTargetRegistry xDropTargetRegistry = this;
        synchronized (xDropTargetRegistry) {
            EmbeddedDropSiteEntry entry = this.embeddedDropSiteRegistry.get(lToplevel);
            if (entry == null) {
                return;
            }
            entry.setSupportedProtocols(embedderProtocols);
            isXEmbedServer = !entry.hasNonXEmbedClientSites();
        }
        dropTargetProtocols = !embedderProtocols.isEmpty() ? embedderProtocols.iterator() : XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (dropTargetProtocols.hasNext()) {
                XDropTargetProtocol dropTargetProtocol = dropTargetProtocols.next();
                if (isXEmbedServer && dropTargetProtocol.isXEmbedSupported()) continue;
                dropTargetProtocol.registerEmbedderDropSite(embedder);
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterEmbedderDropSite(long embedder, EmbeddedDropSiteEntry entry) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
        XlibWrapper.XGrabServer(XToolkit.getDisplay());
        try {
            while (dropTargetProtocols.hasNext()) {
                XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
                dropTargetProtocol.unregisterEmbedderDropSite(embedder);
            }
            long event_mask = entry.getEventMask();
            if ((event_mask & 0x400000L) == 0L) {
                XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), embedder, event_mask);
                XToolkit.RESTORE_XERROR_HANDLER();
                if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                    throw new XException("XSelectInput failed");
                }
            }
        }
        finally {
            XlibWrapper.XUngrabServer(XToolkit.getDisplay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEmbeddedDropSite(long toplevel, long window) {
        XBaseWindow xBaseWindow = XToolkit.windowToXWindow(window);
        boolean isXEmbedClient = xBaseWindow instanceof XEmbeddedFramePeer && ((XEmbeddedFramePeer)xBaseWindow).isXEmbedActive();
        XEmbedCanvasPeer peer = null;
        XBaseWindow xbaseWindow = XToolkit.windowToXWindow(toplevel);
        if (xbaseWindow != null) {
            if (xbaseWindow instanceof XEmbedCanvasPeer) {
                peer = (XEmbedCanvasPeer)xbaseWindow;
            } else {
                throw new UnsupportedOperationException();
            }
        }
        Long lToplevel = toplevel;
        EmbeddedDropSiteEntry entry = null;
        Object object = this;
        synchronized (object) {
            entry = this.embeddedDropSiteRegistry.get(lToplevel);
            if (entry == null) {
                if (peer != null) {
                    peer.setXEmbedDropTarget();
                    entry = new EmbeddedDropSiteEntry(0L, 0L, Collections.<XDropTargetProtocol>emptyList());
                } else {
                    entry = this.registerEmbedderDropSite(toplevel);
                    this.registerProtocols(toplevel, false, entry.getSupportedProtocols());
                }
                this.embeddedDropSiteRegistry.put(lToplevel, entry);
            }
        }
        assert (entry != null);
        object = entry;
        synchronized (object) {
            if (peer == null) {
                if (!isXEmbedClient) {
                    this.registerProtocols(toplevel, true, entry.getSupportedProtocols());
                } else {
                    Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
                    while (dropTargetProtocols.hasNext()) {
                        XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
                        if (!dropTargetProtocol.isXEmbedSupported()) continue;
                        dropTargetProtocol.registerEmbedderDropSite(window);
                    }
                }
            }
            entry.addSite(window, isXEmbedClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unregisterEmbeddedDropSite(long toplevel, long window) {
        Long lToplevel = toplevel;
        EmbeddedDropSiteEntry entry = null;
        XDropTargetRegistry xDropTargetRegistry = this;
        synchronized (xDropTargetRegistry) {
            entry = this.embeddedDropSiteRegistry.get(lToplevel);
            if (entry == null) {
                return;
            }
            entry.removeSite(window);
            if (entry.hasSites()) return;
            this.embeddedDropSiteRegistry.remove(lToplevel);
            XBaseWindow xbaseWindow = XToolkit.windowToXWindow(toplevel);
            if (xbaseWindow != null) {
                if (!(xbaseWindow instanceof XEmbedCanvasPeer)) throw new UnsupportedOperationException();
                XEmbedCanvasPeer peer = (XEmbedCanvasPeer)xbaseWindow;
                peer.removeXEmbedDropTarget();
            } else {
                this.unregisterEmbedderDropSite(toplevel, entry);
            }
            return;
        }
    }

    public long getEmbeddedDropSite(long embedder, int x, int y) {
        Long lToplevel = embedder;
        EmbeddedDropSiteEntry entry = this.embeddedDropSiteRegistry.get(lToplevel);
        if (entry == null) {
            return 0L;
        }
        return entry.getSite(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDropSite(long window) {
        if (window == 0L) {
            throw new IllegalArgumentException();
        }
        XDropTargetEventProcessor.activate();
        XToolkit.awtLock();
        try {
            long toplevel = this.getToplevelWindow(window);
            if (toplevel == 0L) {
                this.addDelayedRegistrationEntry(window);
                return;
            }
            if (toplevel == window) {
                Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
                while (dropTargetProtocols.hasNext()) {
                    XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
                    dropTargetProtocol.registerDropTarget(toplevel);
                }
            } else {
                this.registerEmbeddedDropSite(toplevel, window);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDropSite(long window) {
        if (window == 0L) {
            throw new IllegalArgumentException();
        }
        XToolkit.awtLock();
        try {
            long toplevel = this.getToplevelWindow(window);
            if (toplevel == window) {
                Iterator dropProtocols = XDragAndDropProtocols.getDropTargetProtocols();
                this.removeDelayedRegistrationEntry(window);
                while (dropProtocols.hasNext()) {
                    XDropTargetProtocol dropProtocol = (XDropTargetProtocol)dropProtocols.next();
                    dropProtocol.unregisterDropTarget(window);
                }
            } else {
                this.unregisterEmbeddedDropSite(toplevel, window);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void registerXEmbedClient(long canvasWindow, long clientWindow) {
        XDragSourceProtocol xdndDragProtocol = XDragAndDropProtocols.getDragSourceProtocol("XDnD");
        XDragSourceProtocol.TargetWindowInfo info = xdndDragProtocol.getTargetWindowInfo(clientWindow);
        if (info != null && info.getProtocolVersion() >= 3) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("        XEmbed drop site will be registered for " + Long.toHexString(clientWindow));
            }
            this.registerEmbeddedDropSite(canvasWindow, clientWindow);
            Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
            while (dropTargetProtocols.hasNext()) {
                XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
                dropTargetProtocol.registerEmbeddedDropSite(clientWindow);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("        XEmbed drop site has been registered for " + Long.toHexString(clientWindow));
            }
        }
    }

    public void unregisterXEmbedClient(long canvasWindow, long clientWindow) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("        XEmbed drop site will be unregistered for " + Long.toHexString(clientWindow));
        }
        Iterator dropTargetProtocols = XDragAndDropProtocols.getDropTargetProtocols();
        while (dropTargetProtocols.hasNext()) {
            XDropTargetProtocol dropTargetProtocol = (XDropTargetProtocol)dropTargetProtocols.next();
            dropTargetProtocol.unregisterEmbeddedDropSite(clientWindow);
        }
        this.unregisterEmbeddedDropSite(canvasWindow, clientWindow);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("        XEmbed drop site has beed unregistered for " + Long.toHexString(clientWindow));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDelayedRegistrationEntry(final long window) {
        Long lWindow = window;
        Runnable runnable = new Runnable(){

            public void run() {
                XDropTargetRegistry.this.removeDelayedRegistrationEntry(window);
                XDropTargetRegistry.this.registerDropSite(window);
            }
        };
        XToolkit.awtLock();
        try {
            this.removeDelayedRegistrationEntry(window);
            this.delayedRegistrationMap.put(lWindow, runnable);
            XToolkit.schedule(runnable, 200L);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDelayedRegistrationEntry(long window) {
        Long lWindow = window;
        XToolkit.awtLock();
        try {
            Runnable runnable = this.delayedRegistrationMap.remove(lWindow);
            if (runnable != null) {
                XToolkit.remove(runnable);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmbeddedDropSiteEntry {
        private final long root;
        private final long event_mask;
        private List<XDropTargetProtocol> supportedProtocols;
        private final HashSet<Long> nonXEmbedClientSites = new HashSet();
        private final List<Long> sites = new ArrayList<Long>();

        public EmbeddedDropSiteEntry(long root, long event_mask, List<XDropTargetProtocol> supportedProtocols) {
            if (supportedProtocols == null) {
                throw new NullPointerException("Null supportedProtocols");
            }
            this.root = root;
            this.event_mask = event_mask;
            this.supportedProtocols = supportedProtocols;
        }

        public long getRoot() {
            return this.root;
        }

        public long getEventMask() {
            return this.event_mask;
        }

        public boolean hasNonXEmbedClientSites() {
            return !this.nonXEmbedClientSites.isEmpty();
        }

        public synchronized void addSite(long window, boolean isXEmbedClient) {
            Long lWindow = window;
            if (!this.sites.contains(lWindow)) {
                this.sites.add(lWindow);
            }
            if (!isXEmbedClient) {
                this.nonXEmbedClientSites.add(lWindow);
            }
        }

        public synchronized void removeSite(long window) {
            Long lWindow = window;
            this.sites.remove(lWindow);
            this.nonXEmbedClientSites.remove(lWindow);
        }

        public void setSupportedProtocols(List<XDropTargetProtocol> list) {
            this.supportedProtocols = list;
        }

        public List<XDropTargetProtocol> getSupportedProtocols() {
            return this.supportedProtocols;
        }

        public boolean hasSites() {
            return !this.sites.isEmpty();
        }

        public long[] getSites() {
            long[] ret = new long[this.sites.size()];
            Iterator<Long> iter = this.sites.iterator();
            int index = 0;
            while (iter.hasNext()) {
                Long l = iter.next();
                ret[index++] = l;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSite(int x, int y) {
            assert (XToolkit.isAWTLockHeldByCurrentThread());
            for (Long l : this.sites) {
                long window = l;
                Point p = XBaseWindow.toOtherWindow(this.getRoot(), window, x, y);
                if (p == null) continue;
                int dest_x = p.x;
                int dest_y = p.y;
                if (dest_x < 0 || dest_y < 0) continue;
                XWindowAttributes wattr = new XWindowAttributes();
                try {
                    XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                    int status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), window, wattr.pData);
                    XToolkit.RESTORE_XERROR_HANDLER();
                    if (status == 0 || XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0 || wattr.get_map_state() == 0 || dest_x >= wattr.get_width() || dest_y >= wattr.get_height()) continue;
                    long l2 = window;
                    return l2;
                }
                finally {
                    wattr.dispose();
                }
            }
            return 0L;
        }
    }
}

