/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class MotifComboBoxUI
extends BasicComboBoxUI
implements Serializable {
    Icon arrowIcon;
    static final int HORIZ_MARGIN = 3;

    public static ComponentUI createUI(JComponent c) {
        return new MotifComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.arrowIcon = new MotifComboBoxArrowIcon(UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"), UIManager.getColor("control"));
        Runnable initCode = new Runnable(){

            public void run() {
                if (MotifComboBoxUI.this.motifGetEditor() != null) {
                    MotifComboBoxUI.this.motifGetEditor().setBackground(UIManager.getColor("text"));
                }
            }
        };
        SwingUtilities.invokeLater(initCode);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Insets insets = this.getInsets();
        Dimension size = this.getDisplaySize();
        size.height += insets.top + insets.bottom;
        int buttonSize = this.iconAreaWidth();
        size.width += insets.left + insets.right + buttonSize;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return size;
    }

    protected ComboPopup createPopup() {
        return new MotifComboPopup(this.comboBox);
    }

    protected void installComponents() {
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void uninstallComponents() {
        this.removeEditor();
        this.comboBox.removeAll();
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle r;
        boolean hasFocus = this.comboBox.hasFocus();
        if (this.comboBox.isEnabled()) {
            g.setColor(this.comboBox.getBackground());
        } else {
            g.setColor(UIManager.getColor("ComboBox.disabledBackground"));
        }
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
        if (!this.comboBox.isEditable()) {
            r = this.rectangleForCurrentValue();
            this.paintCurrentValue(g, r, hasFocus);
        }
        r = this.rectangleForArrowIcon();
        this.arrowIcon.paintIcon(c, g, r.x, r.y);
        if (!this.comboBox.isEditable()) {
            Border border = this.comboBox.getBorder();
            Insets in = border != null ? border.getBorderInsets(this.comboBox) : new Insets(0, 0, 0, 0);
            r.x = MotifGraphicsUtils.isLeftToRight(this.comboBox) ? (r.x -= 5) : (r.x += r.width + 3 + 1);
            r.y = in.top;
            r.width = 1;
            r.height = this.comboBox.getBounds().height - in.bottom - in.top;
            g.setColor(UIManager.getColor("controlShadow"));
            g.fillRect(r.x, r.y, r.width, r.height);
            ++r.x;
            g.setColor(UIManager.getColor("controlHighlight"));
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListCellRenderer renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        Dimension d = c.getPreferredSize();
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x, bounds.y, bounds.width, d.height);
    }

    protected Rectangle rectangleForArrowIcon() {
        Rectangle b = this.comboBox.getBounds();
        Border border = this.comboBox.getBorder();
        Insets in = border != null ? border.getBorderInsets(this.comboBox) : new Insets(0, 0, 0, 0);
        b.x = in.left;
        b.y = in.top;
        b.width -= in.left + in.right;
        b.height -= in.top + in.bottom;
        b.x = MotifGraphicsUtils.isLeftToRight(this.comboBox) ? b.x + b.width - 3 - this.arrowIcon.getIconWidth() : (b.x += 3);
        b.y += (b.height - this.arrowIcon.getIconHeight()) / 2;
        b.width = this.arrowIcon.getIconWidth();
        b.height = this.arrowIcon.getIconHeight();
        return b;
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        if (MotifGraphicsUtils.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right) - this.iconAreaWidth(), height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + this.iconAreaWidth(), insets.top, width - (insets.left + insets.right) - this.iconAreaWidth(), height - (insets.top + insets.bottom));
    }

    public int iconAreaWidth() {
        if (this.comboBox.isEditable()) {
            return this.arrowIcon.getIconWidth() + 6;
        }
        return this.arrowIcon.getIconWidth() + 9 + 2;
    }

    public void configureEditor() {
        super.configureEditor();
        this.editor.setBackground(UIManager.getColor("text"));
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    private Component motifGetEditor() {
        return this.editor;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MotifPropertyChangeListener();
    }

    private class MotifPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        private MotifPropertyChangeListener() {
            super(MotifComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            Component editor;
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName == "enabled" && MotifComboBoxUI.this.comboBox.isEnabled() && (editor = MotifComboBoxUI.this.motifGetEditor()) != null) {
                editor.setBackground(UIManager.getColor("text"));
            }
        }
    }

    static class MotifComboBoxArrowIcon
    implements Icon,
    Serializable {
        private Color lightShadow;
        private Color darkShadow;
        private Color fill;

        public MotifComboBoxArrowIcon(Color lightShadow, Color darkShadow, Color fill) {
            this.lightShadow = lightShadow;
            this.darkShadow = darkShadow;
            this.fill = fill;
        }

        public void paintIcon(Component c, Graphics g, int xo, int yo) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            g.setColor(this.lightShadow);
            g.drawLine(xo, yo, xo + w - 1, yo);
            g.drawLine(xo, yo + 1, xo + w - 3, yo + 1);
            g.setColor(this.darkShadow);
            g.drawLine(xo + w - 2, yo + 1, xo + w - 1, yo + 1);
            int x = xo + 1;
            int y = yo + 2;
            int dx = w - 6;
            while (y + 1 < yo + h) {
                g.setColor(this.lightShadow);
                g.drawLine(x, y, x + 1, y);
                g.drawLine(x, y + 1, x + 1, y + 1);
                if (dx > 0) {
                    g.setColor(this.fill);
                    g.drawLine(x + 2, y, x + 1 + dx, y);
                    g.drawLine(x + 2, y + 1, x + 1 + dx, y + 1);
                }
                g.setColor(this.darkShadow);
                g.drawLine(x + dx + 2, y, x + dx + 3, y);
                g.drawLine(x + dx + 2, y + 1, x + dx + 3, y + 1);
                ++x;
                dx -= 2;
                y += 2;
            }
            g.setColor(this.darkShadow);
            g.drawLine(xo + w / 2, yo + h - 1, xo + w / 2, yo + h - 1);
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 11;
        }
    }

    public class ComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public ComboBoxLayoutManager() {
            super(MotifComboBoxUI.this);
        }

        public void layoutContainer(Container parent) {
            if (MotifComboBoxUI.this.motifGetEditor() != null) {
                Rectangle cvb = MotifComboBoxUI.this.rectangleForCurrentValue();
                ++cvb.x;
                ++cvb.y;
                --cvb.width;
                cvb.height -= 2;
                MotifComboBoxUI.this.motifGetEditor().setBounds(cvb);
            }
        }
    }

    protected class MotifComboPopup
    extends BasicComboPopup {
        public MotifComboPopup(JComboBox comboBox) {
            super(comboBox);
        }

        public MouseMotionListener createListMouseMotionListener() {
            return new MouseMotionAdapter(){};
        }

        public KeyListener createKeyListener() {
            return super.createKeyListener();
        }

        protected class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            protected InvocationKeyHandler() {
                super(MotifComboPopup.this);
            }
        }
    }
}

