/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.X509Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateX509Key
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.key";
    public static final String NAME = "key";
    public static final String KEY = "value";
    private PublicKey key;

    public CertificateX509Key(PublicKey key) {
        this.key = key;
    }

    public CertificateX509Key(DerInputStream in) throws IOException {
        DerValue val = in.getDerValue();
        this.key = X509Key.parse(val);
    }

    public CertificateX509Key(InputStream in) throws IOException {
        DerValue val = new DerValue(in);
        this.key = X509Key.parse(val);
    }

    @Override
    public String toString() {
        if (this.key == null) {
            return "";
        }
        return this.key.toString();
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        tmp.write(this.key.getEncoded());
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!name.equalsIgnoreCase(KEY)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = (PublicKey)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(KEY)) {
            return this.key;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(KEY)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = null;
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(KEY);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

