/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.Authenticator;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.CookieHandler;
import java.net.HttpRetryException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.ResponseCache;
import java.net.SecureCacheResponse;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.net.ApplicationProxy;
import sun.net.ProgressMonitor;
import sun.net.ProgressSource;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.ChunkedOutputStream;
import sun.net.www.http.HttpClient;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.AuthenticationHeader;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.BasicAuthentication;
import sun.net.www.protocol.http.DigestAuthentication;
import sun.net.www.protocol.http.EmptyInputStream;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpAuthenticator;
import sun.net.www.protocol.http.NTLMAuthentication;
import sun.net.www.protocol.http.NegotiateAuthentication;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static Logger logger = Logger.getLogger("sun.net.www.protocol.http.HttpURLConnection");
    static final String version;
    public static final String userAgent;
    static final int defaultmaxRedirects = 20;
    static final int maxRedirects;
    static final boolean validateProxy;
    static final boolean validateServer;
    private StreamingOutputStream strOutputStream;
    private static final String RETRY_MSG1 = "cannot retry due to proxy authentication, in streaming mode";
    private static final String RETRY_MSG2 = "cannot retry due to server authentication, in streaming mode";
    private static final String RETRY_MSG3 = "cannot retry due to redirection, in streaming mode";
    private static boolean enableESBuffer;
    private static int timeout4ESBuffer;
    private static int bufSize4ES;
    static final String httpVersion = "HTTP/1.1";
    static final String acceptString = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
    private static final String[] EXCLUDE_HEADERS;
    protected HttpClient http;
    protected Handler handler;
    protected Proxy instProxy;
    private CookieHandler cookieHandler;
    private ResponseCache cacheHandler;
    protected CacheResponse cachedResponse;
    private MessageHeader cachedHeaders;
    private InputStream cachedInputStream;
    protected PrintStream ps = null;
    private InputStream errorStream = null;
    private boolean setUserCookies = true;
    private String userCookies = null;
    private static HttpAuthenticator defaultAuth;
    private MessageHeader requests;
    String domain;
    DigestAuthentication.Parameters digestparams;
    AuthenticationInfo currentProxyCredentials = null;
    AuthenticationInfo currentServerCredentials = null;
    boolean needToCheck = true;
    private boolean doingNTLM2ndStage = false;
    private boolean doingNTLMp2ndStage = false;
    private boolean tryTransparentNTLMServer = NTLMAuthentication.supportsTransparentAuth();
    private boolean tryTransparentNTLMProxy = NTLMAuthentication.supportsTransparentAuth();
    Object authObj;
    boolean isUserServerAuth;
    boolean isUserProxyAuth;
    protected ProgressSource pi;
    private MessageHeader responses;
    private InputStream inputStream = null;
    private PosterOutputStream poster = null;
    private boolean setRequests = false;
    private boolean failedOnce = false;
    private Exception rememberedException = null;
    private HttpClient reuseClient = null;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    byte[] cdata = new byte[128];

    private static PasswordAuthentication privilegedRequestPasswordAuthentication(final String host, final InetAddress addr, final int port, final String protocol, final String prompt, final String scheme, final URL url, final Authenticator.RequestorType authType) {
        return (PasswordAuthentication)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Authenticator.requestPasswordAuthentication(host, addr, port, protocol, prompt, scheme, url, authType);
            }
        });
    }

    private void checkMessageHeader(String key, String value) {
        int LF = 10;
        int index = key.indexOf(LF);
        if (index != -1) {
            throw new IllegalArgumentException("Illegal character(s) in message header field: " + key);
        }
        if (value == null) {
            return;
        }
        index = value.indexOf(LF);
        while (index != -1) {
            char c;
            if (++index < value.length() && ((c = value.charAt(index)) == ' ' || c == '\t')) {
                index = value.indexOf(LF, index);
                continue;
            }
            throw new IllegalArgumentException("Illegal character(s) in message header value: " + value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequests() throws IOException {
        if (this.http.usingProxy) {
            this.setPreemptiveProxyAuthentication(this.requests);
        }
        if (!this.setRequests) {
            AuthenticationInfo sauth;
            if (!this.failedOnce) {
                this.requests.prepend(this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            }
            if (!this.getUseCaches()) {
                this.requests.setIfNotSet("Cache-Control", "no-cache");
                this.requests.setIfNotSet("Pragma", "no-cache");
            }
            this.requests.setIfNotSet("User-Agent", userAgent);
            int port = this.url.getPort();
            String host = this.url.getHost();
            if (port != -1 && port != this.url.getDefaultPort()) {
                host = host + ":" + String.valueOf(port);
            }
            this.requests.setIfNotSet("Host", host);
            this.requests.setIfNotSet("Accept", acceptString);
            if (!this.failedOnce && this.http.getHttpKeepAliveSet()) {
                if (this.http.usingProxy) {
                    this.requests.setIfNotSet("Proxy-Connection", "keep-alive");
                } else {
                    this.requests.setIfNotSet("Connection", "keep-alive");
                }
            } else {
                this.requests.setIfNotSet("Connection", "close");
            }
            long modTime = this.getIfModifiedSince();
            if (modTime != 0L) {
                Date date = new Date(modTime);
                SimpleDateFormat fo = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                fo.setTimeZone(TimeZone.getTimeZone("GMT"));
                this.requests.setIfNotSet("If-Modified-Since", fo.format(date));
            }
            if ((sauth = AuthenticationInfo.getServerAuth(this.url)) != null && sauth.supportsPreemptiveAuthorization()) {
                this.requests.setIfNotSet(sauth.getHeaderName(), sauth.getHeaderValue(this.url, this.method));
                this.currentServerCredentials = sauth;
            }
            if (!this.method.equals("PUT") && (this.poster != null || this.streaming())) {
                this.requests.setIfNotSet("Content-type", "application/x-www-form-urlencoded");
            }
            if (this.streaming()) {
                if (this.chunkLength != -1) {
                    this.requests.set("Transfer-Encoding", "chunked");
                } else {
                    this.requests.set("Content-Length", String.valueOf(this.fixedContentLength));
                }
            } else if (this.poster != null) {
                PosterOutputStream posterOutputStream = this.poster;
                synchronized (posterOutputStream) {
                    this.poster.close();
                    this.requests.set("Content-Length", String.valueOf(this.poster.size()));
                }
            }
            this.setCookieHeader();
            this.setRequests = true;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.fine(this.requests.toString());
        }
        this.http.writeRequests(this.requests, this.poster);
        if (this.ps.checkError()) {
            String proxyHost = this.http.getProxyHostUsed();
            int proxyPort = this.http.getProxyPortUsed();
            this.disconnectInternal();
            if (this.failedOnce) {
                throw new IOException("Error writing to server");
            }
            this.failedOnce = true;
            if (proxyHost != null) {
                this.setProxiedClient(this.url, proxyHost, proxyPort);
            } else {
                this.setNewClient(this.url);
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            this.connected = true;
            this.responses = new MessageHeader();
            this.setRequests = false;
            this.writeRequests();
        }
    }

    protected void setNewClient(URL url) throws IOException {
        this.setNewClient(url, false);
    }

    protected void setNewClient(URL url, boolean useCache) throws IOException {
        this.http = HttpClient.New(url, null, -1, useCache, this.connectTimeout);
        this.http.setReadTimeout(this.readTimeout);
    }

    protected void setProxiedClient(URL url, String proxyHost, int proxyPort) throws IOException {
        this.setProxiedClient(url, proxyHost, proxyPort, false);
    }

    protected void setProxiedClient(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException {
        this.proxiedConnect(url, proxyHost, proxyPort, useCache);
    }

    protected void proxiedConnect(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException {
        this.http = HttpClient.New(url, proxyHost, proxyPort, useCache, this.connectTimeout);
        this.http.setReadTimeout(this.readTimeout);
    }

    protected HttpURLConnection(URL u, Handler handler) throws IOException {
        this(u, null, handler);
    }

    public HttpURLConnection(URL u, String host, int port) {
        this(u, new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(host, port)));
    }

    public HttpURLConnection(URL u, Proxy p) {
        this(u, p, new Handler());
    }

    protected HttpURLConnection(URL u, Proxy p, Handler handler) {
        super(u);
        this.requests = new MessageHeader();
        this.responses = new MessageHeader();
        this.handler = handler;
        this.instProxy = p;
        if (this.instProxy instanceof ApplicationProxy) {
            try {
                this.cookieHandler = CookieHandler.getDefault();
            }
            catch (SecurityException se) {}
        } else {
            this.cookieHandler = AccessController.doPrivileged(new PrivilegedAction<CookieHandler>(){

                @Override
                public CookieHandler run() {
                    return CookieHandler.getDefault();
                }
            });
        }
        this.cacheHandler = (ResponseCache)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResponseCache.getDefault();
            }
        });
    }

    public static void setDefaultAuthenticator(HttpAuthenticator a) {
        defaultAuth = a;
    }

    public static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !base.getProtocol().equals(target.getProtocol()) || base.getPort() != target.getPort() || !HttpURLConnection.hostsEqual(base, target) || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    private static boolean hostsEqual(URL u1, URL u2) {
        final String h1 = u1.getHost();
        final String h2 = u2.getHost();
        if (h1 == null) {
            return h2 == null;
        }
        if (h2 == null) {
            return false;
        }
        if (h1.equalsIgnoreCase(h2)) {
            return true;
        }
        final boolean[] result = new boolean[]{false};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InetAddress a1 = InetAddress.getByName(h1);
                    InetAddress a2 = InetAddress.getByName(h2);
                    result[0] = a1.equals(a2);
                }
                catch (UnknownHostException e) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return null;
            }
        });
        return result[0];
    }

    public void connect() throws IOException {
        this.plainConnect();
    }

    private boolean checkReuseConnection() {
        if (this.connected) {
            return true;
        }
        if (this.reuseClient != null) {
            this.http = this.reuseClient;
            this.http.setReadTimeout(this.getReadTimeout());
            this.http.reuse = false;
            this.reuseClient = null;
            this.connected = true;
            return true;
        }
        return false;
    }

    protected void plainConnect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.cacheHandler != null && this.getUseCaches()) {
            try {
                URI uri = ParseUtil.toURI(this.url);
                if (uri != null) {
                    this.cachedResponse = this.cacheHandler.get(uri, this.getRequestMethod(), this.requests.getHeaders(EXCLUDE_HEADERS));
                    if ("https".equalsIgnoreCase(uri.getScheme()) && !(this.cachedResponse instanceof SecureCacheResponse)) {
                        this.cachedResponse = null;
                    }
                    if (this.cachedResponse != null) {
                        this.cachedHeaders = this.mapToMessageHeader(this.cachedResponse.getHeaders());
                        this.cachedInputStream = this.cachedResponse.getBody();
                    }
                }
            }
            catch (IOException ioex) {
                // empty catch block
            }
            if (this.cachedHeaders != null && this.cachedInputStream != null) {
                this.connected = true;
                return;
            }
            this.cachedResponse = null;
        }
        if (this.instProxy == null) {
            ProxySelector sel = (ProxySelector)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ProxySelector.getDefault();
                }
            });
            Proxy p = null;
            if (sel != null) {
                URI uri = ParseUtil.toURI(this.url);
                Iterator<Proxy> it = sel.select(uri).iterator();
                while (it.hasNext()) {
                    p = it.next();
                    try {
                        if (!this.failedOnce) {
                            this.http = this.getNewHttpClient(this.url, p, this.connectTimeout);
                            this.http.setReadTimeout(this.readTimeout);
                        } else {
                            this.http = this.getNewHttpClient(this.url, p, this.connectTimeout, false);
                            this.http.setReadTimeout(this.readTimeout);
                        }
                        break;
                    }
                    catch (IOException ioex) {
                        if (p != Proxy.NO_PROXY) {
                            sel.connectFailed(uri, p.address(), ioex);
                            if (it.hasNext()) continue;
                            this.http = this.getNewHttpClient(this.url, null, this.connectTimeout, false);
                            this.http.setReadTimeout(this.readTimeout);
                            break;
                        }
                        throw ioex;
                    }
                }
            } else if (!this.failedOnce) {
                this.http = this.getNewHttpClient(this.url, null, this.connectTimeout);
                this.http.setReadTimeout(this.readTimeout);
            } else {
                this.http = this.getNewHttpClient(this.url, null, this.connectTimeout, false);
                this.http.setReadTimeout(this.readTimeout);
            }
        } else if (!this.failedOnce) {
            this.http = this.getNewHttpClient(this.url, this.instProxy, this.connectTimeout);
            this.http.setReadTimeout(this.readTimeout);
        } else {
            this.http = this.getNewHttpClient(this.url, this.instProxy, this.connectTimeout, false);
            this.http.setReadTimeout(this.readTimeout);
        }
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    protected HttpClient getNewHttpClient(URL url, Proxy p, int connectTimeout) throws IOException {
        return HttpClient.New(url, p, connectTimeout);
    }

    protected HttpClient getNewHttpClient(URL url, Proxy p, int connectTimeout, boolean useCache) throws IOException {
        return HttpClient.New(url, p, connectTimeout, useCache);
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        try {
            if (!this.doOutput) {
                throw new ProtocolException("cannot write to a URLConnection if doOutput=false - call setDoOutput(true)");
            }
            if (this.method.equals("GET")) {
                this.method = "POST";
            }
            if (!"POST".equals(this.method) && !"PUT".equals(this.method) && "http".equals(this.url.getProtocol())) {
                throw new ProtocolException("HTTP method " + this.method + " doesn't support output");
            }
            if (this.inputStream != null) {
                throw new ProtocolException("Cannot write output after reading input.");
            }
            if (!this.checkReuseConnection()) {
                this.connect();
            }
            if (this.streaming() && this.strOutputStream == null) {
                this.writeRequests();
            }
            this.ps = (PrintStream)this.http.getOutputStream();
            if (this.streaming()) {
                if (this.strOutputStream == null) {
                    if (this.fixedContentLength != -1) {
                        this.strOutputStream = new StreamingOutputStream(this.ps, this.fixedContentLength);
                    } else if (this.chunkLength != -1) {
                        this.strOutputStream = new StreamingOutputStream(new ChunkedOutputStream(this.ps, this.chunkLength), -1);
                    }
                }
                return this.strOutputStream;
            }
            if (this.poster == null) {
                this.poster = new PosterOutputStream();
            }
            return this.poster;
        }
        catch (RuntimeException e) {
            this.disconnectInternal();
            throw e;
        }
        catch (IOException e) {
            this.disconnectInternal();
            throw e;
        }
    }

    private boolean streaming() {
        return this.fixedContentLength != -1 || this.chunkLength != -1;
    }

    private void setCookieHeader() throws IOException {
        if (this.cookieHandler != null) {
            Map<String, List<String>> cookies;
            if (this.setUserCookies) {
                int k = this.requests.getKey("Cookie");
                if (k != -1) {
                    this.userCookies = this.requests.getValue(k);
                }
                this.setUserCookies = false;
            }
            this.requests.remove("Cookie");
            URI uri = ParseUtil.toURI(this.url);
            if (uri != null && !(cookies = this.cookieHandler.get(uri, this.requests.getHeaders(EXCLUDE_HEADERS))).isEmpty()) {
                Set<Map.Entry<String, List<String>>> s = cookies.entrySet();
                for (Map.Entry<String, List<String>> entry : s) {
                    List<String> l;
                    String key = entry.getKey();
                    if (!"Cookie".equalsIgnoreCase(key) && !"Cookie2".equalsIgnoreCase(key) || (l = entry.getValue()) == null || l.isEmpty()) continue;
                    Iterator<String> v_itr = l.iterator();
                    StringBuilder cookieValue = new StringBuilder();
                    while (v_itr.hasNext()) {
                        String value = v_itr.next();
                        cookieValue.append(value).append(';');
                    }
                    try {
                        this.requests.add(key, cookieValue.substring(0, cookieValue.length() - 1));
                    }
                    catch (StringIndexOutOfBoundsException ignored) {}
                }
            }
            if (this.userCookies != null) {
                int k = this.requests.getKey("Cookie");
                if (k != -1) {
                    this.requests.set("Cookie", this.requests.getValue(k) + ";" + this.userCookies);
                } else {
                    this.requests.set("Cookie", this.userCookies);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("Cannot read from URLConnection if doInput=false (call setDoInput(true))");
        }
        if (this.rememberedException != null) {
            if (!(this.rememberedException instanceof RuntimeException)) throw this.getChainedException((IOException)this.rememberedException);
            throw new RuntimeException(this.rememberedException);
        }
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.streaming()) {
            if (this.strOutputStream == null) {
                this.getOutputStream();
            }
            this.strOutputStream.close();
            if (!this.strOutputStream.writtenOK()) {
                throw new IOException("Incomplete output stream");
            }
        }
        int redirects = 0;
        int respCode = 0;
        int cl = -1;
        AuthenticationInfo serverAuthentication = null;
        AuthenticationInfo proxyAuthentication = null;
        AuthenticationHeader srvHdr = null;
        this.isUserServerAuth = this.requests.getKey("Authorization") != -1;
        this.isUserProxyAuth = this.requests.getKey("Proxy-Authorization") != -1;
        try {
            Object uri;
            block63: {
                InputStream inputStream;
                block61: {
                    block62: {
                        try {
                            do {
                                if (!this.checkReuseConnection()) {
                                    this.connect();
                                }
                                if (this.cachedInputStream != null) {
                                    inputStream = this.cachedInputStream;
                                    Object var16_23 = null;
                                    if (respCode != 407 || proxyAuthentication == null) break block61;
                                    break block62;
                                }
                                boolean meteredInput = ProgressMonitor.getDefault().shouldMeterInput(this.url, this.method);
                                if (meteredInput) {
                                    this.pi = new ProgressSource(this.url, this.method);
                                    this.pi.beginTracking();
                                }
                                this.ps = (PrintStream)this.http.getOutputStream();
                                if (!this.streaming()) {
                                    this.writeRequests();
                                }
                                this.http.parseHTTP(this.responses, this.pi, this);
                                if (logger.isLoggable(Level.FINEST)) {
                                    logger.fine(this.responses.toString());
                                }
                                this.inputStream = this.http.getInputStream();
                                respCode = this.getResponseCode();
                                if (respCode == 407) {
                                    if (this.streaming()) {
                                        this.disconnectInternal();
                                        throw new HttpRetryException(RETRY_MSG1, 407);
                                    }
                                    AuthenticationHeader authhdr = new AuthenticationHeader("Proxy-Authenticate", this.responses, this.http.getProxyHostUsed());
                                    if (!this.doingNTLMp2ndStage) {
                                        if ((proxyAuthentication = this.resetProxyAuthentication(proxyAuthentication, authhdr)) != null) {
                                            ++redirects;
                                            this.disconnectInternal();
                                            continue;
                                        }
                                    } else {
                                        String raw = this.responses.findValue("Proxy-Authenticate");
                                        this.reset();
                                        if (!proxyAuthentication.setHeaders(this, authhdr.headerParser(), raw)) {
                                            this.disconnectInternal();
                                            throw new IOException("Authentication failure");
                                        }
                                        if (serverAuthentication != null && srvHdr != null && !serverAuthentication.setHeaders(this, srvHdr.headerParser(), raw)) {
                                            this.disconnectInternal();
                                            throw new IOException("Authentication failure");
                                        }
                                        this.authObj = null;
                                        this.doingNTLMp2ndStage = false;
                                        continue;
                                    }
                                }
                                if (proxyAuthentication != null) {
                                    proxyAuthentication.addToCache();
                                }
                                if (respCode == 401) {
                                    if (this.streaming()) {
                                        this.disconnectInternal();
                                        throw new HttpRetryException(RETRY_MSG2, 401);
                                    }
                                    srvHdr = new AuthenticationHeader("WWW-Authenticate", this.responses, this.url.getHost().toLowerCase());
                                    String raw = srvHdr.raw();
                                    if (!this.doingNTLM2ndStage) {
                                        if (serverAuthentication != null && !(serverAuthentication instanceof NTLMAuthentication)) {
                                            if (serverAuthentication.isAuthorizationStale(raw)) {
                                                this.disconnectInternal();
                                                ++redirects;
                                                this.requests.set(serverAuthentication.getHeaderName(), serverAuthentication.getHeaderValue(this.url, this.method));
                                                this.currentServerCredentials = serverAuthentication;
                                                this.setCookieHeader();
                                                continue;
                                            }
                                            serverAuthentication.removeFromCache();
                                        }
                                        this.currentServerCredentials = serverAuthentication = this.getServerAuthentication(srvHdr);
                                        if (serverAuthentication != null) {
                                            this.disconnectInternal();
                                            ++redirects;
                                            this.setCookieHeader();
                                            continue;
                                        }
                                    } else {
                                        this.reset();
                                        if (!serverAuthentication.setHeaders(this, null, raw)) {
                                            this.disconnectInternal();
                                            throw new IOException("Authentication failure");
                                        }
                                        this.doingNTLM2ndStage = false;
                                        this.authObj = null;
                                        this.setCookieHeader();
                                        continue;
                                    }
                                }
                                if (serverAuthentication != null) {
                                    if (!(serverAuthentication instanceof DigestAuthentication) || this.domain == null) {
                                        if (serverAuthentication instanceof BasicAuthentication) {
                                            String opath = serverAuthentication.path;
                                            String npath = AuthenticationInfo.reducePath(this.url.getPath());
                                            if (!opath.startsWith(npath) || npath.length() >= opath.length()) {
                                                npath = BasicAuthentication.getRootPath(opath, npath);
                                            }
                                            BasicAuthentication a = (BasicAuthentication)serverAuthentication.clone();
                                            serverAuthentication.removeFromCache();
                                            a.path = npath;
                                            serverAuthentication = a;
                                        }
                                        serverAuthentication.addToCache();
                                    } else {
                                        DigestAuthentication srv = (DigestAuthentication)serverAuthentication;
                                        StringTokenizer tok = new StringTokenizer(this.domain, " ");
                                        String realm = srv.realm;
                                        PasswordAuthentication pw = srv.pw;
                                        this.digestparams = srv.params;
                                        while (tok.hasMoreTokens()) {
                                            String path = tok.nextToken();
                                            try {
                                                URL u = new URL(this.url, path);
                                                DigestAuthentication d = new DigestAuthentication(false, u, realm, "Digest", pw, this.digestparams);
                                                d.addToCache();
                                            }
                                            catch (Exception e) {}
                                        }
                                    }
                                }
                                this.doingNTLMp2ndStage = false;
                                this.doingNTLM2ndStage = false;
                                if (!this.isUserServerAuth) {
                                    this.requests.remove("Authorization");
                                }
                                if (!this.isUserProxyAuth) {
                                    this.requests.remove("Proxy-Authorization");
                                }
                                if (respCode == 200) {
                                    this.checkResponseCredentials(false);
                                } else {
                                    this.needToCheck = false;
                                }
                                this.needToCheck = true;
                                if (this.followRedirect()) {
                                    ++redirects;
                                    this.setCookieHeader();
                                    continue;
                                }
                                try {
                                    cl = Integer.parseInt(this.responses.findValue("content-length"));
                                }
                                catch (Exception exc) {
                                    // empty catch block
                                }
                                if (this.method.equals("HEAD") || cl == 0 || respCode == 304 || respCode == 204) {
                                    if (this.pi != null) {
                                        this.pi.finishTracking();
                                        this.pi = null;
                                    }
                                    this.http.finished();
                                    this.http = null;
                                    this.inputStream = new EmptyInputStream();
                                    this.connected = false;
                                }
                                if ((respCode == 200 || respCode == 203 || respCode == 206 || respCode == 300 || respCode == 301 || respCode == 410) && this.cacheHandler != null && this.getUseCaches() && (uri = ParseUtil.toURI(this.url)) != null) {
                                    CacheRequest cacheRequest;
                                    URLConnection uconn = this;
                                    if ("https".equalsIgnoreCase(((URI)uri).getScheme())) {
                                        try {
                                            uconn = (URLConnection)this.getClass().getField("httpsURLConnection").get(this);
                                        }
                                        catch (IllegalAccessException iae) {
                                        }
                                        catch (NoSuchFieldException nsfe) {
                                            // empty catch block
                                        }
                                    }
                                    if ((cacheRequest = this.cacheHandler.put((URI)uri, uconn)) != null && this.http != null) {
                                        this.http.setCacheRequest(cacheRequest);
                                        this.inputStream = new HttpInputStream(this.inputStream, cacheRequest);
                                    }
                                }
                                if (!(this.inputStream instanceof HttpInputStream)) {
                                    this.inputStream = new HttpInputStream(this.inputStream);
                                }
                                if (respCode >= 400) {
                                    if (respCode == 404) throw new FileNotFoundException(this.url.toString());
                                    if (respCode != 410) throw new IOException("Server returned HTTP response code: " + respCode + " for URL: " + this.url.toString());
                                    throw new FileNotFoundException(this.url.toString());
                                }
                                this.poster = null;
                                this.strOutputStream = null;
                                uri = this.inputStream;
                                break block63;
                            } while (redirects < maxRedirects);
                            throw new ProtocolException("Server redirected too many  times (" + redirects + ")");
                        }
                        catch (RuntimeException e) {
                            this.disconnectInternal();
                            this.rememberedException = e;
                            throw e;
                        }
                        catch (IOException e) {
                            this.rememberedException = e;
                            String te = this.responses.findValue("Transfer-Encoding");
                            if (this.http == null) throw e;
                            if (!this.http.isKeepingAlive()) throw e;
                            if (!enableESBuffer) throw e;
                            if (cl <= 0) {
                                if (te == null) throw e;
                                if (!te.equalsIgnoreCase("chunked")) throw e;
                            }
                            this.errorStream = ErrorStream.getErrorStream(this.inputStream, cl, this.http);
                            throw e;
                        }
                    }
                    proxyAuthentication.endAuthRequest();
                    return inputStream;
                }
                if (respCode != 401) return inputStream;
                if (serverAuthentication == null) return inputStream;
                serverAuthentication.endAuthRequest();
                return inputStream;
            }
            Object var16_24 = null;
            if (respCode == 407 && proxyAuthentication != null) {
                proxyAuthentication.endAuthRequest();
                return uri;
            }
            if (respCode != 401) return uri;
            if (serverAuthentication == null) return uri;
            serverAuthentication.endAuthRequest();
            return uri;
        }
        catch (Throwable throwable) {
            Object var16_25 = null;
            if (respCode == 407 && proxyAuthentication != null) {
                proxyAuthentication.endAuthRequest();
                throw throwable;
            }
            if (respCode != 401) throw throwable;
            if (serverAuthentication == null) throw throwable;
            serverAuthentication.endAuthRequest();
            throw throwable;
        }
    }

    private IOException getChainedException(IOException rememberedException) {
        try {
            final IOException originalException = rememberedException;
            final Class[] cls = new Class[]{String.class};
            final String[] args = new String[]{originalException.getMessage()};
            IOException chainedException = (IOException)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Constructor<?> ctr = originalException.getClass().getConstructor(cls);
                    return (IOException)ctr.newInstance(args);
                }
            });
            chainedException.initCause(originalException);
            return chainedException;
        }
        catch (Exception ignored) {
            return rememberedException;
        }
    }

    public InputStream getErrorStream() {
        if (this.connected && this.responseCode >= 400) {
            if (this.errorStream != null) {
                return this.errorStream;
            }
            if (this.inputStream != null) {
                return this.inputStream;
            }
        }
        return null;
    }

    private AuthenticationInfo resetProxyAuthentication(AuthenticationInfo proxyAuthentication, AuthenticationHeader auth) {
        if (proxyAuthentication != null && !(proxyAuthentication instanceof NTLMAuthentication)) {
            String raw = auth.raw();
            if (proxyAuthentication.isAuthorizationStale(raw)) {
                this.requests.set(proxyAuthentication.getHeaderName(), proxyAuthentication.getHeaderValue(this.url, this.method));
                this.currentProxyCredentials = proxyAuthentication;
                return proxyAuthentication;
            }
            proxyAuthentication.removeFromCache();
        }
        this.currentProxyCredentials = proxyAuthentication = this.getHttpProxyAuthentication(auth);
        return proxyAuthentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doTunneling() throws IOException {
        int retryTunnel = 0;
        String statusLine = "";
        int respCode = 0;
        AuthenticationInfo proxyAuthentication = null;
        String proxyHost = null;
        int proxyPort = -1;
        MessageHeader savedRequests = this.requests;
        this.requests = new MessageHeader();
        try {
            do {
                if (!this.checkReuseConnection()) {
                    this.proxiedConnect(this.url, proxyHost, proxyPort, false);
                }
                this.sendCONNECTRequest();
                this.responses.reset();
                this.http.parseHTTP(this.responses, null, this);
                statusLine = this.responses.getValue(0);
                StringTokenizer st = new StringTokenizer(statusLine);
                st.nextToken();
                respCode = Integer.parseInt(st.nextToken().trim());
                if (respCode == 407) {
                    AuthenticationHeader authhdr = new AuthenticationHeader("Proxy-Authenticate", this.responses, this.http.getProxyHostUsed());
                    if (!this.doingNTLMp2ndStage) {
                        if ((proxyAuthentication = this.resetProxyAuthentication(proxyAuthentication, authhdr)) != null) {
                            proxyHost = this.http.getProxyHostUsed();
                            proxyPort = this.http.getProxyPortUsed();
                            this.disconnectInternal();
                            ++retryTunnel;
                            continue;
                        }
                    } else {
                        String raw = this.responses.findValue("Proxy-Authenticate");
                        this.reset();
                        if (!proxyAuthentication.setHeaders(this, authhdr.headerParser(), raw)) {
                            proxyHost = this.http.getProxyHostUsed();
                            proxyPort = this.http.getProxyPortUsed();
                            this.disconnectInternal();
                            throw new IOException("Authentication failure");
                        }
                        this.authObj = null;
                        this.doingNTLMp2ndStage = false;
                        continue;
                    }
                }
                if (proxyAuthentication != null) {
                    proxyAuthentication.addToCache();
                }
                if (respCode == 200) break;
                this.disconnectInternal();
                break;
            } while (retryTunnel < maxRedirects);
            if (retryTunnel >= maxRedirects || respCode != 200) {
                throw new IOException("Unable to tunnel through proxy. Proxy returns \"" + statusLine + "\"");
            }
            Object var12_11 = null;
            if (respCode == 407 && proxyAuthentication != null) {
                proxyAuthentication.endAuthRequest();
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (respCode == 407 && proxyAuthentication != null) {
                proxyAuthentication.endAuthRequest();
            }
            throw throwable;
        }
        this.requests = savedRequests;
        this.responses.reset();
    }

    private void sendCONNECTRequest() throws IOException {
        int port = this.url.getPort();
        if (this.setRequests) {
            this.requests.set(0, null, null);
        }
        this.requests.prepend("CONNECT " + this.url.getHost() + ":" + (port != -1 ? port : this.url.getDefaultPort()) + " " + httpVersion, null);
        this.requests.setIfNotSet("User-Agent", userAgent);
        String host = this.url.getHost();
        if (port != -1 && port != this.url.getDefaultPort()) {
            host = host + ":" + String.valueOf(port);
        }
        this.requests.setIfNotSet("Host", host);
        this.requests.setIfNotSet("Accept", acceptString);
        this.setPreemptiveProxyAuthentication(this.requests);
        this.http.writeRequests(this.requests, null);
        this.requests.set(0, null, null);
    }

    private void setPreemptiveProxyAuthentication(MessageHeader requests) {
        AuthenticationInfo pauth = AuthenticationInfo.getProxyAuth(this.http.getProxyHostUsed(), this.http.getProxyPortUsed());
        if (pauth != null && pauth.supportsPreemptiveAuthorization()) {
            requests.set(pauth.getHeaderName(), pauth.getHeaderValue(this.url, this.method));
            this.currentProxyCredentials = pauth;
        }
    }

    private AuthenticationInfo getHttpProxyAuthentication(AuthenticationHeader authhdr) {
        AuthenticationInfo ret = null;
        String raw = authhdr.raw();
        String host = this.http.getProxyHostUsed();
        int port = this.http.getProxyPortUsed();
        if (host != null && authhdr.isPresent()) {
            Object a;
            char schemeID;
            HeaderParser p = authhdr.headerParser();
            String realm = p.findValue("realm");
            String scheme = authhdr.scheme();
            if ("basic".equalsIgnoreCase(scheme)) {
                schemeID = 'B';
            } else if ("digest".equalsIgnoreCase(scheme)) {
                schemeID = 'D';
            } else if ("ntlm".equalsIgnoreCase(scheme)) {
                schemeID = NTLMAuthentication.NTLM_AUTH;
                this.doingNTLMp2ndStage = true;
            } else if ("Kerberos".equalsIgnoreCase(scheme)) {
                schemeID = 'K';
                this.doingNTLMp2ndStage = true;
            } else if ("Negotiate".equalsIgnoreCase(scheme)) {
                schemeID = 'S';
                this.doingNTLMp2ndStage = true;
            } else {
                schemeID = '\u0000';
            }
            if (realm == null) {
                realm = "";
            }
            if ((ret = AuthenticationInfo.getProxyAuth(host, port, realm, schemeID)) == null) {
                PasswordAuthentication a2;
                if (schemeID == 'B') {
                    InetAddress addr = null;
                    try {
                        final String finalHost = host;
                        addr = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws UnknownHostException {
                                return InetAddress.getByName(finalHost);
                            }
                        });
                    }
                    catch (PrivilegedActionException ignored) {
                        // empty catch block
                    }
                    a = HttpURLConnection.privilegedRequestPasswordAuthentication(host, addr, port, "http", realm, scheme, this.url, Authenticator.RequestorType.PROXY);
                    if (a != null) {
                        ret = new BasicAuthentication(true, host, port, realm, (PasswordAuthentication)a);
                    }
                } else if (schemeID == 'D') {
                    a2 = HttpURLConnection.privilegedRequestPasswordAuthentication(host, null, port, this.url.getProtocol(), realm, scheme, this.url, Authenticator.RequestorType.PROXY);
                    if (a2 != null) {
                        DigestAuthentication.Parameters params = new DigestAuthentication.Parameters();
                        ret = new DigestAuthentication(true, host, port, realm, scheme, a2, params);
                    }
                } else if (schemeID == NTLMAuthentication.NTLM_AUTH) {
                    a2 = null;
                    if (!this.tryTransparentNTLMProxy) {
                        a2 = HttpURLConnection.privilegedRequestPasswordAuthentication(host, null, port, this.url.getProtocol(), "", scheme, this.url, Authenticator.RequestorType.PROXY);
                    }
                    if (this.tryTransparentNTLMProxy || !this.tryTransparentNTLMProxy && a2 != null) {
                        ret = new NTLMAuthentication(true, host, port, a2);
                    }
                    this.tryTransparentNTLMProxy = false;
                } else if (schemeID == 'S') {
                    ret = new NegotiateAuthentication(true, host, port, null, "Negotiate");
                } else if (schemeID == 'K') {
                    ret = new NegotiateAuthentication(true, host, port, null, "Kerberos");
                }
            }
            if (ret == null && defaultAuth != null && defaultAuth.schemeSupported(scheme)) {
                try {
                    URL u = new URL("http", host, port, "/");
                    a = defaultAuth.authString(u, scheme, realm);
                    if (a != null) {
                        ret = new BasicAuthentication(true, host, port, realm, (String)a);
                    }
                }
                catch (MalformedURLException ignored) {
                    // empty catch block
                }
            }
            if (ret != null && !ret.setHeaders(this, p, raw)) {
                ret = null;
            }
        }
        return ret;
    }

    private AuthenticationInfo getServerAuthentication(AuthenticationHeader authhdr) {
        AuthenticationInfo ret = null;
        String raw = authhdr.raw();
        if (authhdr.isPresent()) {
            Object a;
            int port;
            char schemeID;
            HeaderParser p = authhdr.headerParser();
            String realm = p.findValue("realm");
            String scheme = authhdr.scheme();
            if ("basic".equalsIgnoreCase(scheme)) {
                schemeID = 'B';
            } else if ("digest".equalsIgnoreCase(scheme)) {
                schemeID = 'D';
            } else if ("ntlm".equalsIgnoreCase(scheme)) {
                schemeID = NTLMAuthentication.NTLM_AUTH;
                this.doingNTLM2ndStage = true;
            } else if ("Kerberos".equalsIgnoreCase(scheme)) {
                schemeID = 'K';
                this.doingNTLM2ndStage = true;
            } else if ("Negotiate".equalsIgnoreCase(scheme)) {
                schemeID = 'S';
                this.doingNTLM2ndStage = true;
            } else {
                schemeID = '\u0000';
            }
            this.domain = p.findValue("domain");
            if (realm == null) {
                realm = "";
            }
            ret = AuthenticationInfo.getServerAuth(this.url, realm, schemeID);
            InetAddress addr = null;
            if (ret == null) {
                try {
                    addr = InetAddress.getByName(this.url.getHost());
                }
                catch (UnknownHostException ignored) {
                    // empty catch block
                }
            }
            if ((port = this.url.getPort()) == -1) {
                port = this.url.getDefaultPort();
            }
            if (ret == null) {
                URL url1;
                if (schemeID == 'K') {
                    try {
                        url1 = new URL(this.url, "/");
                    }
                    catch (Exception e) {
                        url1 = this.url;
                    }
                    ret = new NegotiateAuthentication(false, url1, null, "Kerberos");
                }
                if (schemeID == 'S') {
                    try {
                        url1 = new URL(this.url, "/");
                    }
                    catch (Exception e) {
                        url1 = this.url;
                    }
                    ret = new NegotiateAuthentication(false, url1, null, "Negotiate");
                }
                if (schemeID == 'B' && (a = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), addr, port, this.url.getProtocol(), realm, scheme, this.url, Authenticator.RequestorType.SERVER)) != null) {
                    ret = new BasicAuthentication(false, this.url, realm, (PasswordAuthentication)a);
                }
                if (schemeID == 'D' && (a = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), addr, port, this.url.getProtocol(), realm, scheme, this.url, Authenticator.RequestorType.SERVER)) != null) {
                    this.digestparams = new DigestAuthentication.Parameters();
                    ret = new DigestAuthentication(false, this.url, realm, scheme, (PasswordAuthentication)a, this.digestparams);
                }
                if (schemeID == NTLMAuthentication.NTLM_AUTH) {
                    try {
                        url1 = new URL(this.url, "/");
                    }
                    catch (Exception e) {
                        url1 = this.url;
                    }
                    PasswordAuthentication a2 = null;
                    if (!this.tryTransparentNTLMServer) {
                        a2 = HttpURLConnection.privilegedRequestPasswordAuthentication(this.url.getHost(), addr, port, this.url.getProtocol(), "", scheme, this.url, Authenticator.RequestorType.SERVER);
                    }
                    if (this.tryTransparentNTLMServer || !this.tryTransparentNTLMServer && a2 != null) {
                        ret = new NTLMAuthentication(false, url1, a2);
                    }
                    this.tryTransparentNTLMServer = false;
                }
            }
            if (ret == null && defaultAuth != null && defaultAuth.schemeSupported(scheme) && (a = defaultAuth.authString(this.url, scheme, realm)) != null) {
                ret = new BasicAuthentication(false, this.url, realm, (String)a);
            }
            if (ret != null && !ret.setHeaders(this, p, raw)) {
                ret = null;
            }
        }
        return ret;
    }

    private void checkResponseCredentials(boolean inClose) throws IOException {
        try {
            String raw;
            if (!this.needToCheck) {
                return;
            }
            if (validateProxy && this.currentProxyCredentials != null) {
                raw = this.responses.findValue("Proxy-Authentication-Info");
                if (inClose || raw != null) {
                    this.currentProxyCredentials.checkResponse(raw, this.method, this.url);
                    this.currentProxyCredentials = null;
                }
            }
            if (validateServer && this.currentServerCredentials != null) {
                raw = this.responses.findValue("Authentication-Info");
                if (inClose || raw != null) {
                    this.currentServerCredentials.checkResponse(raw, this.method, this.url);
                    this.currentServerCredentials = null;
                }
            }
            if (this.currentServerCredentials == null && this.currentProxyCredentials == null) {
                this.needToCheck = false;
            }
        }
        catch (IOException e) {
            this.disconnectInternal();
            this.connected = false;
            throw e;
        }
    }

    private boolean followRedirect() throws IOException {
        URL locUrl;
        if (!this.getInstanceFollowRedirects()) {
            return false;
        }
        int stat = this.getResponseCode();
        if (stat < 300 || stat > 307 || stat == 306 || stat == 304) {
            return false;
        }
        String loc = this.getHeaderField("Location");
        if (loc == null) {
            return false;
        }
        try {
            locUrl = new URL(loc);
            if (!this.url.getProtocol().equalsIgnoreCase(locUrl.getProtocol())) {
                return false;
            }
        }
        catch (MalformedURLException mue) {
            locUrl = new URL(this.url, loc);
        }
        this.disconnectInternal();
        if (this.streaming()) {
            throw new HttpRetryException(RETRY_MSG3, stat, loc);
        }
        this.responses = new MessageHeader();
        if (stat == 305) {
            String proxyHost = locUrl.getHost();
            int proxyPort = locUrl.getPort();
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(proxyHost, proxyPort);
            }
            this.setProxiedClient(this.url, proxyHost, proxyPort);
            this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
            this.connected = true;
        } else {
            this.url = locUrl;
            if (this.method.equals("POST") && !Boolean.getBoolean("http.strictPostRedirect") && stat != 307) {
                this.requests = new MessageHeader();
                this.setRequests = false;
                this.setRequestMethod("GET");
                this.poster = null;
                if (!this.checkReuseConnection()) {
                    this.connect();
                }
            } else {
                if (!this.checkReuseConnection()) {
                    this.connect();
                }
                if (this.http != null) {
                    this.requests.set(0, this.method + " " + this.http.getURLFile() + " " + httpVersion, null);
                    int port = this.url.getPort();
                    String host = this.url.getHost();
                    if (port != -1 && port != this.url.getDefaultPort()) {
                        host = host + ":" + String.valueOf(port);
                    }
                    this.requests.set("Host", host);
                }
            }
        }
        return true;
    }

    private void reset() throws IOException {
        this.http.reuse = true;
        this.reuseClient = this.http;
        InputStream is = this.http.getInputStream();
        if (!this.method.equals("HEAD")) {
            block11: {
                try {
                    if (is instanceof ChunkedInputStream || is instanceof MeteredStream) {
                        while (is.read(this.cdata) > 0) {
                        }
                        break block11;
                    }
                    int cl = 0;
                    int n = 0;
                    try {
                        cl = Integer.parseInt(this.responses.findValue("Content-Length"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    for (int i = 0; i < cl && (n = is.read(this.cdata)) != -1; i += n) {
                    }
                }
                catch (IOException e) {
                    this.http.reuse = false;
                    this.reuseClient = null;
                    this.disconnectInternal();
                    return;
                }
            }
            try {
                if (is instanceof MeteredStream) {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.responseCode = -1;
        this.responses = new MessageHeader();
        this.connected = false;
    }

    private void disconnectInternal() {
        this.responseCode = -1;
        if (this.pi != null) {
            this.pi.finishTracking();
            this.pi = null;
        }
        if (this.http != null) {
            this.http.closeServer();
            this.http = null;
            this.connected = false;
        }
    }

    public void disconnect() {
        this.responseCode = -1;
        if (this.pi != null) {
            this.pi.finishTracking();
            this.pi = null;
        }
        if (this.http != null) {
            if (this.inputStream != null) {
                HttpClient hc = this.http;
                boolean ka = hc.isKeepingAlive();
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (ka) {
                    hc.closeIdleConnection();
                }
            } else {
                this.http.setDoNotRetry(true);
                this.http.closeServer();
            }
            this.http = null;
            this.connected = false;
        }
        this.cachedInputStream = null;
        if (this.cachedHeaders != null) {
            this.cachedHeaders.reset();
        }
    }

    public boolean usingProxy() {
        if (this.http != null) {
            return this.http.getProxyHostUsed() != null;
        }
        return false;
    }

    public String getHeaderField(String name) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.findValue(name);
        }
        return this.responses.findValue(name);
    }

    public Map getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.getHeaders();
        }
        return this.responses.getHeaders();
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.getValue(n);
        }
        return this.responses.getValue(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.cachedHeaders != null) {
            return this.cachedHeaders.getKey(n);
        }
        return this.responses.getKey(n);
    }

    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.checkMessageHeader(key, value);
        this.requests.set(key, value);
    }

    public void addRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.checkMessageHeader(key, value);
        this.requests.add(key, value);
    }

    void setAuthenticationProperty(String key, String value) {
        this.checkMessageHeader(key, value);
        this.requests.set(key, value);
    }

    public String getRequestProperty(String key) {
        if (key != null) {
            for (int i = 0; i < EXCLUDE_HEADERS.length; ++i) {
                if (!key.equalsIgnoreCase(EXCLUDE_HEADERS[i])) continue;
                return null;
            }
        }
        return this.requests.findValue(key);
    }

    public Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return this.requests.getHeaders(EXCLUDE_HEADERS);
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? 0 : this.connectTimeout;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.readTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readTimeout < 0 ? 0 : this.readTimeout;
    }

    protected void finalize() {
    }

    String getMethod() {
        return this.method;
    }

    private MessageHeader mapToMessageHeader(Map map) {
        MessageHeader headers = new MessageHeader();
        if (map == null || map.isEmpty()) {
            return headers;
        }
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                if (key == null) {
                    headers.prepend(key, value);
                    continue;
                }
                headers.add(key, value);
            }
        }
        return headers;
    }

    static {
        enableESBuffer = false;
        timeout4ESBuffer = 0;
        bufSize4ES = 0;
        maxRedirects = AccessController.doPrivileged(new GetIntegerAction("http.maxRedirects", 20));
        version = AccessController.doPrivileged(new GetPropertyAction("java.version"));
        String agent2 = AccessController.doPrivileged(new GetPropertyAction("http.agent"));
        agent2 = agent2 == null ? "Java/" + version : agent2 + " Java/" + version;
        userAgent = agent2;
        validateProxy = AccessController.doPrivileged(new GetBooleanAction("http.auth.digest.validateProxy"));
        validateServer = AccessController.doPrivileged(new GetBooleanAction("http.auth.digest.validateServer"));
        enableESBuffer = AccessController.doPrivileged(new GetBooleanAction("sun.net.http.errorstream.enableBuffering"));
        timeout4ESBuffer = AccessController.doPrivileged(new GetIntegerAction("sun.net.http.errorstream.timeout", 300));
        if (timeout4ESBuffer <= 0) {
            timeout4ESBuffer = 300;
        }
        if ((bufSize4ES = AccessController.doPrivileged(new GetIntegerAction("sun.net.http.errorstream.bufferSize", 4096)).intValue()) <= 0) {
            bufSize4ES = 4096;
        }
        EXCLUDE_HEADERS = new String[]{"Proxy-Authorization", "Authorization"};
    }

    static class ErrorStream
    extends InputStream {
        ByteBuffer buffer;
        InputStream is;

        private ErrorStream(ByteBuffer buf) {
            this.buffer = buf;
            this.is = null;
        }

        private ErrorStream(ByteBuffer buf, InputStream is) {
            this.buffer = buf;
            this.is = is;
        }

        public static InputStream getErrorStream(InputStream is, int cl, HttpClient http) {
            if (cl == 0) {
                return null;
            }
            try {
                int oldTimeout = http.setTimeout(timeout4ESBuffer / 5);
                int expected = 0;
                boolean isChunked = false;
                if (cl < 0) {
                    expected = bufSize4ES;
                    isChunked = true;
                } else {
                    expected = cl;
                }
                if (expected <= bufSize4ES) {
                    byte[] buffer = new byte[expected];
                    int count = 0;
                    int time = 0;
                    int len = 0;
                    do {
                        try {
                            len = is.read(buffer, count, buffer.length - count);
                            if (len < 0) {
                                if (cl < 0) break;
                                throw new IOException("the server closes before sending " + cl + " bytes of data");
                            }
                            count += len;
                        }
                        catch (SocketTimeoutException ex) {
                            time += timeout4ESBuffer / 5;
                        }
                    } while (count < expected && time < timeout4ESBuffer);
                    http.setTimeout(oldTimeout);
                    if (count == 0) {
                        return null;
                    }
                    if (count == expected && !isChunked || isChunked && len < 0) {
                        is.close();
                        return new ErrorStream(ByteBuffer.wrap(buffer, 0, count));
                    }
                    return new ErrorStream(ByteBuffer.wrap(buffer, 0, count), is);
                }
                return null;
            }
            catch (IOException ioex) {
                return null;
            }
        }

        public int available() throws IOException {
            if (this.is == null) {
                return this.buffer.remaining();
            }
            return this.buffer.remaining() + this.is.available();
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            int ret = this.read(b);
            return ret == -1 ? ret : b[0] & 0xFF;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int rem = this.buffer.remaining();
            if (rem > 0) {
                int ret = rem < len ? rem : len;
                this.buffer.get(b, off, ret);
                return ret;
            }
            if (this.is == null) {
                return -1;
            }
            return this.is.read(b, off, len);
        }

        public void close() throws IOException {
            this.buffer = null;
            if (this.is != null) {
                this.is.close();
            }
        }
    }

    class StreamingOutputStream
    extends FilterOutputStream {
        int expected;
        int written;
        boolean closed;
        boolean error;
        IOException errorExcp;

        StreamingOutputStream(OutputStream os, int expectedLength) {
            super(os);
            this.expected = expectedLength;
            this.written = 0;
            this.closed = false;
            this.error = false;
        }

        public void write(int b) throws IOException {
            this.checkError();
            ++this.written;
            if (this.expected != -1 && this.written > this.expected) {
                throw new IOException("too many bytes written");
            }
            this.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.checkError();
            this.written += len;
            if (this.expected != -1 && this.written > this.expected) {
                this.out.close();
                throw new IOException("too many bytes written");
            }
            this.out.write(b, off, len);
        }

        void checkError() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.error) {
                throw this.errorExcp;
            }
            if (((PrintStream)this.out).checkError()) {
                throw new IOException("Error writing request body to server");
            }
        }

        boolean writtenOK() {
            return this.closed && !this.error;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.expected != -1) {
                if (this.written != this.expected) {
                    this.error = true;
                    this.errorExcp = new IOException("insufficient data written");
                    this.out.close();
                    throw this.errorExcp;
                }
                super.flush();
            } else {
                super.close();
                OutputStream o = HttpURLConnection.this.http.getOutputStream();
                o.write(13);
                o.write(10);
                o.flush();
            }
        }
    }

    class HttpInputStream
    extends FilterInputStream {
        private CacheRequest cacheRequest;
        private OutputStream outputStream;
        private boolean marked;
        private int inCache;
        private int markCount;
        private byte[] skipBuffer;
        private static final int SKIP_BUFFER_SIZE = 8096;

        public HttpInputStream(InputStream is) {
            super(is);
            this.marked = false;
            this.inCache = 0;
            this.markCount = 0;
            this.cacheRequest = null;
            this.outputStream = null;
        }

        public HttpInputStream(InputStream is, CacheRequest cacheRequest) {
            super(is);
            this.marked = false;
            this.inCache = 0;
            this.markCount = 0;
            this.cacheRequest = cacheRequest;
            try {
                this.outputStream = cacheRequest.getBody();
            }
            catch (IOException ioex) {
                this.cacheRequest.abort();
                this.cacheRequest = null;
                this.outputStream = null;
            }
        }

        public synchronized void mark(int readlimit) {
            super.mark(readlimit);
            if (this.cacheRequest != null) {
                this.marked = true;
                this.markCount = 0;
            }
        }

        public synchronized void reset() throws IOException {
            super.reset();
            if (this.cacheRequest != null) {
                this.marked = false;
                this.inCache += this.markCount;
            }
        }

        public int read() throws IOException {
            try {
                byte[] b = new byte[1];
                int ret = this.read(b);
                return ret == -1 ? ret : b[0] & 0xFF;
            }
            catch (IOException ioex) {
                if (this.cacheRequest != null) {
                    this.cacheRequest.abort();
                }
                throw ioex;
            }
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int nWrite;
                int newLen = super.read(b, off, len);
                if (this.inCache > 0) {
                    if (this.inCache >= newLen) {
                        this.inCache -= newLen;
                        nWrite = 0;
                    } else {
                        nWrite = newLen - this.inCache;
                        this.inCache = 0;
                    }
                } else {
                    nWrite = newLen;
                }
                if (nWrite > 0 && this.outputStream != null) {
                    this.outputStream.write(b, off + (newLen - nWrite), nWrite);
                }
                if (this.marked) {
                    this.markCount += newLen;
                }
                return newLen;
            }
            catch (IOException ioex) {
                if (this.cacheRequest != null) {
                    this.cacheRequest.abort();
                }
                throw ioex;
            }
        }

        public void close() throws IOException {
            try {
                try {
                    if (this.outputStream != null) {
                        if (this.read() != -1) {
                            this.cacheRequest.abort();
                        } else {
                            this.outputStream.close();
                        }
                    }
                    super.close();
                }
                catch (IOException ioex) {
                    if (this.cacheRequest != null) {
                        this.cacheRequest.abort();
                    }
                    throw ioex;
                }
                Object var3_1 = null;
                HttpURLConnection.this.http = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                HttpURLConnection.this.http = null;
                HttpURLConnection.this.checkResponseCredentials(true);
                throw throwable;
            }
            HttpURLConnection.this.checkResponseCredentials(true);
        }

        public long skip(long n) throws IOException {
            int nr;
            long remaining = n;
            if (this.skipBuffer == null) {
                this.skipBuffer = new byte[8096];
            }
            byte[] localSkipBuffer = this.skipBuffer;
            if (n <= 0L) {
                return 0L;
            }
            while (remaining > 0L && (nr = this.read(localSkipBuffer, 0, (int)Math.min(8096L, remaining))) >= 0) {
                remaining -= (long)nr;
            }
            return n - remaining;
        }
    }
}

