/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.nimbus;

import com.sun.java.swing.plaf.nimbus.Effect;
import com.sun.java.swing.plaf.nimbus.EffectUtils;
import com.sun.java.swing.plaf.nimbus.ShadowEffect;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;

class DropShadowEffect
extends ShadowEffect {
    DropShadowEffect() {
    }

    Effect.EffectType getEffectType() {
        return Effect.EffectType.UNDER;
    }

    BufferedImage applyEffect(BufferedImage src, BufferedImage dst, int w, int h) {
        if (src == null || src.getType() != 2) {
            throw new IllegalArgumentException("Effect only works with source images of type BufferedImage.TYPE_INT_ARGB.");
        }
        if (dst != null && dst.getType() != 2) {
            throw new IllegalArgumentException("Effect only works with destination images of type BufferedImage.TYPE_INT_ARGB.");
        }
        double trangleAngle = Math.toRadians(this.angle - 90);
        int offsetX = (int)(Math.sin(trangleAngle) * (double)this.distance);
        int offsetY = (int)(Math.cos(trangleAngle) * (double)this.distance);
        int tmpOffX = offsetX + this.size;
        int tmpOffY = offsetX + this.size;
        int tmpW = w + offsetX + this.size + this.size;
        int tmpH = h + offsetX + this.size;
        int[] lineBuf = DropShadowEffect.getArrayCache().getTmpIntArray(w);
        byte[] tmpBuf1 = DropShadowEffect.getArrayCache().getTmpByteArray1(tmpW * tmpH);
        Arrays.fill(tmpBuf1, (byte)0);
        byte[] tmpBuf2 = DropShadowEffect.getArrayCache().getTmpByteArray2(tmpW * tmpH);
        WritableRaster srcRaster = src.getRaster();
        for (int y = 0; y < h; ++y) {
            int dy = y + tmpOffY;
            int offset = dy * tmpW;
            srcRaster.getDataElements(0, y, w, 1, lineBuf);
            for (int x = 0; x < w; ++x) {
                int dx = x + tmpOffX;
                tmpBuf1[offset + dx] = (byte)((lineBuf[x] & 0xFF000000) >>> 24);
            }
        }
        float[] kernel = EffectUtils.createGaussianKernel(this.size);
        EffectUtils.blur(tmpBuf1, tmpBuf2, tmpW, tmpH, kernel, this.size);
        EffectUtils.blur(tmpBuf2, tmpBuf1, tmpH, tmpW, kernel, this.size);
        float spread = Math.min(1.0f / (1.0f - 0.01f * (float)this.spread), 255.0f);
        for (int i = 0; i < tmpBuf1.length; ++i) {
            int val = (int)((float)(tmpBuf1[i] & 0xFF) * spread);
            tmpBuf1[i] = (byte)(val > 255 ? -1 : (byte)val);
        }
        if (dst == null) {
            dst = new BufferedImage(w, h, 2);
        }
        WritableRaster shadowRaster = dst.getRaster();
        int red = this.color.getRed();
        int green = this.color.getGreen();
        int blue = this.color.getBlue();
        for (int y = 0; y < h; ++y) {
            int srcY = y + tmpOffY;
            int shadowOffset = (srcY - offsetY) * tmpW;
            for (int x = 0; x < w; ++x) {
                int srcX = x + tmpOffX;
                lineBuf[x] = tmpBuf1[shadowOffset + (srcX - offsetX)] << 24 | red << 16 | green << 8 | blue;
            }
            shadowRaster.setDataElements(0, y, w, 1, lineBuf);
        }
        return dst;
    }
}

