/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.SecurityWrapper;

class Operation {
    private byte[] operationPointer;
    private EventLoop eventLoop;

    private native void native_ref();

    private native void native_unref();

    private native int native_get_state();

    Operation(byte[] operationPointer) {
        assert (operationPointer != null);
        this.operationPointer = operationPointer;
        this.eventLoop = EventLoop.getEventLoop();
    }

    protected void finalize() throws Throwable {
        assert (this.operationPointer == null);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReference() {
        assert (this.operationPointer != null);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.native_ref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseReference() {
        assert (this.operationPointer != null);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            this.native_unref();
        }
        this.operationPointer = null;
    }

    boolean isNull() {
        return this.operationPointer == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State getState() {
        int state;
        assert (this.operationPointer != null);
        Object object = this.eventLoop.threadLock;
        synchronized (object) {
            state = this.native_get_state();
        }
        switch (state) {
            case 0: {
                return State.Running;
            }
            case 1: {
                return State.Done;
            }
            case 2: {
                return State.Cancelled;
            }
        }
        throw new IllegalStateException("Invalid operation State");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCompletion() {
        assert (this.operationPointer != null);
        boolean interrupted = false;
        do {
            Object object = this.eventLoop.threadLock;
            synchronized (object) {
                if (this.getState() == State.Done) {
                    return;
                }
                try {
                    this.eventLoop.threadLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        } while (this.getState() != State.Done);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        SecurityWrapper.loadNativeLibrary();
    }

    public static enum State {
        Running,
        Done,
        Cancelled;

    }
}

