/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;

class TableView
extends BoxView
implements ViewFactory {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private int cellSpacing;
    private int borderWidth;
    private int captionIndex = -1;
    private boolean relativeCells;
    private boolean multiRowCells;
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements totalColumnRequirements;
    SizeRequirements[] columnRequirements;
    RowIterator rowIterator = new RowIterator();
    ColumnIterator colIterator = new ColumnIterator();
    Vector rows = new Vector();
    boolean skipComments = false;
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public TableView(Element elem) {
        super(elem, 1);
        this.totalColumnRequirements = new SizeRequirements();
    }

    protected RowView createTableRow(Element elem) {
        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (o == HTML.Tag.TR) {
            return new RowView(elem);
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnSpans.length;
    }

    public int getColumnSpan(int col) {
        if (col < this.columnSpans.length) {
            return this.columnSpans[col];
        }
        return 0;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getMultiRowSpan(int row0, int row1) {
        RowView rv0 = this.getRow(row0);
        RowView rv1 = this.getRow(row1);
        if (rv0 != null && rv1 != null) {
            int index0 = rv0.viewIndex;
            int index1 = rv1.viewIndex;
            int span = this.getOffset(1, index1) - this.getOffset(1, index0) + this.getSpan(1, index1);
            return span;
        }
        return 0;
    }

    public int getRowSpan(int row) {
        RowView rv = this.getRow(row);
        if (rv != null) {
            return this.getSpan(1, rv.viewIndex);
        }
        return 0;
    }

    RowView getRow(int row) {
        if (row < this.rows.size()) {
            return (RowView)this.rows.elementAt(row);
        }
        return null;
    }

    protected View getViewAtPoint(int x, int y, Rectangle alloc) {
        int n = this.getViewCount();
        View v = null;
        Rectangle allocation = new Rectangle();
        for (int i = 0; i < n; ++i) {
            allocation.setBounds(alloc);
            this.childAllocation(i, allocation);
            v = this.getView(i);
            if (!(v instanceof RowView) || (v = ((RowView)v).findViewAtPoint(x, y, allocation)) == null) continue;
            alloc.setBounds(allocation);
            return v;
        }
        return super.getViewAtPoint(x, y, alloc);
    }

    protected int getColumnsOccupied(View v) {
        String s;
        AttributeSet a = v.getElement().getAttributes();
        if (a.isDefined(HTML.Attribute.COLSPAN) && (s = (String)a.getAttribute(HTML.Attribute.COLSPAN)) != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return 1;
    }

    protected int getRowsOccupied(View v) {
        String s;
        AttributeSet a = v.getElement().getAttributes();
        if (a.isDefined(HTML.Attribute.ROWSPAN) && (s = (String)a.getAttribute(HTML.Attribute.ROWSPAN)) != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return 1;
    }

    protected void invalidateGrid() {
        this.gridValid = false;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    void updateInsets() {
        short top = (short)this.painter.getInset(1, this);
        short bottom = (short)this.painter.getInset(3, this);
        if (this.captionIndex != -1) {
            View caption = this.getView(this.captionIndex);
            short h = (short)caption.getPreferredSpan(1);
            AttributeSet a = caption.getAttributes();
            Object align = a.getAttribute(CSS.Attribute.CAPTION_SIDE);
            if (align != null && align.equals("bottom")) {
                bottom = (short)(bottom + h);
            } else {
                top = (short)(top + h);
            }
        }
        this.setInsets(top, (short)this.painter.getInset(2, this), bottom, (short)this.painter.getInset(4, this));
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
        this.painter = sheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            CSS.LengthValue lv = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.BORDER_SPACING);
            this.cellSpacing = lv != null ? (int)lv.getValue() : 0;
            lv = (CSS.LengthValue)this.attr.getAttribute(CSS.Attribute.BORDER_TOP_WIDTH);
            this.borderWidth = lv != null ? (int)lv.getValue() : 0;
        }
    }

    void updateGrid() {
        if (!this.gridValid) {
            this.relativeCells = false;
            this.multiRowCells = false;
            this.captionIndex = -1;
            this.rows.removeAllElements();
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                HTML.Tag kind;
                View v = this.getView(i);
                if (v instanceof RowView) {
                    this.rows.addElement(v);
                    RowView rv = (RowView)v;
                    rv.clearFilledColumns();
                    rv.rowIndex = this.rows.size() - 1;
                    rv.viewIndex = i;
                    continue;
                }
                Object o = v.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (!(o instanceof HTML.Tag) || (kind = (HTML.Tag)o) != HTML.Tag.CAPTION) continue;
                this.captionIndex = i;
            }
            int maxColumns = 0;
            int nrows = this.rows.size();
            for (int row = 0; row < nrows; ++row) {
                RowView rv = this.getRow(row);
                int col = 0;
                int cell = 0;
                while (cell < rv.getViewCount()) {
                    int colSpan;
                    AttributeSet a;
                    CSS.LengthValue lv;
                    View cv = rv.getView(cell);
                    if (!this.relativeCells && (lv = (CSS.LengthValue)(a = cv.getAttributes()).getAttribute(CSS.Attribute.WIDTH)) != null && lv.isPercentage()) {
                        this.relativeCells = true;
                    }
                    while (rv.isFilled(col)) {
                        ++col;
                    }
                    int rowSpan = this.getRowsOccupied(cv);
                    if (rowSpan > 1) {
                        this.multiRowCells = true;
                    }
                    if ((colSpan = this.getColumnsOccupied(cv)) > 1 || rowSpan > 1) {
                        int rowLimit = row + rowSpan;
                        int colLimit = col + colSpan;
                        for (int i = row; i < rowLimit; ++i) {
                            for (int j = col; j < colLimit; ++j) {
                                if (i == row && j == col) continue;
                                this.addFill(i, j);
                            }
                        }
                        if (colSpan > 1) {
                            col += colSpan - 1;
                        }
                    }
                    ++cell;
                    ++col;
                }
                maxColumns = Math.max(maxColumns, col);
            }
            this.columnSpans = new int[maxColumns];
            this.columnOffsets = new int[maxColumns];
            this.columnRequirements = new SizeRequirements[maxColumns];
            for (int i = 0; i < maxColumns; ++i) {
                this.columnRequirements[i] = new SizeRequirements();
                this.columnRequirements[i].maximum = Integer.MAX_VALUE;
            }
            this.gridValid = true;
        }
    }

    void addFill(int row, int col) {
        RowView rv = this.getRow(row);
        if (rv != null) {
            rv.fillColumn(col);
        }
    }

    protected void layoutColumns(int targetSpan, int[] offsets, int[] spans, SizeRequirements[] reqs) {
        Arrays.fill(offsets, 0);
        Arrays.fill(spans, 0);
        this.colIterator.setLayoutArrays(offsets, spans, targetSpan);
        CSS.calculateTiledLayout(this.colIterator, targetSpan);
    }

    void calculateColumnRequirements(int axis) {
        View cv;
        int cell;
        int ncells;
        int col;
        RowView row;
        int i;
        for (SizeRequirements req : this.columnRequirements) {
            req.minimum = 0;
            req.preferred = 0;
            req.maximum = Integer.MAX_VALUE;
        }
        Container host = this.getContainer();
        if (host != null) {
            this.skipComments = host instanceof JTextComponent ? !((JTextComponent)host).isEditable() : true;
        }
        boolean hasMultiColumn = false;
        int nrows = this.getRowCount();
        for (i = 0; i < nrows; ++i) {
            row = this.getRow(i);
            col = 0;
            ncells = row.getViewCount();
            for (cell = 0; cell < ncells; ++cell) {
                cv = row.getView(cell);
                if (this.skipComments && !(cv instanceof CellView)) continue;
                while (row.isFilled(col)) {
                    ++col;
                }
                int rowSpan = this.getRowsOccupied(cv);
                int colSpan = this.getColumnsOccupied(cv);
                if (colSpan == 1) {
                    this.checkSingleColumnCell(axis, col, cv);
                } else {
                    hasMultiColumn = true;
                    col += colSpan - 1;
                }
                ++col;
            }
        }
        if (hasMultiColumn) {
            for (i = 0; i < nrows; ++i) {
                row = this.getRow(i);
                col = 0;
                ncells = row.getViewCount();
                for (cell = 0; cell < ncells; ++cell) {
                    cv = row.getView(cell);
                    if (this.skipComments && !(cv instanceof CellView)) continue;
                    while (row.isFilled(col)) {
                        ++col;
                    }
                    int colSpan = this.getColumnsOccupied(cv);
                    if (colSpan > 1) {
                        this.checkMultiColumnCell(axis, col, colSpan, cv);
                        col += colSpan - 1;
                    }
                    ++col;
                }
            }
        }
    }

    void checkSingleColumnCell(int axis, int col, View v) {
        SizeRequirements req = this.columnRequirements[col];
        req.minimum = Math.max((int)v.getMinimumSpan(axis), req.minimum);
        req.preferred = Math.max((int)v.getPreferredSpan(axis), req.preferred);
    }

    void checkMultiColumnCell(int axis, int col, int ncols, View v) {
        int cpref;
        long min = 0L;
        long pref = 0L;
        long max = 0L;
        for (int i = 0; i < ncols; ++i) {
            SizeRequirements req = this.columnRequirements[col + i];
            min += (long)req.minimum;
            pref += (long)req.preferred;
            max += (long)req.maximum;
        }
        int cmin = (int)v.getMinimumSpan(axis);
        if ((long)cmin > min) {
            SizeRequirements[] reqs = new SizeRequirements[ncols];
            for (int i = 0; i < ncols; ++i) {
                reqs[i] = this.columnRequirements[col + i];
            }
            int[] spans = new int[ncols];
            int[] offsets = new int[ncols];
            SizeRequirements.calculateTiledPositions(cmin, null, reqs, offsets, spans);
            for (int i = 0; i < ncols; ++i) {
                SizeRequirements req = reqs[i];
                req.minimum = Math.max(spans[i], req.minimum);
                req.preferred = Math.max(req.minimum, req.preferred);
                req.maximum = Math.max(req.preferred, req.maximum);
            }
        }
        if ((long)(cpref = (int)v.getPreferredSpan(axis)) > pref) {
            SizeRequirements[] reqs = new SizeRequirements[ncols];
            for (int i = 0; i < ncols; ++i) {
                reqs[i] = this.columnRequirements[col + i];
            }
            int[] spans = new int[ncols];
            int[] offsets = new int[ncols];
            SizeRequirements.calculateTiledPositions(cpref, null, reqs, offsets, spans);
            for (int i = 0; i < ncols; ++i) {
                SizeRequirements req = reqs[i];
                req.preferred = Math.max(spans[i], req.preferred);
                req.maximum = Math.max(req.preferred, req.maximum);
            }
        }
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        String ta;
        this.updateGrid();
        this.calculateColumnRequirements(axis);
        if (r == null) {
            r = new SizeRequirements();
        }
        long min = 0L;
        long pref = 0L;
        int n = this.columnRequirements.length;
        for (int i = 0; i < n; ++i) {
            SizeRequirements req = this.columnRequirements[i];
            min += (long)req.minimum;
            pref += (long)req.preferred;
        }
        int adjust = (n + 1) * this.cellSpacing + 2 * this.borderWidth;
        r.minimum = (int)(min += (long)adjust);
        r.preferred = (int)(pref += (long)adjust);
        r.maximum = (int)pref;
        AttributeSet attr = this.getAttributes();
        CSS.LengthValue cssWidth = (CSS.LengthValue)attr.getAttribute(CSS.Attribute.WIDTH);
        if (BlockView.spanSetFromAttributes(axis, r, cssWidth, null) && r.minimum < (int)min) {
            r.minimum = r.preferred = (int)min;
            r.maximum = r.preferred;
        }
        this.totalColumnRequirements.minimum = r.minimum;
        this.totalColumnRequirements.preferred = r.preferred;
        this.totalColumnRequirements.maximum = r.maximum;
        Object o = attr.getAttribute(CSS.Attribute.TEXT_ALIGN);
        r.alignment = o != null ? ((ta = o.toString()).equals("left") ? 0.0f : (ta.equals("center") ? 0.5f : (ta.equals("right") ? 1.0f : 0.0f))) : 0.0f;
        return r;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        this.updateInsets();
        this.rowIterator.updateAdjustments();
        r = CSS.calculateTiledRequirements(this.rowIterator, r);
        r.maximum = r.preferred;
        return r;
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.updateGrid();
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            RowView row = this.getRow(i);
            row.layoutChanged(axis);
        }
        this.layoutColumns(targetSpan, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(targetSpan, axis, offsets, spans);
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.rowIterator.setLayoutArrays(offsets, spans);
        CSS.calculateTiledLayout(this.rowIterator, targetSpan);
        if (this.captionIndex != -1) {
            int h;
            View caption = this.getView(this.captionIndex);
            spans[this.captionIndex] = h = (int)caption.getPreferredSpan(1);
            short boxBottom = (short)this.painter.getInset(3, this);
            offsets[this.captionIndex] = boxBottom != this.getBottomInset() ? targetSpan + boxBottom : (int)(-this.getTopInset());
        }
    }

    protected View getViewAtPosition(int pos, Rectangle a) {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            int p0 = v.getStartOffset();
            int p1 = v.getEndOffset();
            if (pos < p0 || pos >= p1) continue;
            if (a != null) {
                this.childAllocation(i, a);
            }
            return v;
        }
        if (pos == this.getEndOffset()) {
            View v = this.getView(n - 1);
            if (a != null) {
                this.childAllocation(n - 1, a);
            }
            return v;
        }
        return null;
    }

    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet sheet = this.getStyleSheet();
            this.attr = sheet.getViewAttributes(this);
        }
        return this.attr;
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle a = allocation.getBounds();
        this.setSize(a.width, a.height);
        if (this.captionIndex != -1) {
            short top = (short)this.painter.getInset(1, this);
            short bottom = (short)this.painter.getInset(3, this);
            if (top != this.getTopInset()) {
                int h = this.getTopInset() - top;
                a.y += h;
                a.height -= h;
            } else {
                a.height -= this.getBottomInset() - bottom;
            }
        }
        this.painter.paint(g, a.x, a.y, a.width, a.height, this);
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            v.paint(g, this.getChildAllocation(i, allocation));
        }
    }

    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setPropertiesFromAttributes();
        }
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, this);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, this);
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, this);
    }

    protected void forwardUpdate(DocumentEvent.ElementChange ec, DocumentEvent e, Shape a, ViewFactory f) {
        Container c;
        super.forwardUpdate(ec, e, a, f);
        if (a != null && (c = this.getContainer()) != null) {
            Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
        }
    }

    public void replace(int offset, int length, View[] views) {
        super.replace(offset, length, views);
        this.invalidateGrid();
    }

    public View create(Element elem) {
        ViewFactory f;
        View p;
        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (o instanceof HTML.Tag) {
            HTML.Tag kind = (HTML.Tag)o;
            if (kind == HTML.Tag.TR) {
                return this.createTableRow(elem);
            }
            if (kind == HTML.Tag.TD || kind == HTML.Tag.TH) {
                return new CellView(elem);
            }
            if (kind == HTML.Tag.CAPTION) {
                return new ParagraphView(elem);
            }
        }
        if ((p = this.getParent()) != null && (f = p.getViewFactory()) != null) {
            return f.create(elem);
        }
        return null;
    }

    class CellView
    extends BlockView {
        public CellView(Element elem) {
            super(elem, 1);
        }

        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            int used = 0;
            int n = spans.length;
            for (int i = 0; i < n; ++i) {
                used += spans[i];
            }
            int adjust = 0;
            if (used < targetSpan) {
                String valign = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.VALIGN);
                if (valign == null) {
                    AttributeSet rowAttr = this.getElement().getParentElement().getAttributes();
                    valign = (String)rowAttr.getAttribute(HTML.Attribute.VALIGN);
                }
                if (valign == null || valign.equals("middle")) {
                    adjust = (targetSpan - used) / 2;
                } else if (valign.equals("bottom")) {
                    adjust = targetSpan - used;
                }
            }
            if (adjust != 0) {
                int i = 0;
                while (i < n) {
                    int n2 = i++;
                    offsets[n2] = offsets[n2] + adjust;
                }
            }
        }

        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            SizeRequirements req = super.calculateMajorAxisRequirements(axis, r);
            req.maximum = Integer.MAX_VALUE;
            return req;
        }

        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            SizeRequirements rv = super.calculateMinorAxisRequirements(axis, r);
            int n = this.getViewCount();
            int min = 0;
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                min = Math.max((int)v.getMinimumSpan(axis), min);
            }
            rv.minimum = Math.min(rv.minimum, min);
            return rv;
        }
    }

    public class RowView
    extends BoxView {
        private StyleSheet.BoxPainter painter;
        private AttributeSet attr;
        BitSet fillColumns;
        int rowIndex;
        int viewIndex;
        boolean multiRowCells;

        public RowView(Element elem) {
            super(elem, 0);
            this.fillColumns = new BitSet();
            this.setPropertiesFromAttributes();
        }

        void clearFilledColumns() {
            this.fillColumns.and(EMPTY);
        }

        void fillColumn(int col) {
            this.fillColumns.set(col);
        }

        boolean isFilled(int col) {
            return this.fillColumns.get(col);
        }

        int getColumnCount() {
            int nfill = 0;
            int n = this.fillColumns.size();
            for (int i = 0; i < n; ++i) {
                if (!this.fillColumns.get(i)) continue;
                ++nfill;
            }
            return this.getViewCount() + nfill;
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        View findViewAtPoint(int x, int y, Rectangle alloc) {
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                if (!this.getChildAllocation(i, alloc).contains(x, y)) continue;
                this.childAllocation(i, alloc);
                return this.getView(i);
            }
            return null;
        }

        protected StyleSheet getStyleSheet() {
            HTMLDocument doc = (HTMLDocument)this.getDocument();
            return doc.getStyleSheet();
        }

        public void preferenceChanged(View child, boolean width, boolean height) {
            super.preferenceChanged(child, width, height);
            if (TableView.this.multiRowCells && height) {
                for (int i = this.rowIndex - 1; i >= 0; --i) {
                    RowView rv = TableView.this.getRow(i);
                    if (!rv.multiRowCells) continue;
                    rv.preferenceChanged(null, false, true);
                    break;
                }
            }
        }

        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            SizeRequirements req = new SizeRequirements();
            req.minimum = TableView.this.totalColumnRequirements.minimum;
            req.maximum = TableView.this.totalColumnRequirements.maximum;
            req.preferred = TableView.this.totalColumnRequirements.preferred;
            req.alignment = 0.0f;
            return req;
        }

        public float getMinimumSpan(int axis) {
            float value = axis == 0 ? (float)(TableView.this.totalColumnRequirements.minimum + this.getLeftInset() + this.getRightInset()) : super.getMinimumSpan(axis);
            return value;
        }

        public float getMaximumSpan(int axis) {
            float value = axis == 0 ? 2.1474836E9f : super.getMaximumSpan(axis);
            return value;
        }

        public float getPreferredSpan(int axis) {
            float value = axis == 0 ? (float)(TableView.this.totalColumnRequirements.preferred + this.getLeftInset() + this.getRightInset()) : super.getPreferredSpan(axis);
            return value;
        }

        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            super.changedUpdate(e, a, f);
            int pos = e.getOffset();
            if (pos <= this.getStartOffset() && pos + e.getLength() >= this.getEndOffset()) {
                this.setPropertiesFromAttributes();
            }
        }

        public void paint(Graphics g, Shape allocation) {
            Rectangle a = (Rectangle)allocation;
            this.painter.paint(g, a.x, a.y, a.width, a.height, this);
            super.paint(g, a);
        }

        public void replace(int offset, int length, View[] views) {
            super.replace(offset, length, views);
            TableView.this.invalidateGrid();
        }

        protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
            long min = 0L;
            long pref = 0L;
            long max = 0L;
            this.multiRowCells = false;
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                if (TableView.this.getRowsOccupied(v) > 1) {
                    this.multiRowCells = true;
                    max = Math.max((long)((int)v.getMaximumSpan(axis)), max);
                    continue;
                }
                min = Math.max((long)((int)v.getMinimumSpan(axis)), min);
                pref = Math.max((long)((int)v.getPreferredSpan(axis)), pref);
                max = Math.max((long)((int)v.getMaximumSpan(axis)), max);
            }
            if (r == null) {
                r = new SizeRequirements();
                r.alignment = 0.5f;
            }
            r.preferred = (int)pref;
            r.minimum = (int)min;
            r.maximum = (int)max;
            return r;
        }

        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int col = 0;
            int ncells = this.getViewCount();
            for (int cell = 0; cell < ncells; ++cell) {
                View cv = this.getView(cell);
                if (TableView.this.skipComments && !(cv instanceof CellView)) continue;
                while (this.isFilled(col)) {
                    ++col;
                }
                int colSpan = TableView.this.getColumnsOccupied(cv);
                spans[cell] = TableView.this.columnSpans[col];
                offsets[cell] = TableView.this.columnOffsets[col];
                if (colSpan > 1) {
                    int n = TableView.this.columnSpans.length;
                    for (int j = 1; j < colSpan; ++j) {
                        if (col + j >= n) continue;
                        int n2 = cell;
                        spans[n2] = spans[n2] + TableView.this.columnSpans[col + j];
                        int n3 = cell;
                        spans[n3] = spans[n3] + TableView.this.cellSpacing;
                    }
                    col += colSpan - 1;
                }
                ++col;
            }
        }

        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            super.layoutMinorAxis(targetSpan, axis, offsets, spans);
            int col = 0;
            int ncells = this.getViewCount();
            int cell = 0;
            while (cell < ncells) {
                View cv = this.getView(cell);
                while (this.isFilled(col)) {
                    ++col;
                }
                int colSpan = TableView.this.getColumnsOccupied(cv);
                int rowSpan = TableView.this.getRowsOccupied(cv);
                if (rowSpan > 1) {
                    int row0 = this.rowIndex;
                    int row1 = Math.min(this.rowIndex + rowSpan - 1, TableView.this.getRowCount() - 1);
                    spans[cell] = TableView.this.getMultiRowSpan(row0, row1);
                }
                if (colSpan > 1) {
                    col += colSpan - 1;
                }
                ++cell;
                ++col;
            }
        }

        public int getResizeWeight(int axis) {
            return 1;
        }

        protected View getViewAtPosition(int pos, Rectangle a) {
            int n = this.getViewCount();
            for (int i = 0; i < n; ++i) {
                View v = this.getView(i);
                int p0 = v.getStartOffset();
                int p1 = v.getEndOffset();
                if (pos < p0 || pos >= p1) continue;
                if (a != null) {
                    this.childAllocation(i, a);
                }
                return v;
            }
            if (pos == this.getEndOffset()) {
                View v = this.getView(n - 1);
                if (a != null) {
                    this.childAllocation(n - 1, a);
                }
                return v;
            }
            return null;
        }

        void setPropertiesFromAttributes() {
            StyleSheet sheet = this.getStyleSheet();
            this.attr = sheet.getViewAttributes(this);
            this.painter = sheet.getBoxPainter(this.attr);
        }
    }

    class RowIterator
    implements CSS.LayoutIterator {
        private int row;
        private int[] adjustments;
        private int[] offsets;
        private int[] spans;

        RowIterator() {
        }

        void updateAdjustments() {
            int axis = 1;
            if (TableView.this.multiRowCells) {
                int n = TableView.this.getRowCount();
                this.adjustments = new int[n];
                for (int i = 0; i < n; ++i) {
                    RowView rv = TableView.this.getRow(i);
                    if (!rv.multiRowCells) continue;
                    int ncells = rv.getViewCount();
                    for (int j = 0; j < ncells; ++j) {
                        View v = rv.getView(j);
                        int nrows = TableView.this.getRowsOccupied(v);
                        if (nrows <= 1) continue;
                        int spanNeeded = (int)v.getPreferredSpan(axis);
                        this.adjustMultiRowSpan(spanNeeded, nrows, i);
                    }
                }
            } else {
                this.adjustments = null;
            }
        }

        void adjustMultiRowSpan(int spanNeeded, int nrows, int rowIndex) {
            if (rowIndex + nrows > this.getCount() && (nrows = this.getCount() - rowIndex) < 1) {
                return;
            }
            int span = 0;
            for (int i = 0; i < nrows; ++i) {
                RowView rv = TableView.this.getRow(rowIndex + i);
                span = (int)((float)span + rv.getPreferredSpan(1));
            }
            if (spanNeeded > span) {
                int adjust = spanNeeded - span;
                int rowAdjust = adjust / nrows;
                int firstAdjust = rowAdjust + (adjust - rowAdjust * nrows);
                RowView rv = TableView.this.getRow(rowIndex);
                this.adjustments[rowIndex] = Math.max(this.adjustments[rowIndex], firstAdjust);
                for (int i = 1; i < nrows; ++i) {
                    this.adjustments[rowIndex + i] = Math.max(this.adjustments[rowIndex + i], rowAdjust);
                }
            }
        }

        void setLayoutArrays(int[] offsets, int[] spans) {
            this.offsets = offsets;
            this.spans = spans;
        }

        public void setOffset(int offs) {
            RowView rv = TableView.this.getRow(this.row);
            if (rv != null) {
                this.offsets[rv.viewIndex] = offs;
            }
        }

        public int getOffset() {
            RowView rv = TableView.this.getRow(this.row);
            if (rv != null) {
                return this.offsets[rv.viewIndex];
            }
            return 0;
        }

        public void setSpan(int span) {
            RowView rv = TableView.this.getRow(this.row);
            if (rv != null) {
                this.spans[rv.viewIndex] = span;
            }
        }

        public int getSpan() {
            RowView rv = TableView.this.getRow(this.row);
            if (rv != null) {
                return this.spans[rv.viewIndex];
            }
            return 0;
        }

        public int getCount() {
            return TableView.this.rows.size();
        }

        public void setIndex(int i) {
            this.row = i;
        }

        public float getMinimumSpan(float parentSpan) {
            return this.getPreferredSpan(parentSpan);
        }

        public float getPreferredSpan(float parentSpan) {
            RowView rv = TableView.this.getRow(this.row);
            if (rv != null) {
                int adjust = this.adjustments != null ? this.adjustments[this.row] : 0;
                return rv.getPreferredSpan(TableView.this.getAxis()) + (float)adjust;
            }
            return 0.0f;
        }

        public float getMaximumSpan(float parentSpan) {
            return this.getPreferredSpan(parentSpan);
        }

        public float getBorderWidth() {
            return TableView.this.borderWidth;
        }

        public float getLeadingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        public float getTrailingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        public int getAdjustmentWeight() {
            return 0;
        }
    }

    class ColumnIterator
    implements CSS.LayoutIterator {
        private int col;
        private int[] percentages;
        private int[] adjustmentWeights;
        private int[] offsets;
        private int[] spans;

        ColumnIterator() {
        }

        void disablePercentages() {
            this.percentages = null;
        }

        private void updatePercentagesAndAdjustmentWeights(int span) {
            this.adjustmentWeights = new int[TableView.this.columnRequirements.length];
            for (int i = 0; i < TableView.this.columnRequirements.length; ++i) {
                this.adjustmentWeights[i] = 0;
            }
            this.percentages = (int[])(TableView.this.relativeCells ? new int[TableView.this.columnRequirements.length] : null);
            int nrows = TableView.this.getRowCount();
            for (int rowIndex = 0; rowIndex < nrows; ++rowIndex) {
                RowView row = TableView.this.getRow(rowIndex);
                int col = 0;
                int ncells = row.getViewCount();
                int cell = 0;
                while (cell < ncells) {
                    View cv = row.getView(cell);
                    while (row.isFilled(col)) {
                        ++col;
                    }
                    int rowSpan = TableView.this.getRowsOccupied(cv);
                    int colSpan = TableView.this.getColumnsOccupied(cv);
                    AttributeSet a = cv.getAttributes();
                    CSS.LengthValue lv = (CSS.LengthValue)a.getAttribute(CSS.Attribute.WIDTH);
                    if (lv != null) {
                        int len = (int)(lv.getValue(span) / (float)colSpan + 0.5f);
                        for (int i = 0; i < colSpan; ++i) {
                            if (lv.isPercentage()) {
                                this.percentages[col + i] = Math.max(this.percentages[col + i], len);
                                this.adjustmentWeights[col + i] = Math.max(this.adjustmentWeights[col + i], 2);
                                continue;
                            }
                            this.adjustmentWeights[col + i] = Math.max(this.adjustmentWeights[col + i], 1);
                        }
                    }
                    col += colSpan - 1;
                    ++cell;
                    ++col;
                }
            }
        }

        public void setLayoutArrays(int[] offsets, int[] spans, int targetSpan) {
            this.offsets = offsets;
            this.spans = spans;
            this.updatePercentagesAndAdjustmentWeights(targetSpan);
        }

        public int getCount() {
            return TableView.this.columnRequirements.length;
        }

        public void setIndex(int i) {
            this.col = i;
        }

        public void setOffset(int offs) {
            this.offsets[this.col] = offs;
        }

        public int getOffset() {
            return this.offsets[this.col];
        }

        public void setSpan(int span) {
            this.spans[this.col] = span;
        }

        public int getSpan() {
            return this.spans[this.col];
        }

        public float getMinimumSpan(float parentSpan) {
            return TableView.this.columnRequirements[this.col].minimum;
        }

        public float getPreferredSpan(float parentSpan) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], TableView.this.columnRequirements[this.col].minimum);
            }
            return TableView.this.columnRequirements[this.col].preferred;
        }

        public float getMaximumSpan(float parentSpan) {
            return TableView.this.columnRequirements[this.col].maximum;
        }

        public float getBorderWidth() {
            return TableView.this.borderWidth;
        }

        public float getLeadingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        public float getTrailingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        public int getAdjustmentWeight() {
            return this.adjustmentWeights[this.col];
        }
    }
}

