/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;

public class ModelMBeanOperationInfo
extends MBeanOperationInfo
implements DescriptorAccess {
    private static final long oldSerialVersionUID = 9087646304346171239L;
    private static final long newSerialVersionUID = 6532732096650090465L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("operationDescriptor", Descriptor.class), new ObjectStreamField("currClass", String.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("operationDescriptor", Descriptor.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private Descriptor operationDescriptor = this.createDefaultDescriptor();
    private static final String currClass = "ModelMBeanOperationInfo";

    public ModelMBeanOperationInfo(String description, Method operationMethod) {
        super(description, operationMethod);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(String,Method)", "Entry");
        }
        this.operationDescriptor = this.createDefaultDescriptor();
    }

    public ModelMBeanOperationInfo(String description, Method operationMethod, Descriptor descriptor) {
        super(description, operationMethod);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(String,Method,Descriptor)", "Entry");
        }
        if (descriptor == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(String, Method, Descriptor)", "Received null for new descriptor value, setting descriptor to default values");
            }
            this.operationDescriptor = this.createDefaultDescriptor();
        } else if (this.isValid(descriptor)) {
            this.operationDescriptor = (Descriptor)descriptor.clone();
        } else {
            this.operationDescriptor = this.createDefaultDescriptor();
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor passed in parameter"), "Exception occurred in ModelMBeanOperationInfo constructor");
        }
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact) {
        super(name, description, signature, type, impact);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(String,String,MBeanParameterInfo[],String,int)", "Entry");
        }
        this.operationDescriptor = this.createDefaultDescriptor();
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact, Descriptor descriptor) {
        super(name, description, signature, type, impact);
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(String,String,MBeanParameterInfo[],String,int,Descriptor)", "Entry");
        }
        if (descriptor == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo()", "Received null for new descriptor value, setting descriptor to default values");
            }
            this.operationDescriptor = this.createDefaultDescriptor();
        } else if (this.isValid(descriptor)) {
            this.operationDescriptor = (Descriptor)descriptor.clone();
        } else {
            this.operationDescriptor = this.createDefaultDescriptor();
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor passed in parameter"), "Exception occurred in ModelMBeanOperationInfo constructor");
        }
    }

    public ModelMBeanOperationInfo(ModelMBeanOperationInfo inInfo) {
        super(inInfo.getName(), inInfo.getDescription(), inInfo.getSignature(), inInfo.getReturnType(), inInfo.getImpact());
        Descriptor newDesc;
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "ModelMBeanOperationInfo(ModelMBeanOperationInfo)", "Entry");
        }
        if ((newDesc = inInfo.getDescriptor()) == null) {
            this.operationDescriptor = this.createDefaultDescriptor();
        } else if (this.isValid(newDesc)) {
            this.operationDescriptor = (Descriptor)newDesc.clone();
        } else {
            this.operationDescriptor = this.createDefaultDescriptor();
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor passed in parameter"), "Exception occurred in ModelMBeanOperationInfo constructor");
        }
    }

    public Object clone() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "clone()", "Entry");
        }
        return new ModelMBeanOperationInfo(this);
    }

    public Descriptor getDescriptor() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "getDescriptor()", "Entry");
        }
        if (this.operationDescriptor == null) {
            this.operationDescriptor = this.createDefaultDescriptor();
        }
        return (Descriptor)this.operationDescriptor.clone();
    }

    public void setDescriptor(Descriptor inDescriptor) {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "setDescriptor(Descriptor)", "Entry");
        }
        if (inDescriptor == null) {
            if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "setDescriptor()", "Received null for new descriptor value, setting descriptor to default values");
            }
            this.operationDescriptor = this.createDefaultDescriptor();
        } else if (this.isValid(inDescriptor)) {
            this.operationDescriptor = (Descriptor)inDescriptor.clone();
        } else {
            throw new RuntimeOperationsException(new IllegalArgumentException("Invalid descriptor passed in parameter"), "Exception occurred in ModelMBeanOperationInfo setDescriptor");
        }
    }

    public String toString() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "toString()", "Entry");
        }
        String retStr = "ModelMBeanOperationInfo: " + this.getName() + " ; Description: " + this.getDescription() + " ; Descriptor: " + this.getDescriptor() + " ; ReturnType: " + this.getReturnType() + " ; Signature: ";
        MBeanParameterInfo[] pTypes = this.getSignature();
        for (int i = 0; i < pTypes.length; ++i) {
            retStr = retStr.concat(pTypes[i].getType() + ", ");
        }
        return retStr;
    }

    private Descriptor createDefaultDescriptor() {
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "createDefaultDescriptor()", "Entry");
        }
        return new DescriptorSupport("descriptorType=operation", "name=" + this.getName(), "role=operation", "displayname=" + this.getName());
    }

    private boolean isValid(Descriptor inDesc) {
        boolean results = true;
        String badField = "none";
        if (inDesc == null) {
            results = false;
        } else if (!inDesc.isValid()) {
            results = false;
        } else {
            Object roleValue;
            if (!((String)inDesc.getFieldValue("name")).equalsIgnoreCase(this.getName())) {
                results = false;
            }
            if (!((String)inDesc.getFieldValue("descriptorType")).equalsIgnoreCase("operation")) {
                results = false;
            }
            if ((roleValue = inDesc.getFieldValue("role")) == null) {
                inDesc.setField("role", "operation");
            } else {
                String role = (String)roleValue;
                if (!(role.equalsIgnoreCase("operation") || role.equalsIgnoreCase("setter") || role.equalsIgnoreCase("getter"))) {
                    results = false;
                    badField = "role";
                }
            }
            Object targetValue = inDesc.getFieldValue("targetType");
            if (targetValue != null && !(targetValue instanceof String)) {
                results = false;
                badField = "targetType";
            }
            if (inDesc.getFieldValue("displayName") == null) {
                inDesc.setField("displayName", this.getName());
            }
        }
        if (JmxProperties.MODELMBEAN_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.MODELMBEAN_LOGGER.logp(Level.FINER, ModelMBeanOperationInfo.class.getName(), "isValid()", "Returning " + results + " : Invalid field is " + badField);
        }
        return results;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("operationDescriptor", this.operationDescriptor);
            fields.put("currClass", currClass);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 9087646304346171239L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 6532732096650090465L;
        }
    }
}

