/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassLoaderObjectOutputStream
extends ObjectOutputStream {
    private final Map<Set<String>, ClassLoader> map = new HashMap<Set<String>, ClassLoader>();

    public ClassLoaderObjectOutputStream(OutputStream os) throws IOException {
        super(os);
    }

    @Override
    protected void annotateClass(final Class<?> cl) throws IOException {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getClassLoader();
            }
        });
        HashSet<String> s = new HashSet<String>(1);
        s.add(cl.getName());
        this.map.put(s, classLoader);
    }

    @Override
    protected void annotateProxyClass(final Class<?> cl) throws IOException {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getClassLoader();
            }
        });
        Class<?>[] interfaces = cl.getInterfaces();
        HashSet<String> s = new HashSet<String>(interfaces.length);
        for (int i = 0; i < interfaces.length; ++i) {
            s.add(interfaces[i].getName());
        }
        this.map.put(s, classLoader);
    }

    public Map<Set<String>, ClassLoader> getClassLoaderMap() {
        return new HashMap<Set<String>, ClassLoader>(this.map);
    }
}

