/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelChannelMixer;
import com.sun.media.sound.ModelConnectionBlock;
import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelDirectedPlayer;
import com.sun.media.sound.ModelDirector;
import com.sun.media.sound.ModelIdentifier;
import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.ModelSource;
import com.sun.media.sound.ModelTransform;
import com.sun.media.sound.SoftControl;
import com.sun.media.sound.SoftInstrument;
import com.sun.media.sound.SoftMainMixer;
import com.sun.media.sound.SoftPerformer;
import com.sun.media.sound.SoftSynthesizer;
import com.sun.media.sound.SoftTuning;
import com.sun.media.sound.SoftVoice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.Patch;

public class SoftChannel
implements MidiChannel,
ModelDirectedPlayer {
    private static boolean[] dontResetControls = new boolean[128];
    private static final int RPN_NULL_VALUE = 16383;
    private int rpn_control = 16383;
    private int nrpn_control = 16383;
    protected double portamento_time = 1.0;
    protected int[] portamento_lastnote = new int[128];
    protected int portamento_lastnote_ix = 0;
    private boolean portamento = false;
    private boolean mono = false;
    private boolean mute = false;
    private boolean solo = false;
    private boolean solomute = false;
    private Object control_mutex;
    private int channel;
    private SoftVoice[] voices;
    private int bank;
    private int program;
    private SoftSynthesizer synthesizer;
    private SoftMainMixer mainmixer;
    private int[] polypressure = new int[128];
    private int channelpressure = 0;
    private int[] controller = new int[128];
    private int pitchbend;
    private double[] co_midi_pitch = new double[1];
    private double[] co_midi_channel_pressure = new double[1];
    protected SoftTuning tuning = new SoftTuning();
    protected int tuning_bank = 0;
    protected int tuning_program = 0;
    protected SoftInstrument current_instrument = null;
    protected ModelChannelMixer current_mixer = null;
    private ModelDirector current_director = null;
    protected int cds_control_number = -1;
    protected ModelConnectionBlock[] cds_control_connections = null;
    protected ModelConnectionBlock[] cds_channelpressure_connections = null;
    protected ModelConnectionBlock[] cds_polypressure_connections = null;
    protected boolean sustain = false;
    protected boolean[][] keybasedcontroller_active = null;
    protected double[][] keybasedcontroller_value = null;
    private SoftControl[] co_midi = new SoftControl[128];
    private double[][] co_midi_cc_cc;
    private SoftControl co_midi_cc;
    Map<Integer, int[]> co_midi_rpn_rpn_i;
    Map<Integer, double[]> co_midi_rpn_rpn;
    private SoftControl co_midi_rpn;
    Map<Integer, int[]> co_midi_nrpn_nrpn_i;
    Map<Integer, double[]> co_midi_nrpn_nrpn;
    private SoftControl co_midi_nrpn;
    private int[] lastVelocity;
    private int prevVoiceID;
    private boolean firstVoice;
    private int voiceNo;
    private int play_noteNumber;
    private int play_velocity;
    private int play_delay;
    private boolean play_releasetriggered;

    private static int restrict7Bit(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 127) {
            return 127;
        }
        return value;
    }

    private static int restrict14Bit(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 16256) {
            return 16256;
        }
        return value;
    }

    public SoftChannel(SoftSynthesizer synth2, int channel) {
        for (int i = 0; i < this.co_midi.length; ++i) {
            this.co_midi[i] = new MidiControlObject();
        }
        this.co_midi_cc_cc = new double[128][1];
        this.co_midi_cc = new SoftControl(){
            double[][] cc;
            {
                this.cc = SoftChannel.this.co_midi_cc_cc;
            }

            public double[] get(int instance, String name) {
                if (name == null) {
                    return null;
                }
                return this.cc[Integer.parseInt(name)];
            }
        };
        this.co_midi_rpn_rpn_i = new HashMap<Integer, int[]>();
        this.co_midi_rpn_rpn = new HashMap<Integer, double[]>();
        this.co_midi_rpn = new SoftControl(){
            Map<Integer, double[]> rpn;
            {
                this.rpn = SoftChannel.this.co_midi_rpn_rpn;
            }

            public double[] get(int instance, String name) {
                if (name == null) {
                    return null;
                }
                int iname = Integer.parseInt(name);
                double[] v = this.rpn.get(iname);
                if (v == null) {
                    v = new double[1];
                    this.rpn.put(iname, v);
                }
                return v;
            }
        };
        this.co_midi_nrpn_nrpn_i = new HashMap<Integer, int[]>();
        this.co_midi_nrpn_nrpn = new HashMap<Integer, double[]>();
        this.co_midi_nrpn = new SoftControl(){
            Map<Integer, double[]> nrpn;
            {
                this.nrpn = SoftChannel.this.co_midi_nrpn_nrpn;
            }

            public double[] get(int instance, String name) {
                if (name == null) {
                    return null;
                }
                int iname = Integer.parseInt(name);
                double[] v = this.nrpn.get(iname);
                if (v == null) {
                    v = new double[1];
                    this.nrpn.put(iname, v);
                }
                return v;
            }
        };
        this.lastVelocity = new int[128];
        this.firstVoice = true;
        this.voiceNo = 0;
        this.play_noteNumber = 0;
        this.play_velocity = 0;
        this.play_delay = 0;
        this.play_releasetriggered = false;
        this.channel = channel;
        this.voices = synth2.getVoices();
        this.synthesizer = synth2;
        this.mainmixer = synth2.getMainMixer();
        this.control_mutex = synth2.control_mutex;
        this.resetAllControllers(true);
    }

    private int findFreeVoice(int x) {
        int j;
        if (x == -1) {
            return -1;
        }
        for (int i = x; i < this.voices.length; ++i) {
            if (this.voices[i].active) continue;
            return i;
        }
        int vmode = this.synthesizer.getVoiceAllocationMode();
        if (vmode == 1) {
            int j2;
            int steal_channel = this.channel;
            for (int j3 = 0; j3 < this.voices.length; ++j3) {
                if (this.voices[j3].stealer_channel != null) continue;
                if (steal_channel == 9) {
                    steal_channel = this.voices[j3].channel;
                    continue;
                }
                if (this.voices[j3].channel == 9 || this.voices[j3].channel <= steal_channel) continue;
                steal_channel = this.voices[j3].channel;
            }
            int voiceNo = -1;
            SoftVoice v = null;
            for (j2 = 0; j2 < this.voices.length; ++j2) {
                if (this.voices[j2].channel != steal_channel || this.voices[j2].stealer_channel != null || this.voices[j2].on) continue;
                if (v == null) {
                    v = this.voices[j2];
                    voiceNo = j2;
                }
                if (this.voices[j2].voiceID >= v.voiceID) continue;
                v = this.voices[j2];
                voiceNo = j2;
            }
            if (voiceNo == -1) {
                for (j2 = 0; j2 < this.voices.length; ++j2) {
                    if (this.voices[j2].channel != steal_channel || this.voices[j2].stealer_channel != null) continue;
                    if (v == null) {
                        v = this.voices[j2];
                        voiceNo = j2;
                    }
                    if (this.voices[j2].voiceID >= v.voiceID) continue;
                    v = this.voices[j2];
                    voiceNo = j2;
                }
            }
            return voiceNo;
        }
        int voiceNo = -1;
        SoftVoice v = null;
        for (j = 0; j < this.voices.length; ++j) {
            if (this.voices[j].stealer_channel != null || this.voices[j].on) continue;
            if (v == null) {
                v = this.voices[j];
                voiceNo = j;
            }
            if (this.voices[j].voiceID >= v.voiceID) continue;
            v = this.voices[j];
            voiceNo = j;
        }
        if (voiceNo == -1) {
            for (j = 0; j < this.voices.length; ++j) {
                if (this.voices[j].stealer_channel != null) continue;
                if (v == null) {
                    v = this.voices[j];
                    voiceNo = j;
                }
                if (this.voices[j].voiceID >= v.voiceID) continue;
                v = this.voices[j];
                voiceNo = j;
            }
        }
        return voiceNo;
    }

    protected void initVoice(SoftVoice voice, SoftPerformer p, int voiceID, int noteNumber, int velocity, int delay, ModelConnectionBlock[] connectionBlocks, ModelChannelMixer channelmixer, boolean releaseTriggered) {
        if (voice.active) {
            voice.stealer_channel = this;
            voice.stealer_performer = p;
            voice.stealer_voiceID = voiceID;
            voice.stealer_noteNumber = noteNumber;
            voice.stealer_velocity = velocity;
            voice.stealer_extendedConnectionBlocks = connectionBlocks;
            voice.stealer_channelmixer = channelmixer;
            voice.stealer_releaseTriggered = releaseTriggered;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active || this.voices[i].voiceID != voice.voiceID) continue;
                this.voices[i].soundOff();
            }
            return;
        }
        voice.extendedConnectionBlocks = connectionBlocks;
        voice.channelmixer = channelmixer;
        voice.releaseTriggered = releaseTriggered;
        voice.voiceID = voiceID;
        voice.tuning = this.tuning;
        voice.exclusiveClass = p.exclusiveClass;
        voice.softchannel = this;
        voice.channel = this.channel;
        voice.bank = this.bank;
        voice.program = this.program;
        voice.instrument = this.current_instrument;
        voice.performer = p;
        voice.objects.clear();
        voice.objects.put("midi", this.co_midi[noteNumber]);
        voice.objects.put("midi_cc", this.co_midi_cc);
        voice.objects.put("midi_rpn", this.co_midi_rpn);
        voice.objects.put("midi_nrpn", this.co_midi_nrpn);
        voice.noteOn(noteNumber, velocity, delay);
        voice.setMute(this.mute);
        voice.setSoloMute(this.solomute);
        if (releaseTriggered) {
            return;
        }
        if (this.controller[84] != 0) {
            voice.co_noteon_keynumber[0] = this.tuning.getTuning(this.controller[84]) / 100.0 * 0.0078125;
            voice.portamento = true;
            this.controlChange(84, 0);
        } else if (this.portamento) {
            if (this.mono) {
                if (this.portamento_lastnote[0] != -1) {
                    voice.co_noteon_keynumber[0] = this.tuning.getTuning(this.portamento_lastnote[0]) / 100.0 * 0.0078125;
                    voice.portamento = true;
                    this.controlChange(84, 0);
                }
                this.portamento_lastnote[0] = noteNumber;
            } else if (this.portamento_lastnote_ix != 0) {
                --this.portamento_lastnote_ix;
                voice.co_noteon_keynumber[0] = this.tuning.getTuning(this.portamento_lastnote[this.portamento_lastnote_ix]) / 100.0 * 0.0078125;
                voice.portamento = true;
            }
        }
    }

    public void noteOn(int noteNumber, int velocity) {
        this.noteOn(noteNumber, velocity, 0);
    }

    protected void noteOn(int noteNumber, int velocity, int delay) {
        noteNumber = SoftChannel.restrict7Bit(noteNumber);
        velocity = SoftChannel.restrict7Bit(velocity);
        this.noteOn_internal(noteNumber, velocity, delay);
        if (this.current_mixer != null) {
            this.current_mixer.noteOn(noteNumber, velocity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteOn_internal(int noteNumber, int velocity, int delay) {
        if (velocity == 0) {
            this.noteOff_internal(noteNumber, 64);
            return;
        }
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.sustain) {
                this.sustain = false;
                for (int i = 0; i < this.voices.length; ++i) {
                    if (!this.voices[i].sustain && !this.voices[i].on || this.voices[i].channel != this.channel || !this.voices[i].active || this.voices[i].note != noteNumber) continue;
                    this.voices[i].sustain = false;
                    this.voices[i].on = true;
                    this.voices[i].noteOff(0);
                }
                this.sustain = true;
            }
            this.mainmixer.activity();
            if (this.mono) {
                int i;
                boolean n_found;
                if (this.portamento) {
                    n_found = false;
                    for (i = 0; i < this.voices.length; ++i) {
                        if (!this.voices[i].on || this.voices[i].channel != this.channel || !this.voices[i].active || this.voices[i].releaseTriggered) continue;
                        this.voices[i].portamento = true;
                        this.voices[i].setNote(noteNumber);
                        n_found = true;
                    }
                    if (n_found) {
                        this.portamento_lastnote[0] = noteNumber;
                        return;
                    }
                }
                if (this.controller[84] != 0) {
                    n_found = false;
                    for (i = 0; i < this.voices.length; ++i) {
                        if (!this.voices[i].on || this.voices[i].channel != this.channel || !this.voices[i].active || this.voices[i].note != this.controller[84] || this.voices[i].releaseTriggered) continue;
                        this.voices[i].portamento = true;
                        this.voices[i].setNote(noteNumber);
                        n_found = true;
                    }
                    this.controlChange(84, 0);
                    if (n_found) {
                        return;
                    }
                }
            }
            if (this.mono) {
                this.allNotesOff();
            }
            if (this.current_instrument == null) {
                this.current_instrument = this.synthesizer.findInstrument(this.program, this.bank, this.channel);
                if (this.current_instrument == null) {
                    return;
                }
                if (this.current_mixer != null) {
                    this.mainmixer.stopMixer(this.current_mixer);
                }
                this.current_mixer = this.current_instrument.getSourceInstrument().getChannelMixer(this, this.synthesizer.getFormat());
                if (this.current_mixer != null) {
                    this.mainmixer.registerMixer(this.current_mixer);
                }
                this.current_director = this.current_instrument.getDirector(this, this);
                this.applyInstrumentCustomization();
            }
            this.prevVoiceID = this.synthesizer.voiceIDCounter++;
            this.firstVoice = true;
            this.voiceNo = 0;
            int tunedKey = (int)Math.round(this.tuning.getTuning()[noteNumber] / 100.0);
            this.play_noteNumber = noteNumber;
            this.play_velocity = velocity;
            this.play_delay = delay;
            this.play_releasetriggered = false;
            this.lastVelocity[noteNumber] = velocity;
            this.current_director.noteOn(tunedKey, velocity);
        }
    }

    public void noteOff(int noteNumber, int velocity) {
        noteNumber = SoftChannel.restrict7Bit(noteNumber);
        velocity = SoftChannel.restrict7Bit(velocity);
        this.noteOff_internal(noteNumber, velocity);
        if (this.current_mixer != null) {
            this.current_mixer.noteOff(noteNumber, velocity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteOff_internal(int noteNumber, int velocity) {
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.mono && this.portamento && this.portamento_lastnote_ix != 127) {
                this.portamento_lastnote[this.portamento_lastnote_ix] = noteNumber;
                ++this.portamento_lastnote_ix;
            }
            this.mainmixer.activity();
            for (int i = 0; i < this.voices.length; ++i) {
                if (this.voices[i].on && this.voices[i].channel == this.channel && this.voices[i].note == noteNumber && !this.voices[i].releaseTriggered) {
                    this.voices[i].noteOff(velocity);
                }
                if (this.voices[i].stealer_channel != this || this.voices[i].stealer_noteNumber != noteNumber) continue;
                SoftVoice v = this.voices[i];
                v.stealer_releaseTriggered = false;
                v.stealer_channel = null;
                v.stealer_performer = null;
                v.stealer_voiceID = -1;
                v.stealer_noteNumber = 0;
                v.stealer_velocity = 0;
                v.stealer_extendedConnectionBlocks = null;
                v.stealer_channelmixer = null;
            }
            if (this.current_instrument == null) {
                this.current_instrument = this.synthesizer.findInstrument(this.program, this.bank, this.channel);
                if (this.current_instrument == null) {
                    return;
                }
                if (this.current_mixer != null) {
                    this.mainmixer.stopMixer(this.current_mixer);
                }
                this.current_mixer = this.current_instrument.getSourceInstrument().getChannelMixer(this, this.synthesizer.getFormat());
                if (this.current_mixer != null) {
                    this.mainmixer.registerMixer(this.current_mixer);
                }
                this.current_director = this.current_instrument.getDirector(this, this);
                this.applyInstrumentCustomization();
            }
            this.prevVoiceID = this.synthesizer.voiceIDCounter++;
            this.firstVoice = true;
            this.voiceNo = 0;
            int tunedKey = (int)Math.round(this.tuning.getTuning()[noteNumber] / 100.0);
            this.play_noteNumber = noteNumber;
            this.play_velocity = this.lastVelocity[noteNumber];
            this.play_releasetriggered = true;
            this.play_delay = 0;
            this.current_director.noteOff(tunedKey, velocity);
        }
    }

    public void play(int performerIndex, ModelConnectionBlock[] connectionBlocks) {
        int noteNumber = this.play_noteNumber;
        int velocity = this.play_velocity;
        int delay = this.play_delay;
        boolean releasetriggered = this.play_releasetriggered;
        SoftPerformer p = this.current_instrument.getPerformers()[performerIndex];
        if (this.firstVoice) {
            this.firstVoice = false;
            if (p.exclusiveClass != 0) {
                int x = p.exclusiveClass;
                for (int j = 0; j < this.voices.length; ++j) {
                    if (!this.voices[j].active || this.voices[j].channel != this.channel || this.voices[j].exclusiveClass != x || p.selfNonExclusive && this.voices[j].note == noteNumber) continue;
                    this.voices[j].shutdown();
                }
            }
        }
        this.voiceNo = this.findFreeVoice(this.voiceNo);
        if (this.voiceNo == -1) {
            return;
        }
        this.initVoice(this.voices[this.voiceNo], p, this.prevVoiceID, noteNumber, velocity, delay, connectionBlocks, this.current_mixer, releasetriggered);
    }

    public void noteOff(int noteNumber) {
        if (noteNumber < 0 || noteNumber > 127) {
            return;
        }
        this.noteOff_internal(noteNumber, 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolyPressure(int noteNumber, int pressure) {
        noteNumber = SoftChannel.restrict7Bit(noteNumber);
        pressure = SoftChannel.restrict7Bit(pressure);
        if (this.current_mixer != null) {
            this.current_mixer.setPolyPressure(noteNumber, pressure);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.mainmixer.activity();
            this.co_midi[noteNumber].get((int)0, (String)"poly_pressure")[0] = (double)pressure * 0.0078125;
            this.polypressure[noteNumber] = pressure;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active || this.voices[i].note != noteNumber) continue;
                this.voices[i].setPolyPressure(pressure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPolyPressure(int noteNumber) {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.polypressure[noteNumber];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelPressure(int pressure) {
        pressure = SoftChannel.restrict7Bit(pressure);
        if (this.current_mixer != null) {
            this.current_mixer.setChannelPressure(pressure);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.mainmixer.activity();
            this.co_midi_channel_pressure[0] = (double)pressure * 0.0078125;
            this.channelpressure = pressure;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active) continue;
                this.voices[i].setChannelPressure(pressure);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelPressure() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.channelpressure;
        }
    }

    protected void applyInstrumentCustomization() {
        if (this.cds_control_connections == null && this.cds_channelpressure_connections == null && this.cds_polypressure_connections == null) {
            return;
        }
        ModelInstrument src_instrument = this.current_instrument.getSourceInstrument();
        ModelPerformer[] performers = src_instrument.getPerformers();
        ModelPerformer[] new_performers = new ModelPerformer[performers.length];
        for (int i = 0; i < new_performers.length; ++i) {
            int j;
            ModelConnectionBlock conn;
            Iterator<ModelConnectionBlock> iter;
            ModelPerformer performer = performers[i];
            ModelPerformer new_performer = new ModelPerformer();
            new_performer.setName(performer.getName());
            new_performer.setExclusiveClass(performer.getExclusiveClass());
            new_performer.setKeyFrom(performer.getKeyFrom());
            new_performer.setKeyTo(performer.getKeyTo());
            new_performer.setVelFrom(performer.getVelFrom());
            new_performer.setVelTo(performer.getVelTo());
            new_performer.getOscillators().addAll(performer.getOscillators());
            new_performer.getConnectionBlocks().addAll(performer.getConnectionBlocks());
            new_performers[i] = new_performer;
            List<ModelConnectionBlock> connblocks = new_performer.getConnectionBlocks();
            if (this.cds_control_connections != null) {
                String cc = Integer.toString(this.cds_control_number);
                Iterator<ModelConnectionBlock> iter2 = connblocks.iterator();
                while (iter2.hasNext()) {
                    ModelConnectionBlock conn2 = iter2.next();
                    ModelSource[] sources = conn2.getSources();
                    boolean removeok = false;
                    if (sources != null) {
                        for (int j2 = 0; j2 < sources.length; ++j2) {
                            ModelSource src = sources[j2];
                            if (!"midi_cc".equals(src.getIdentifier().getObject()) || !cc.equals(src.getIdentifier().getVariable())) continue;
                            removeok = true;
                        }
                    }
                    if (!removeok) continue;
                    iter2.remove();
                }
                for (int j3 = 0; j3 < this.cds_control_connections.length; ++j3) {
                    connblocks.add(this.cds_control_connections[j3]);
                }
            }
            if (this.cds_polypressure_connections != null) {
                iter = connblocks.iterator();
                while (iter.hasNext()) {
                    conn = iter.next();
                    ModelSource[] sources = conn.getSources();
                    boolean removeok = false;
                    if (sources != null) {
                        for (j = 0; j < sources.length; ++j) {
                            ModelSource src = sources[j];
                            if (!"midi".equals(src.getIdentifier().getObject()) || !"poly_pressure".equals(src.getIdentifier().getVariable())) continue;
                            removeok = true;
                        }
                    }
                    if (!removeok) continue;
                    iter.remove();
                }
                for (int j4 = 0; j4 < this.cds_polypressure_connections.length; ++j4) {
                    connblocks.add(this.cds_polypressure_connections[j4]);
                }
            }
            if (this.cds_channelpressure_connections == null) continue;
            iter = connblocks.iterator();
            while (iter.hasNext()) {
                conn = iter.next();
                ModelSource[] sources = conn.getSources();
                boolean removeok = false;
                if (sources != null) {
                    for (j = 0; j < sources.length; ++j) {
                        ModelIdentifier srcid = sources[j].getIdentifier();
                        if (!"midi".equals(srcid.getObject()) || !"channel_pressure".equals(srcid.getVariable())) continue;
                        removeok = true;
                    }
                }
                if (!removeok) continue;
                iter.remove();
            }
            for (int j5 = 0; j5 < this.cds_channelpressure_connections.length; ++j5) {
                connblocks.add(this.cds_channelpressure_connections[j5]);
            }
        }
        this.current_instrument = new SoftInstrument(src_instrument, new_performers);
    }

    private ModelConnectionBlock[] createModelConnections(ModelIdentifier sid, int[] destination, int[] range) {
        ArrayList<ModelConnectionBlock> conns = new ArrayList<ModelConnectionBlock>();
        for (int i = 0; i < destination.length; ++i) {
            ModelConnectionBlock conn;
            ModelTransform mt;
            ModelConnectionBlock conn2;
            double scale;
            int d = destination[i];
            int r = range[i];
            if (d == 0) {
                scale = (r - 64) * 100;
                conn2 = new ModelConnectionBlock(new ModelSource(sid, false, false, 0), scale, new ModelDestination(new ModelIdentifier("osc", "pitch")));
                conns.add(conn2);
            }
            if (d == 1) {
                scale = ((double)r / 64.0 - 1.0) * 9600.0;
                conn2 = scale > 0.0 ? new ModelConnectionBlock(new ModelSource(sid, true, false, 0), -scale, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ)) : new ModelConnectionBlock(new ModelSource(sid, false, false, 0), scale, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ));
                conns.add(conn2);
            }
            if (d == 2) {
                scale = (double)r / 64.0;
                mt = new ModelTransform(){
                    double s;
                    {
                        this.s = scale;
                    }

                    public double transform(double value) {
                        if (this.s < 1.0) {
                            value = this.s + value * (1.0 - this.s);
                        } else if (this.s > 1.0) {
                            value = 1.0 + value * (this.s - 1.0);
                        } else {
                            return 0.0;
                        }
                        return -(0.4166666666666667 / Math.log(10.0)) * Math.log(value);
                    }
                };
                conn = new ModelConnectionBlock(new ModelSource(sid, mt), -960.0, new ModelDestination(ModelDestination.DESTINATION_GAIN));
                conns.add(conn);
            }
            if (d == 3) {
                scale = ((double)r / 64.0 - 1.0) * 9600.0;
                conn2 = new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO1, false, true, 0), new ModelSource(sid, false, false, 0), scale, new ModelDestination(ModelDestination.DESTINATION_PITCH));
                conns.add(conn2);
            }
            if (d == 4) {
                scale = (double)r / 128.0 * 2400.0;
                conn2 = new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO1, false, true, 0), new ModelSource(sid, false, false, 0), scale, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ));
                conns.add(conn2);
            }
            if (d != 5) continue;
            scale = (double)r / 127.0;
            mt = new ModelTransform(){
                double s;
                {
                    this.s = scale;
                }

                public double transform(double value) {
                    return -(0.4166666666666667 / Math.log(10.0)) * Math.log(1.0 - value * this.s);
                }
            };
            conn = new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO1, false, false, 0), new ModelSource(sid, mt), -960.0, new ModelDestination(ModelDestination.DESTINATION_GAIN));
            conns.add(conn);
        }
        return conns.toArray(new ModelConnectionBlock[conns.size()]);
    }

    public void mapPolyPressureToDestination(int[] destination, int[] range) {
        this.current_instrument = null;
        if (destination.length == 0) {
            this.cds_polypressure_connections = null;
            return;
        }
        this.cds_polypressure_connections = this.createModelConnections(new ModelIdentifier("midi", "poly_pressure"), destination, range);
    }

    public void mapChannelPressureToDestination(int[] destination, int[] range) {
        this.current_instrument = null;
        if (destination.length == 0) {
            this.cds_channelpressure_connections = null;
            return;
        }
        this.cds_channelpressure_connections = this.createModelConnections(new ModelIdentifier("midi", "channel_pressure"), destination, range);
    }

    public void mapControlToDestination(int control, int[] destination, int[] range) {
        if (!(control >= 1 && control <= 31 || control >= 64 && control <= 95)) {
            this.cds_control_connections = null;
            return;
        }
        this.current_instrument = null;
        this.cds_control_number = control;
        if (destination.length == 0) {
            this.cds_control_connections = null;
            return;
        }
        this.cds_control_connections = this.createModelConnections(new ModelIdentifier("midi_cc", Integer.toString(control)), destination, range);
    }

    public void controlChangePerNote(int noteNumber, int controller, int value) {
        block8: {
            block9: {
                block7: {
                    if (this.keybasedcontroller_active == null) {
                        this.keybasedcontroller_active = new boolean[128][];
                        this.keybasedcontroller_value = new double[128][];
                    }
                    if (this.keybasedcontroller_active[noteNumber] == null) {
                        this.keybasedcontroller_active[noteNumber] = new boolean[128];
                        Arrays.fill(this.keybasedcontroller_active[noteNumber], false);
                        this.keybasedcontroller_value[noteNumber] = new double[128];
                        Arrays.fill(this.keybasedcontroller_value[noteNumber], 0.0);
                    }
                    if (value == -1) {
                        this.keybasedcontroller_active[noteNumber][controller] = false;
                    } else {
                        this.keybasedcontroller_active[noteNumber][controller] = true;
                        this.keybasedcontroller_value[noteNumber][controller] = (double)value / 128.0;
                    }
                    if (controller >= 120) break block7;
                    for (int i = 0; i < this.voices.length; ++i) {
                        if (!this.voices[i].active) continue;
                        this.voices[i].controlChange(controller, -1);
                    }
                    break block8;
                }
                if (controller != 120) break block9;
                for (int i = 0; i < this.voices.length; ++i) {
                    if (!this.voices[i].active) continue;
                    this.voices[i].rpnChange(1, -1);
                }
                break block8;
            }
            if (controller != 121) break block8;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active) continue;
                this.voices[i].rpnChange(2, -1);
            }
        }
    }

    public int getControlPerNote(int noteNumber, int controller) {
        if (this.keybasedcontroller_active == null) {
            return -1;
        }
        if (this.keybasedcontroller_active[noteNumber] == null) {
            return -1;
        }
        if (!this.keybasedcontroller_active[noteNumber][controller]) {
            return -1;
        }
        return (int)(this.keybasedcontroller_value[noteNumber][controller] * 128.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controlChange(int controller, int value) {
        controller = SoftChannel.restrict7Bit(controller);
        value = SoftChannel.restrict7Bit(value);
        if (this.current_mixer != null) {
            this.current_mixer.controlChange(controller, value);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            switch (controller) {
                case 5: {
                    double x = -Math.asin((double)value / 128.0 * 2.0 - 1.0) / Math.PI + 0.5;
                    x = Math.pow(100000.0, x) / 100.0;
                    x /= 100.0;
                    x *= 1000.0;
                    this.portamento_time = x /= (double)this.synthesizer.getControlRate();
                    break;
                }
                case 6: 
                case 38: 
                case 96: 
                case 97: {
                    int[] val_i;
                    int val = 0;
                    if (this.nrpn_control != 16383 && (val_i = this.co_midi_nrpn_nrpn_i.get(this.nrpn_control)) != null) {
                        val = val_i[0];
                    }
                    if (this.rpn_control != 16383 && (val_i = this.co_midi_rpn_rpn_i.get(this.rpn_control)) != null) {
                        val = val_i[0];
                    }
                    if (controller == 6) {
                        val = (val & 0x7F) + (value << 7);
                    } else if (controller == 38) {
                        val = (val & 0x3F80) + value;
                    } else if (controller == 96 || controller == 97) {
                        int step = 1;
                        if (this.rpn_control == 2 || this.rpn_control == 3 || this.rpn_control == 4) {
                            step = 128;
                        }
                        if (controller == 96) {
                            val += step;
                        }
                        if (controller == 97) {
                            val -= step;
                        }
                    }
                    if (this.nrpn_control != 16383) {
                        this.nrpnChange(this.nrpn_control, val);
                    }
                    if (this.rpn_control == 16383) break;
                    this.rpnChange(this.rpn_control, val);
                    break;
                }
                case 64: {
                    int i;
                    boolean on;
                    boolean bl = on = value >= 64;
                    if (this.sustain == on) break;
                    this.sustain = on;
                    if (!on) {
                        for (i = 0; i < this.voices.length; ++i) {
                            if (!this.voices[i].active || !this.voices[i].sustain || this.voices[i].channel != this.channel) continue;
                            this.voices[i].sustain = false;
                            if (this.voices[i].on) continue;
                            this.voices[i].on = true;
                            this.voices[i].noteOff(0);
                        }
                    } else {
                        for (i = 0; i < this.voices.length; ++i) {
                            if (!this.voices[i].active || this.voices[i].channel != this.channel) continue;
                            this.voices[i].redamp();
                        }
                    }
                    break;
                }
                case 65: {
                    this.portamento = value >= 64;
                    this.portamento_lastnote[0] = -1;
                    this.portamento_lastnote_ix = 0;
                    break;
                }
                case 66: {
                    boolean on;
                    int i;
                    boolean bl = on = value >= 64;
                    if (on) {
                        for (i = 0; i < this.voices.length; ++i) {
                            if (!this.voices[i].active || !this.voices[i].on || this.voices[i].channel != this.channel) continue;
                            this.voices[i].sostenuto = true;
                        }
                    }
                    if (on) break;
                    for (i = 0; i < this.voices.length; ++i) {
                        if (!this.voices[i].active || !this.voices[i].sostenuto || this.voices[i].channel != this.channel) continue;
                        this.voices[i].sostenuto = false;
                        if (this.voices[i].on) continue;
                        this.voices[i].on = true;
                        this.voices[i].noteOff(0);
                    }
                    break;
                }
                case 98: {
                    this.nrpn_control = (this.nrpn_control & 0x3F80) + value;
                    this.rpn_control = 16383;
                    break;
                }
                case 99: {
                    this.nrpn_control = (this.nrpn_control & 0x7F) + (value << 7);
                    this.rpn_control = 16383;
                    break;
                }
                case 100: {
                    this.rpn_control = (this.rpn_control & 0x3F80) + value;
                    this.nrpn_control = 16383;
                    break;
                }
                case 101: {
                    this.rpn_control = (this.rpn_control & 0x7F) + (value << 7);
                    this.nrpn_control = 16383;
                    break;
                }
                case 120: {
                    this.allSoundOff();
                    break;
                }
                case 121: {
                    this.resetAllControllers(value == 127);
                    break;
                }
                case 122: {
                    this.localControl(value >= 64);
                    break;
                }
                case 123: {
                    this.allNotesOff();
                    break;
                }
                case 124: {
                    this.setOmni(false);
                    break;
                }
                case 125: {
                    this.setOmni(true);
                    break;
                }
                case 126: {
                    if (value != 1) break;
                    this.setMono(true);
                    break;
                }
                case 127: {
                    this.setMono(false);
                    break;
                }
            }
            this.co_midi_cc_cc[controller][0] = (double)value * 0.0078125;
            if (controller == 0) {
                this.bank = value << 7;
                return;
            }
            if (controller == 32) {
                this.bank = (this.bank & 0x3F80) + value;
                return;
            }
            this.controller[controller] = value;
            if (controller < 32) {
                this.controller[controller + 32] = 0;
            }
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active) continue;
                this.voices[i].controlChange(controller, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getController(int controller) {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.controller[controller] & 0x7F;
        }
    }

    public void tuningChange(int program) {
        this.tuningChange(0, program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tuningChange(int bank, int program) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.tuning = this.synthesizer.getTuning(new Patch(bank, program));
        }
    }

    public void programChange(int program) {
        this.programChange(this.bank, program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void programChange(int bank, int program) {
        bank = SoftChannel.restrict7Bit(bank);
        program = SoftChannel.restrict7Bit(program);
        Object object = this.control_mutex;
        synchronized (object) {
            this.mainmixer.activity();
            this.bank = bank;
            this.program = program;
            this.current_instrument = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProgram() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.program;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPitchBend(int bend) {
        bend = SoftChannel.restrict14Bit(bend);
        if (this.current_mixer != null) {
            this.current_mixer.setPitchBend(bend);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.mainmixer.activity();
            this.co_midi_pitch[0] = (double)bend * 6.103515625E-5;
            this.pitchbend = bend;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active) continue;
                this.voices[i].setPitchBend(bend);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPitchBend() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.pitchbend;
        }
    }

    public void nrpnChange(int controller, int value) {
        if (this.synthesizer.getGeneralMidiMode() == 0) {
            if (controller == 136) {
                this.controlChange(76, value >> 7);
            }
            if (controller == 137) {
                this.controlChange(77, value >> 7);
            }
            if (controller == 138) {
                this.controlChange(78, value >> 7);
            }
            if (controller == 160) {
                this.controlChange(74, value >> 7);
            }
            if (controller == 161) {
                this.controlChange(71, value >> 7);
            }
            if (controller == 227) {
                this.controlChange(73, value >> 7);
            }
            if (controller == 228) {
                this.controlChange(75, value >> 7);
            }
            if (controller == 230) {
                this.controlChange(72, value >> 7);
            }
            if (controller >> 7 == 24) {
                this.controlChangePerNote(controller % 128, 120, value >> 7);
            }
            if (controller >> 7 == 26) {
                this.controlChangePerNote(controller % 128, 7, value >> 7);
            }
            if (controller >> 7 == 28) {
                this.controlChangePerNote(controller % 128, 10, value >> 7);
            }
            if (controller >> 7 == 29) {
                this.controlChangePerNote(controller % 128, 91, value >> 7);
            }
            if (controller >> 7 == 30) {
                this.controlChangePerNote(controller % 128, 93, value >> 7);
            }
        }
        int[] val_i = this.co_midi_nrpn_nrpn_i.get(controller);
        double[] val_d = this.co_midi_nrpn_nrpn.get(controller);
        if (val_i == null) {
            val_i = new int[1];
            this.co_midi_nrpn_nrpn_i.put(controller, val_i);
        }
        if (val_d == null) {
            val_d = new double[1];
            this.co_midi_nrpn_nrpn.put(controller, val_d);
        }
        val_i[0] = value;
        val_d[0] = (double)val_i[0] * 6.103515625E-5;
        for (int i = 0; i < this.voices.length; ++i) {
            if (!this.voices[i].active) continue;
            this.voices[i].nrpnChange(controller, val_i[0]);
        }
    }

    public void rpnChange(int controller, int value) {
        if (controller == 3) {
            this.tuning_program = value >> 7 & 0x7F;
            this.tuningChange(this.tuning_bank, this.tuning_program);
        }
        if (controller == 4) {
            this.tuning_bank = value >> 7 & 0x7F;
        }
        int[] val_i = this.co_midi_rpn_rpn_i.get(controller);
        double[] val_d = this.co_midi_rpn_rpn.get(controller);
        if (val_i == null) {
            val_i = new int[1];
            this.co_midi_rpn_rpn_i.put(controller, val_i);
        }
        if (val_d == null) {
            val_d = new double[1];
            this.co_midi_rpn_rpn.put(controller, val_d);
        }
        val_i[0] = value;
        val_d[0] = (double)val_i[0] * 6.103515625E-5;
        for (int i = 0; i < this.voices.length; ++i) {
            if (!this.voices[i].active) continue;
            this.voices[i].rpnChange(controller, val_i[0]);
        }
    }

    public void resetAllControllers() {
        this.resetAllControllers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllControllers(boolean allControls) {
        Object object = this.control_mutex;
        synchronized (object) {
            int i;
            this.mainmixer.activity();
            for (i = 0; i < 128; ++i) {
                this.setPolyPressure(i, 0);
            }
            this.setChannelPressure(0);
            this.setPitchBend(8192);
            for (i = 0; i < 128; ++i) {
                if (dontResetControls[i]) continue;
                this.controlChange(i, 0);
            }
            this.controlChange(71, 64);
            this.controlChange(72, 64);
            this.controlChange(73, 64);
            this.controlChange(74, 64);
            this.controlChange(75, 64);
            this.controlChange(76, 64);
            this.controlChange(77, 64);
            this.controlChange(78, 64);
            this.controlChange(8, 64);
            this.controlChange(11, 127);
            this.controlChange(98, 127);
            this.controlChange(99, 127);
            this.controlChange(100, 127);
            this.controlChange(101, 127);
            if (allControls) {
                this.keybasedcontroller_active = null;
                this.keybasedcontroller_value = null;
                this.controlChange(7, 100);
                this.controlChange(10, 64);
                this.controlChange(91, 40);
                for (int controller : this.co_midi_rpn_rpn.keySet()) {
                    if (controller == 3 || controller == 4) continue;
                    this.rpnChange(controller, 0);
                }
                for (int controller : this.co_midi_nrpn_nrpn.keySet()) {
                    this.nrpnChange(controller, 0);
                }
                this.rpnChange(0, 256);
                this.rpnChange(1, 8192);
                this.rpnChange(2, 8192);
                this.rpnChange(5, 64);
                this.tuning_bank = 0;
                this.tuning_program = 0;
                this.tuning = new SoftTuning();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allNotesOff() {
        if (this.current_mixer != null) {
            this.current_mixer.allNotesOff();
        }
        Object object = this.control_mutex;
        synchronized (object) {
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].on || this.voices[i].channel != this.channel || this.voices[i].releaseTriggered) continue;
                this.voices[i].noteOff(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allSoundOff() {
        if (this.current_mixer != null) {
            this.current_mixer.allSoundOff();
        }
        Object object = this.control_mutex;
        synchronized (object) {
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].on || this.voices[i].channel != this.channel) continue;
                this.voices[i].soundOff();
            }
        }
    }

    public boolean localControl(boolean on) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMono(boolean on) {
        if (this.current_mixer != null) {
            this.current_mixer.setMono(on);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.allNotesOff();
            this.mono = on;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMono() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.mono;
        }
    }

    public void setOmni(boolean on) {
        if (this.current_mixer != null) {
            this.current_mixer.setOmni(on);
        }
        this.allNotesOff();
    }

    public boolean getOmni() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMute(boolean mute) {
        if (this.current_mixer != null) {
            this.current_mixer.setMute(mute);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.mute = mute;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active || this.voices[i].channel != this.channel) continue;
                this.voices[i].setMute(mute);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMute() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.mute;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSolo(boolean soloState) {
        if (this.current_mixer != null) {
            this.current_mixer.setSolo(soloState);
        }
        Object object = this.control_mutex;
        synchronized (object) {
            this.solo = soloState;
            boolean soloinuse = false;
            for (SoftChannel c : this.synthesizer.channels) {
                if (!c.solo) continue;
                soloinuse = true;
                break;
            }
            if (!soloinuse) {
                for (SoftChannel c : this.synthesizer.channels) {
                    c.setSoloMute(false);
                }
                return;
            }
            for (SoftChannel c : this.synthesizer.channels) {
                c.setSoloMute(!c.solo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSoloMute(boolean mute) {
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.solomute == mute) {
                return;
            }
            this.solomute = mute;
            for (int i = 0; i < this.voices.length; ++i) {
                if (!this.voices[i].active || this.voices[i].channel != this.channel) continue;
                this.voices[i].setSoloMute(this.solomute);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSolo() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.solo;
        }
    }

    static {
        for (int i = 0; i < dontResetControls.length; ++i) {
            SoftChannel.dontResetControls[i] = false;
        }
        SoftChannel.dontResetControls[0] = true;
        SoftChannel.dontResetControls[32] = true;
        SoftChannel.dontResetControls[7] = true;
        SoftChannel.dontResetControls[8] = true;
        SoftChannel.dontResetControls[10] = true;
        SoftChannel.dontResetControls[11] = true;
        SoftChannel.dontResetControls[91] = true;
        SoftChannel.dontResetControls[92] = true;
        SoftChannel.dontResetControls[93] = true;
        SoftChannel.dontResetControls[94] = true;
        SoftChannel.dontResetControls[95] = true;
        SoftChannel.dontResetControls[70] = true;
        SoftChannel.dontResetControls[71] = true;
        SoftChannel.dontResetControls[72] = true;
        SoftChannel.dontResetControls[73] = true;
        SoftChannel.dontResetControls[74] = true;
        SoftChannel.dontResetControls[75] = true;
        SoftChannel.dontResetControls[76] = true;
        SoftChannel.dontResetControls[77] = true;
        SoftChannel.dontResetControls[78] = true;
        SoftChannel.dontResetControls[79] = true;
        SoftChannel.dontResetControls[120] = true;
        SoftChannel.dontResetControls[121] = true;
        SoftChannel.dontResetControls[122] = true;
        SoftChannel.dontResetControls[123] = true;
        SoftChannel.dontResetControls[124] = true;
        SoftChannel.dontResetControls[125] = true;
        SoftChannel.dontResetControls[126] = true;
        SoftChannel.dontResetControls[127] = true;
        SoftChannel.dontResetControls[6] = true;
        SoftChannel.dontResetControls[38] = true;
        SoftChannel.dontResetControls[96] = true;
        SoftChannel.dontResetControls[97] = true;
        SoftChannel.dontResetControls[98] = true;
        SoftChannel.dontResetControls[99] = true;
        SoftChannel.dontResetControls[100] = true;
        SoftChannel.dontResetControls[101] = true;
    }

    private class MidiControlObject
    implements SoftControl {
        double[] pitch;
        double[] channel_pressure;
        double[] poly_pressure;

        private MidiControlObject() {
            this.pitch = SoftChannel.this.co_midi_pitch;
            this.channel_pressure = SoftChannel.this.co_midi_channel_pressure;
            this.poly_pressure = new double[1];
        }

        public double[] get(int instance, String name) {
            if (name == null) {
                return null;
            }
            if (name.equals("pitch")) {
                return this.pitch;
            }
            if (name.equals("channel_pressure")) {
                return this.channel_pressure;
            }
            if (name.equals("poly_pressure")) {
                return this.poly_pressure;
            }
            return null;
        }
    }
}

