/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.FastSysexMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

class MidiOutDevice
extends AbstractMidiDevice {
    MidiOutDevice(AbstractMidiDeviceProvider.Info info) {
        super(info);
    }

    protected synchronized void implOpen() throws MidiUnavailableException {
        int index = ((AbstractMidiDeviceProvider.Info)this.getDeviceInfo()).getIndex();
        this.id = this.nOpen(index);
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
    }

    protected synchronized void implClose() {
        long oldId = this.id;
        this.id = 0L;
        super.implClose();
        this.nClose(oldId);
    }

    public long getMicrosecondPosition() {
        long timestamp = -1L;
        if (this.isOpen()) {
            timestamp = this.nGetTimeStamp(this.id);
        }
        return timestamp;
    }

    protected boolean hasReceivers() {
        return true;
    }

    protected Receiver createReceiver() {
        return new MidiOutReceiver();
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(long var1);

    private native void nSendShortMessage(long var1, int var3, long var4);

    private native void nSendLongMessage(long var1, byte[] var3, int var4, long var5);

    private native long nGetTimeStamp(long var1);

    class MidiOutReceiver
    extends AbstractMidiDevice.AbstractReceiver {
        MidiOutReceiver() {
        }

        protected void implSend(MidiMessage message, long timeStamp) {
            int length = message.getLength();
            int status = message.getStatus();
            if (length <= 3 && status != 240 && status != 247) {
                int packedMsg;
                if (message instanceof ShortMessage) {
                    if (message instanceof FastShortMessage) {
                        packedMsg = ((FastShortMessage)message).getPackedMsg();
                    } else {
                        ShortMessage msg = (ShortMessage)message;
                        packedMsg = status & 0xFF | (msg.getData1() & 0xFF) << 8 | (msg.getData2() & 0xFF) << 16;
                    }
                } else {
                    packedMsg = 0;
                    byte[] data = message.getMessage();
                    if (length > 0) {
                        packedMsg = data[0] & 0xFF;
                        if (length > 1) {
                            if (status == 255) {
                                return;
                            }
                            packedMsg |= (data[1] & 0xFF) << 8;
                            if (length > 2) {
                                packedMsg |= (data[2] & 0xFF) << 16;
                            }
                        }
                    }
                }
                MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, packedMsg, timeStamp);
            } else if (message instanceof FastSysexMessage) {
                MidiOutDevice.this.nSendLongMessage(MidiOutDevice.this.id, ((FastSysexMessage)message).getReadOnlyMessage(), length, timeStamp);
            } else {
                MidiOutDevice.this.nSendLongMessage(MidiOutDevice.this.id, message.getMessage(), length, timeStamp);
            }
        }

        synchronized void sendPackedMidiMessage(int packedMsg, long timeStamp) {
            if (this.isOpen() && MidiOutDevice.this.id != 0L) {
                MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, packedMsg, timeStamp);
            }
        }
    }
}

