/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

class GTKColorChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    private static final float PI_3 = 1.0471976f;
    private ColorTriangle triangle;
    private JLabel lastLabel;
    private JLabel label;
    private JSpinner hueSpinner;
    private JSpinner saturationSpinner;
    private JSpinner valueSpinner;
    private JSpinner redSpinner;
    private JSpinner greenSpinner;
    private JSpinner blueSpinner;
    private JTextField colorNameTF;
    private boolean settingColor;
    private float hue;
    private float saturation;
    private float brightness;
    private static final int FLAGS_CHANGED_ANGLE = 1;
    private static final int FLAGS_DRAGGING = 2;
    private static final int FLAGS_DRAGGING_TRIANGLE = 4;
    private static final int FLAGS_SETTING_COLOR = 8;
    private static final int FLAGS_FOCUSED_WHEEL = 16;
    private static final int FLAGS_FOCUSED_TRIANGLE = 32;

    GTKColorChooserPanel() {
    }

    static void compositeRequestFocus(Component component, boolean direction) {
        if (component instanceof Container) {
            FocusTraversalPolicy policy;
            Component comp;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (comp = (policy = container.getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                comp.requestFocus();
                return;
            }
            Container rootAncestor = container.getFocusCycleRootAncestor();
            if (rootAncestor != null) {
                FocusTraversalPolicy policy2 = rootAncestor.getFocusTraversalPolicy();
                Component comp2 = direction ? policy2.getComponentAfter(rootAncestor, container) : policy2.getComponentBefore(rootAncestor, container);
                if (comp2 != null) {
                    comp2.requestFocus();
                    return;
                }
            }
        }
        component.requestFocus();
    }

    public String getDisplayName() {
        return (String)UIManager.get("GTKColorChooserPanel.nameText");
    }

    public int getMnemonic() {
        String m = (String)UIManager.get("GTKColorChooserPanel.mnemonic");
        if (m != null) {
            try {
                int value = Integer.parseInt(m);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getDisplayedMnemonicIndex() {
        String m = (String)UIManager.get("GTKColorChooserPanel.displayedMnemonicIndex");
        if (m != null) {
            try {
                int value = Integer.parseInt(m);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.removeAll();
    }

    protected void buildChooser() {
        this.triangle = new ColorTriangle();
        this.triangle.setName("GTKColorChooserPanel.triangle");
        this.label = new OpaqueLabel();
        this.label.setName("GTKColorChooserPanel.colorWell");
        this.label.setOpaque(true);
        this.label.setMinimumSize(new Dimension(67, 32));
        this.label.setPreferredSize(new Dimension(67, 32));
        this.label.setMaximumSize(new Dimension(67, 32));
        this.lastLabel = new OpaqueLabel();
        this.lastLabel.setName("GTKColorChooserPanel.lastColorWell");
        this.lastLabel.setOpaque(true);
        this.lastLabel.setMinimumSize(new Dimension(67, 32));
        this.lastLabel.setPreferredSize(new Dimension(67, 32));
        this.lastLabel.setMaximumSize(new Dimension(67, 32));
        this.hueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 360, 1));
        this.configureSpinner(this.hueSpinner, "GTKColorChooserPanel.hueSpinner");
        this.saturationSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.saturationSpinner, "GTKColorChooserPanel.saturationSpinner");
        this.valueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.valueSpinner, "GTKColorChooserPanel.valueSpinner");
        this.redSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.redSpinner, "GTKColorChooserPanel.redSpinner");
        this.greenSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.greenSpinner, "GTKColorChooserPanel.greenSpinner");
        this.blueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.blueSpinner, "GTKColorChooserPanel.blueSpinner");
        this.colorNameTF = new JTextField(8);
        this.setLayout(new GridBagLayout());
        this.add(this, "GTKColorChooserPanel.hue", this.hueSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.red", this.redSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.saturation", this.saturationSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.green", this.greenSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.value", this.valueSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.blue", this.blueSpinner, -1, -1);
        this.add((Component)new JSeparator(0), new GridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 21, 2, new Insets(14, 0, 0, 0), 0, 0));
        this.add(this, "GTKColorChooserPanel.colorName", this.colorNameTF, 0, 4);
        this.add((Component)this.triangle, new GridBagConstraints(0, 0, 1, 5, 0.0, 0.0, 21, 0, new Insets(14, 20, 2, 9), 0, 0));
        Box hBox = Box.createHorizontalBox();
        hBox.add(this.lastLabel);
        hBox.add(this.label);
        this.add((Component)hBox, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JSeparator(0), new GridBagConstraints(0, 6, 5, 1, 1.0, 0.0, 21, 2, new Insets(12, 0, 0, 0), 0, 0));
    }

    private void configureSpinner(JSpinner spinner, String name) {
        spinner.addChangeListener(this);
        spinner.setName(name);
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            JFormattedTextField ftf = ((JSpinner.DefaultEditor)editor).getTextField();
            ftf.setFocusLostBehavior(1);
        }
    }

    private void add(Container parent, String key, JComponent widget, int x, int y) {
        JLabel label = new JLabel(UIManager.getString((Object)(key + "Text"), this.getLocale()));
        String mnemonic = (String)UIManager.get(key + "Mnemonic", this.getLocale());
        if (mnemonic != null) {
            try {
                label.setDisplayedMnemonic(Integer.parseInt(mnemonic));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            String mnemonicIndex = (String)UIManager.get(key + "MnemonicIndex", this.getLocale());
            if (mnemonicIndex != null) {
                try {
                    label.setDisplayedMnemonicIndex(Integer.parseInt(mnemonicIndex));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        label.setLabelFor(widget);
        if (x < 0) {
            x = parent.getComponentCount() % 4;
        }
        if (y < 0) {
            y = parent.getComponentCount() / 4;
        }
        GridBagConstraints con = new GridBagConstraints(x + 1, y, 1, 1, 0.0, 0.0, 24, 0, new Insets(4, 0, 0, 4), 0, 0);
        if (y == 0) {
            con.insets.top = 14;
        }
        parent.add((Component)label, con);
        ++con.gridx;
        parent.add((Component)widget, con);
    }

    public void updateChooser() {
        if (!this.settingColor) {
            this.lastLabel.setBackground(this.getColorFromModel());
            this.setColor(this.getColorFromModel(), true, true, false);
        }
    }

    private void setRed(int red) {
        this.setRGB(red << 16 | this.getColor().getGreen() << 8 | this.getColor().getBlue());
    }

    private void setGreen(int green) {
        this.setRGB(this.getColor().getRed() << 16 | green << 8 | this.getColor().getBlue());
    }

    private void setBlue(int blue) {
        this.setRGB(this.getColor().getRed() << 16 | this.getColor().getGreen() << 8 | blue);
    }

    private void setHue(float hue, boolean update) {
        this.setHSB(hue, this.saturation, this.brightness);
        if (update) {
            this.settingColor = true;
            this.hueSpinner.setValue(new Integer((int)(hue * 360.0f)));
            this.settingColor = false;
        }
    }

    private float getHue() {
        return this.hue;
    }

    private void setSaturation(float saturation) {
        this.setHSB(this.hue, saturation, this.brightness);
    }

    private float getSaturation() {
        return this.saturation;
    }

    private void setBrightness(float brightness) {
        this.setHSB(this.hue, this.saturation, brightness);
    }

    private float getBrightness() {
        return this.brightness;
    }

    private void setSaturationAndBrightness(float s, float b, boolean update) {
        this.setHSB(this.hue, s, b);
        if (update) {
            this.settingColor = true;
            this.saturationSpinner.setValue(new Integer((int)(s * 255.0f)));
            this.valueSpinner.setValue(new Integer((int)(b * 255.0f)));
            this.settingColor = false;
        }
    }

    private void setRGB(int rgb) {
        Color color = new Color(rgb);
        this.setColor(color, false, true, true);
        this.settingColor = true;
        this.hueSpinner.setValue(new Integer((int)(this.hue * 360.0f)));
        this.saturationSpinner.setValue(new Integer((int)(this.saturation * 255.0f)));
        this.valueSpinner.setValue(new Integer((int)(this.brightness * 255.0f)));
        this.settingColor = false;
    }

    private void setHSB(float h, float s, float b) {
        Color color = Color.getHSBColor(h, s, b);
        this.hue = h;
        this.saturation = s;
        this.brightness = b;
        this.setColor(color, false, false, true);
        this.settingColor = true;
        this.redSpinner.setValue(new Integer(color.getRed()));
        this.greenSpinner.setValue(new Integer(color.getGreen()));
        this.blueSpinner.setValue(new Integer(color.getBlue()));
        this.settingColor = false;
    }

    private void setColor(Color color, boolean updateSpinners, boolean updateHSB, boolean updateModel) {
        if (color == null) {
            color = Color.BLACK;
        }
        this.settingColor = true;
        if (updateHSB) {
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.hue = hsb[0];
            this.saturation = hsb[1];
            this.brightness = hsb[2];
        }
        if (updateModel) {
            this.getColorSelectionModel().setSelectedColor(color);
        }
        this.triangle.setColor(this.hue, this.saturation, this.brightness);
        this.label.setBackground(color);
        String hexString = Integer.toHexString(color.getRGB() & 0xFFFFFF | 0x1000000);
        this.colorNameTF.setText("#" + hexString.substring(1));
        if (updateSpinners) {
            this.redSpinner.setValue(new Integer(color.getRed()));
            this.greenSpinner.setValue(new Integer(color.getGreen()));
            this.blueSpinner.setValue(new Integer(color.getBlue()));
            this.hueSpinner.setValue(new Integer((int)(this.hue * 360.0f)));
            this.saturationSpinner.setValue(new Integer((int)(this.saturation * 255.0f)));
            this.valueSpinner.setValue(new Integer((int)(this.brightness * 255.0f)));
        }
        this.settingColor = false;
    }

    public Color getColor() {
        return this.label.getBackground();
    }

    public void stateChanged(ChangeEvent e) {
        if (this.settingColor) {
            return;
        }
        Color color = this.getColor();
        if (e.getSource() == this.hueSpinner) {
            this.setHue(((Number)this.hueSpinner.getValue()).floatValue() / 360.0f, false);
        } else if (e.getSource() == this.saturationSpinner) {
            this.setSaturation(((Number)this.saturationSpinner.getValue()).floatValue() / 255.0f);
        } else if (e.getSource() == this.valueSpinner) {
            this.setBrightness(((Number)this.valueSpinner.getValue()).floatValue() / 255.0f);
        } else if (e.getSource() == this.redSpinner) {
            this.setRed(((Number)this.redSpinner.getValue()).intValue());
        } else if (e.getSource() == this.greenSpinner) {
            this.setGreen(((Number)this.greenSpinner.getValue()).intValue());
        } else if (e.getSource() == this.blueSpinner) {
            this.setBlue(((Number)this.blueSpinner.getValue()).intValue());
        }
    }

    private class OpaqueLabel
    extends JLabel {
        private OpaqueLabel() {
        }

        public boolean isOpaque() {
            return true;
        }
    }

    private static class ColorAction
    extends AbstractAction {
        private int type;

        ColorAction(String name, int type) {
            super(name);
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            ColorTriangle triangle = (ColorTriangle)e.getSource();
            if (triangle.isWheelFocused()) {
                float hue = triangle.getGTKColorChooserPanel().getHue();
                switch (this.type) {
                    case 0: 
                    case 2: {
                        triangle.incrementHue(true);
                        break;
                    }
                    case 1: 
                    case 3: {
                        triangle.incrementHue(false);
                        break;
                    }
                    case 4: {
                        triangle.focusTriangle();
                        break;
                    }
                    case 5: {
                        GTKColorChooserPanel.compositeRequestFocus(triangle, false);
                    }
                }
            } else {
                int xDelta = 0;
                int yDelta = 0;
                switch (this.type) {
                    case 0: {
                        --yDelta;
                        break;
                    }
                    case 1: {
                        ++yDelta;
                        break;
                    }
                    case 2: {
                        --xDelta;
                        break;
                    }
                    case 3: {
                        ++xDelta;
                        break;
                    }
                    case 4: {
                        GTKColorChooserPanel.compositeRequestFocus(triangle, true);
                        return;
                    }
                    case 5: {
                        triangle.focusWheel();
                        return;
                    }
                }
                triangle.adjustSB(triangle.getColorX() + xDelta, triangle.getColorY() + yDelta, true);
            }
        }
    }

    private class ColorTriangle
    extends JPanel {
        private Image wheelImage;
        private Image triangleImage;
        private double angle;
        private int flags;
        private int circleX;
        private int circleY;

        public ColorTriangle() {
            this.enableEvents(4L);
            this.enableEvents(16L);
            this.enableEvents(32L);
            this.setMinimumSize(new Dimension(this.getWheelRadius() * 2 + 2, this.getWheelRadius() * 2 + 2));
            this.setPreferredSize(new Dimension(this.getWheelRadius() * 2 + 2, this.getWheelRadius() * 2 + 2));
            this.setFocusTraversalKeysEnabled(false);
            this.getInputMap().put(KeyStroke.getKeyStroke("UP"), "up");
            this.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "down");
            this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "left");
            this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "right");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_UP"), "up");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_DOWN"), "down");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_LEFT"), "left");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_RIGHT"), "right");
            this.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "focusNext");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift TAB"), "focusLast");
            ActionMap map = (ActionMap)UIManager.get("GTKColorChooserPanel.actionMap");
            if (map == null) {
                map = new ActionMapUIResource();
                map.put("left", new ColorAction("left", 2));
                map.put("right", new ColorAction("right", 3));
                map.put("up", new ColorAction("up", 0));
                map.put("down", new ColorAction("down", 1));
                map.put("focusNext", new ColorAction("focusNext", 4));
                map.put("focusLast", new ColorAction("focusLast", 5));
                UIManager.getLookAndFeelDefaults().put("GTKColorChooserPanel.actionMap", map);
            }
            SwingUtilities.replaceUIActionMap(this, map);
        }

        GTKColorChooserPanel getGTKColorChooserPanel() {
            return GTKColorChooserPanel.this;
        }

        void focusWheel() {
            this.setFocusType(1);
        }

        void focusTriangle() {
            this.setFocusType(2);
        }

        boolean isWheelFocused() {
            return this.isSet(16);
        }

        public void setColor(float h, float s, float b) {
            if (this.isSet(8)) {
                return;
            }
            this.setAngleFromHue(h);
            this.setSaturationAndBrightness(s, b);
        }

        public Color getColor() {
            return GTKColorChooserPanel.this.getColor();
        }

        int getColorX() {
            return this.circleX + this.getIndicatorSize() / 2 - this.getWheelXOrigin();
        }

        int getColorY() {
            return this.circleY + this.getIndicatorSize() / 2 - this.getWheelYOrigin();
        }

        protected void processEvent(AWTEvent e) {
            if (e.getID() == 501 || (this.isSet(2) || this.isSet(4)) && e.getID() == 506) {
                int size = this.getWheelRadius();
                int x = ((MouseEvent)e).getX() - size;
                int y = ((MouseEvent)e).getY() - size;
                if (!this.hasFocus()) {
                    this.requestFocus();
                }
                if (!this.isSet(4) && this.adjustHue(x, y, e.getID() == 501)) {
                    this.setFlag(2, true);
                    this.setFocusType(1);
                } else if (this.adjustSB(x, y, e.getID() == 501)) {
                    this.setFlag(4, true);
                    this.setFocusType(2);
                } else {
                    this.setFocusType(2);
                }
            } else if (e.getID() == 502) {
                this.setFlag(4, false);
                this.setFlag(2, false);
            } else if (e.getID() == 1005) {
                this.setFocusType(0);
            } else if (e.getID() == 1004) {
                if (!this.isSet(32) && !this.isSet(16)) {
                    this.setFlag(16, true);
                    this.setFocusType(1);
                }
                this.repaint();
            }
            super.processEvent(e);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int size = this.getWheelRadius();
            int width = this.getWheelWidth();
            Image image = this.getImage(size);
            g.drawImage(image, this.getWheelXOrigin() - size, this.getWheelYOrigin() - size, null);
            if (this.hasFocus() && this.isSet(16)) {
                g.setColor(Color.BLACK);
                g.drawOval(this.getWheelXOrigin() - size, this.getWheelYOrigin() - size, 2 * size, 2 * size);
                g.drawOval(this.getWheelXOrigin() - size + width, this.getWheelYOrigin() - size + width, 2 * (size - width), 2 * (size - width));
            }
            if (Math.toDegrees(Math.PI * 2 - this.angle) <= 20.0 || Math.toDegrees(Math.PI * 2 - this.angle) >= 201.0) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.BLACK);
            }
            int lineX0 = (int)(Math.cos(this.angle) * (double)size);
            int lineY0 = (int)(Math.sin(this.angle) * (double)size);
            int lineX1 = (int)(Math.cos(this.angle) * (double)(size - width));
            int lineY1 = (int)(Math.sin(this.angle) * (double)(size - width));
            g.drawLine(lineX0 + size, lineY0 + size, lineX1 + size, lineY1 + size);
            if (this.hasFocus() && this.isSet(32)) {
                Graphics g2 = g.create();
                int innerR = this.getTriangleCircumscribedRadius();
                int a = (int)((double)(3 * innerR) / Math.sqrt(3.0));
                g2.translate(this.getWheelXOrigin(), this.getWheelYOrigin());
                ((Graphics2D)g2).rotate(this.angle + 1.5707963267948966);
                g2.setColor(Color.BLACK);
                g2.drawLine(0, -innerR, a / 2, innerR / 2);
                g2.drawLine(a / 2, innerR / 2, -a / 2, innerR / 2);
                g2.drawLine(-a / 2, innerR / 2, 0, -innerR);
                g2.dispose();
            }
            g.setColor(Color.BLACK);
            g.drawOval(this.circleX, this.circleY, this.getIndicatorSize() - 1, this.getIndicatorSize() - 1);
            g.setColor(Color.WHITE);
            g.drawOval(this.circleX + 1, this.circleY + 1, this.getIndicatorSize() - 3, this.getIndicatorSize() - 3);
        }

        private Image getImage(int size) {
            if (!this.isSet(1) && this.wheelImage != null && this.wheelImage.getWidth(null) == size * 2) {
                return this.wheelImage;
            }
            if (this.wheelImage == null || this.wheelImage.getWidth(null) != size) {
                this.wheelImage = this.getWheelImage(size);
            }
            int innerR = this.getTriangleCircumscribedRadius();
            int triangleSize = (int)((double)innerR * 3.0 / 2.0);
            int a = (int)((double)(2 * triangleSize) / Math.sqrt(3.0));
            if (this.triangleImage == null || this.triangleImage.getWidth(null) != a) {
                this.triangleImage = new BufferedImage(a, a, 2);
            }
            Graphics g = this.triangleImage.getGraphics();
            g.setColor(new Color(0, 0, 0, 0));
            g.fillRect(0, 0, a, a);
            g.translate(a / 2, 0);
            this.paintTriangle(g, triangleSize, this.getColor());
            g.translate(-a / 2, 0);
            g.dispose();
            g = this.wheelImage.getGraphics();
            g.setColor(new Color(0, 0, 0, 0));
            g.fillOval(this.getWheelWidth(), this.getWheelWidth(), 2 * (size - this.getWheelWidth()), 2 * (size - this.getWheelWidth()));
            double rotate = Math.toRadians(-30.0) + this.angle;
            g.translate(size, size);
            ((Graphics2D)g).rotate(rotate);
            g.drawImage(this.triangleImage, -a / 2, this.getWheelWidth() - size, null);
            ((Graphics2D)g).rotate(-rotate);
            g.translate(a / 2, size - this.getWheelWidth());
            this.setFlag(1, false);
            return this.wheelImage;
        }

        private void paintTriangle(Graphics g, int size, Color color) {
            float[] colors = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            float hue = colors[0];
            double dSize = size;
            for (int y = 0; y < size; ++y) {
                int maxX = (int)((double)y * Math.tan(Math.toRadians(30.0)));
                float factor = maxX * 2;
                if (maxX > 0) {
                    float value = (float)((double)y / dSize);
                    for (int x = -maxX; x <= maxX; ++x) {
                        float saturation = (float)x / factor + 0.5f;
                        g.setColor(Color.getHSBColor(hue, saturation, value));
                        g.fillRect(x, y, 1, 1);
                    }
                    continue;
                }
                g.setColor(color);
                g.fillRect(0, y, 1, 1);
            }
        }

        private Image getWheelImage(int size) {
            int minSize = size - this.getWheelWidth();
            int doubleSize = size * 2;
            BufferedImage image = new BufferedImage(doubleSize, doubleSize, 2);
            for (int y = -size; y < size; ++y) {
                int ySquared = y * y;
                for (int x = -size; x < size; ++x) {
                    double rad = Math.sqrt(ySquared + x * x);
                    if (!(rad < (double)size) || !(rad > (double)minSize)) continue;
                    int rgb = this.colorWheelLocationToRGB(x, y, rad) | 0xFF000000;
                    image.setRGB(x + size, y + size, rgb);
                }
            }
            this.wheelImage = image;
            return this.wheelImage;
        }

        boolean adjustSB(int x, int y, boolean checkLoc) {
            int innerR = this.getWheelRadius() - this.getWheelWidth();
            boolean resetXY = false;
            y = -y;
            if (checkLoc && (x < -innerR || x > innerR || y < -innerR || y > innerR)) {
                return false;
            }
            int triangleSize = innerR * 3 / 2;
            double x1 = Math.cos(this.angle) * (double)x - Math.sin(this.angle) * (double)y;
            double y1 = Math.sin(this.angle) * (double)x + Math.cos(this.angle) * (double)y;
            if (x1 < (double)(-(innerR / 2))) {
                if (checkLoc) {
                    return false;
                }
                x1 = -innerR / 2;
                resetXY = true;
            } else if ((int)x1 > innerR) {
                if (checkLoc) {
                    return false;
                }
                x1 = innerR;
                resetXY = true;
            }
            int maxY = (int)(((double)triangleSize - x1 - (double)innerR / 2.0) * Math.tan(Math.toRadians(30.0)));
            if (y1 <= (double)(-maxY)) {
                if (checkLoc) {
                    return false;
                }
                y1 = -maxY;
                resetXY = true;
            } else if (y1 > (double)maxY) {
                if (checkLoc) {
                    return false;
                }
                y1 = maxY;
                resetXY = true;
            }
            double x2 = Math.cos(Math.toRadians(-30.0)) * x1 - Math.sin(Math.toRadians(-30.0)) * y1;
            double y2 = Math.sin(Math.toRadians(-30.0)) * x1 + Math.cos(Math.toRadians(-30.0)) * y1;
            float value = Math.min(1.0f, (float)(((double)innerR - y2) / (double)triangleSize));
            float maxX = (float)(Math.tan(Math.toRadians(30.0)) * ((double)innerR - y2));
            float saturation = Math.min(1.0f, (float)(x2 / (double)maxX / 2.0 + 0.5));
            this.setFlag(8, true);
            if (resetXY) {
                this.setSaturationAndBrightness(saturation, value);
            } else {
                this.setSaturationAndBrightness(saturation, value, x + this.getWheelXOrigin(), this.getWheelYOrigin() - y);
            }
            GTKColorChooserPanel.this.setSaturationAndBrightness(saturation, value, true);
            this.setFlag(8, false);
            return true;
        }

        private void setSaturationAndBrightness(float s, float b) {
            int innerR = this.getTriangleCircumscribedRadius();
            int triangleSize = innerR * 3 / 2;
            double x = b * (float)triangleSize;
            double maxY = x * Math.tan(Math.toRadians(30.0));
            double y = 2.0 * maxY * (double)s - maxY;
            double x1 = Math.cos(Math.toRadians(-60.0) - this.angle) * (x -= (double)innerR) - Math.sin(Math.toRadians(-60.0) - this.angle) * y;
            double y1 = Math.sin(Math.toRadians(-60.0) - this.angle) * x + Math.cos(Math.toRadians(-60.0) - this.angle) * y;
            int newCircleX = (int)x1 + this.getWheelXOrigin();
            int newCircleY = this.getWheelYOrigin() - (int)y1;
            this.setSaturationAndBrightness(s, b, newCircleX, newCircleY);
        }

        private void setSaturationAndBrightness(float s, float b, int newCircleX, int newCircleY) {
            int minX = Math.min(newCircleX -= this.getIndicatorSize() / 2, this.circleX);
            int minY = Math.min(newCircleY -= this.getIndicatorSize() / 2, this.circleY);
            this.repaint(minX, minY, Math.max(this.circleX, newCircleX) - minX + this.getIndicatorSize() + 1, Math.max(this.circleY, newCircleY) - minY + this.getIndicatorSize() + 1);
            this.circleX = newCircleX;
            this.circleY = newCircleY;
        }

        private boolean adjustHue(int x, int y, boolean check) {
            double rad = Math.sqrt(x * x + y * y);
            int size = this.getWheelRadius();
            if (!check || rad >= (double)(size - this.getWheelWidth()) && rad < (double)size) {
                double angle;
                if (x == 0) {
                    angle = y > 0 ? 1.5707963267948966 : 4.71238898038469;
                } else {
                    angle = Math.atan((double)y / (double)x);
                    if (x < 0) {
                        angle += Math.PI;
                    } else if (angle < 0.0) {
                        angle += Math.PI * 2;
                    }
                }
                this.setFlag(8, true);
                GTKColorChooserPanel.this.setHue((float)(1.0 - angle / Math.PI / 2.0), true);
                this.setFlag(8, false);
                this.setHueAngle(angle);
                this.setSaturationAndBrightness(GTKColorChooserPanel.this.getSaturation(), GTKColorChooserPanel.this.getBrightness());
                return true;
            }
            return false;
        }

        private void setAngleFromHue(float hue) {
            this.setHueAngle((1.0 - (double)hue) * Math.PI * 2.0);
        }

        private void setHueAngle(double angle) {
            double oldAngle = this.angle;
            this.angle = angle;
            if (angle != oldAngle) {
                this.setFlag(1, true);
                this.repaint();
            }
        }

        private int getIndicatorSize() {
            return 8;
        }

        private int getTriangleCircumscribedRadius() {
            return 72;
        }

        private int getWheelXOrigin() {
            return 85;
        }

        private int getWheelYOrigin() {
            return 85;
        }

        private int getWheelWidth() {
            return 13;
        }

        private void setFocusType(int type) {
            if (type == 0) {
                this.setFlag(16, false);
                this.setFlag(32, false);
                this.repaint();
            } else {
                int toSet = 16;
                int toUnset = 32;
                if (type == 2) {
                    toSet = 32;
                    toUnset = 16;
                }
                if (!this.isSet(toSet)) {
                    this.setFlag(toSet, true);
                    this.repaint();
                    this.setFlag(toUnset, false);
                }
            }
        }

        private int getWheelRadius() {
            return 85;
        }

        private void setFlag(int flag, boolean value) {
            this.flags = value ? (this.flags |= flag) : (this.flags &= ~flag);
        }

        private boolean isSet(int flag) {
            return (this.flags & flag) == flag;
        }

        private int colorWheelLocationToRGB(int x, int y, double rad) {
            int rgb;
            double angle = Math.acos((double)x / rad);
            if (angle < 1.0471975803375244) {
                rgb = y < 0 ? 0xFF0000 | Math.min(255, (int)(255.0 * angle / 1.0471975803375244)) << 8 : 0xFF0000 | Math.min(255, (int)(255.0 * angle / 1.0471975803375244));
            } else if (angle < 2.094395160675049) {
                rgb = y < 0 ? 0xFF00 | Math.max(0, 255 - (int)(255.0 * angle / 1.0471975803375244)) << 16 : 0xFF | Math.max(0, 255 - (int)(255.0 * (angle -= 1.0471975803375244) / 1.0471975803375244)) << 16;
            } else {
                angle -= 2.094395160675049;
                rgb = y < 0 ? 0xFF00 | Math.min(255, (int)(255.0 * angle / 1.0471975803375244)) : 0xFF | Math.min(255, (int)(255.0 * angle / 1.0471975803375244)) << 8;
            }
            return rgb;
        }

        void incrementHue(boolean positive) {
            float hue = GTKColorChooserPanel.this.triangle.getGTKColorChooserPanel().getHue();
            hue = positive ? (hue += 0.0027777778f) : (hue -= 0.0027777778f);
            if (hue > 1.0f) {
                hue -= 1.0f;
            } else if (hue < 0.0f) {
                hue += 1.0f;
            }
            this.getGTKColorChooserPanel().setHue(hue, true);
        }
    }
}

