/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PAData {
    private int pADataType;
    private byte[] pADataValue = null;
    private static final byte TAG_PATYPE = 1;
    private static final byte TAG_PAVALUE = 2;

    private PAData() {
    }

    public PAData(int new_pADataType, byte[] new_pADataValue) {
        this.pADataType = new_pADataType;
        if (new_pADataValue != null) {
            this.pADataValue = (byte[])new_pADataValue.clone();
        }
    }

    public Object clone() {
        PAData new_pAData = new PAData();
        new_pAData.pADataType = this.pADataType;
        if (this.pADataValue != null) {
            new_pAData.pADataValue = new byte[this.pADataValue.length];
            System.arraycopy(this.pADataValue, 0, new_pAData.pADataValue, 0, this.pADataValue.length);
        }
        return new_pAData;
    }

    public PAData(DerValue encoding) throws Asn1Exception, IOException {
        DerValue der = null;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.pADataType = der.getData().getBigInteger().intValue();
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) == 2) {
            this.pADataValue = der.getData().getOctetString();
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.pADataType);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.putOctetString(this.pADataValue);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)2), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public int getType() {
        return this.pADataType;
    }

    public byte[] getValue() {
        return this.pADataValue == null ? null : (byte[])this.pADataValue.clone();
    }
}

