/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.DefaultFocusManager;

final class LegacyGlueFocusTraversalPolicy
extends FocusTraversalPolicy
implements Serializable {
    private transient FocusTraversalPolicy delegatePolicy;
    private transient DefaultFocusManager delegateManager;
    private HashMap forwardMap = new HashMap();
    private HashMap backwardMap = new HashMap();

    LegacyGlueFocusTraversalPolicy(FocusTraversalPolicy delegatePolicy) {
        this.delegatePolicy = delegatePolicy;
    }

    LegacyGlueFocusTraversalPolicy(DefaultFocusManager delegateManager) {
        this.delegateManager = delegateManager;
    }

    void setNextFocusableComponent(Component left, Component right) {
        this.forwardMap.put(left, right);
        this.backwardMap.put(right, left);
    }

    void unsetNextFocusableComponent(Component left, Component right) {
        this.forwardMap.remove(left);
        this.backwardMap.remove(right);
    }

    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        Component hardCoded = aComponent;
        HashSet<Component> sanity = new HashSet<Component>();
        do {
            Component prevHardCoded = hardCoded;
            if ((hardCoded = (Component)this.forwardMap.get(hardCoded)) == null) {
                if (this.delegatePolicy != null && prevHardCoded.isFocusCycleRoot(focusCycleRoot)) {
                    return this.delegatePolicy.getComponentAfter(focusCycleRoot, prevHardCoded);
                }
                if (this.delegateManager != null) {
                    return this.delegateManager.getComponentAfter(focusCycleRoot, aComponent);
                }
                return null;
            }
            if (sanity.contains(hardCoded)) {
                return null;
            }
            sanity.add(hardCoded);
        } while (!this.accept(hardCoded));
        return hardCoded;
    }

    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        Component hardCoded = aComponent;
        HashSet<Component> sanity = new HashSet<Component>();
        do {
            Component prevHardCoded = hardCoded;
            if ((hardCoded = (Component)this.backwardMap.get(hardCoded)) == null) {
                if (this.delegatePolicy != null && prevHardCoded.isFocusCycleRoot(focusCycleRoot)) {
                    return this.delegatePolicy.getComponentBefore(focusCycleRoot, prevHardCoded);
                }
                if (this.delegateManager != null) {
                    return this.delegateManager.getComponentBefore(focusCycleRoot, aComponent);
                }
                return null;
            }
            if (sanity.contains(hardCoded)) {
                return null;
            }
            sanity.add(hardCoded);
        } while (!this.accept(hardCoded));
        return hardCoded;
    }

    public Component getFirstComponent(Container focusCycleRoot) {
        if (this.delegatePolicy != null) {
            return this.delegatePolicy.getFirstComponent(focusCycleRoot);
        }
        if (this.delegateManager != null) {
            return this.delegateManager.getFirstComponent(focusCycleRoot);
        }
        return null;
    }

    public Component getLastComponent(Container focusCycleRoot) {
        if (this.delegatePolicy != null) {
            return this.delegatePolicy.getLastComponent(focusCycleRoot);
        }
        if (this.delegateManager != null) {
            return this.delegateManager.getLastComponent(focusCycleRoot);
        }
        return null;
    }

    public Component getDefaultComponent(Container focusCycleRoot) {
        if (this.delegatePolicy != null) {
            return this.delegatePolicy.getDefaultComponent(focusCycleRoot);
        }
        return this.getFirstComponent(focusCycleRoot);
    }

    private boolean accept(Component aComponent) {
        if (!(aComponent.isVisible() && aComponent.isDisplayable() && aComponent.isFocusable() && aComponent.isEnabled())) {
            return false;
        }
        if (!(aComponent instanceof Window)) {
            for (Container enableTest = aComponent.getParent(); enableTest != null; enableTest = enableTest.getParent()) {
                if (!enableTest.isEnabled() && !enableTest.isLightweight()) {
                    return false;
                }
                if (enableTest instanceof Window) break;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.delegatePolicy instanceof Serializable) {
            out.writeObject(this.delegatePolicy);
        } else {
            out.writeObject(null);
        }
        if (this.delegateManager instanceof Serializable) {
            out.writeObject(this.delegateManager);
        } else {
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.delegatePolicy = (FocusTraversalPolicy)in.readObject();
        this.delegateManager = (DefaultFocusManager)in.readObject();
    }
}

