/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharJIS0201;
import sun.io.ByteToCharJIS0208;
import sun.io.ByteToCharJIS0212;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class ByteToCharEUC_JP
extends ByteToCharJIS0208 {
    private byte savedSecond = 0;
    ByteToCharJIS0201 bcJIS0201 = new ByteToCharJIS0201();
    ByteToCharJIS0212 bcJIS0212 = new ByteToCharJIS0212();

    public ByteToCharEUC_JP() {
        this.start = 161;
        this.end = 254;
        this.savedSecond = 0;
    }

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.savedSecond != 0) {
            this.reset();
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    public void reset() {
        super.reset();
        this.savedSecond = 0;
    }

    public String getCharacterEncoding() {
        return "EUC_JP";
    }

    protected char convSingleByte(int b) {
        if (b < 0 || b > 127) {
            return '\ufffd';
        }
        return this.bcJIS0201.getUnicode(b);
    }

    protected char getUnicode(int byte1, int byte2) {
        if (byte1 == 142) {
            return this.bcJIS0201.getUnicode(byte2 - 256);
        }
        if (byte1 < 0 || byte1 > this.index1.length || byte2 < this.start || byte2 > this.end) {
            return '\ufffd';
        }
        int n = (this.index1[byte1 - 128] & 0xF) * (this.end - this.start + 1) + (byte2 - this.start);
        return this.index2[this.index1[byte1 - 128] >> 4].charAt(n);
    }

    protected char decode0212(int byte1, int byte2) {
        return this.bcJIS0212.getUnicode(byte1, byte2);
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, ConversionBufferFullException {
        int outputChar = 65533;
        int inputSize = 0;
        this.charOff = outOff;
        this.byteOff = inOff;
        while (this.byteOff < inEnd) {
            int byte1;
            if (this.savedByte == 0) {
                byte1 = input[this.byteOff];
                inputSize = 1;
            } else {
                byte1 = this.savedByte;
                this.savedByte = 0;
                inputSize = 0;
            }
            outputChar = this.convSingleByte(byte1);
            if (outputChar == 65533) {
                int byte2;
                if ((byte1 & 0xFF) == 143) {
                    if (this.byteOff + inputSize + 1 >= inEnd) {
                        this.savedByte = (byte)byte1;
                        this.byteOff += inputSize;
                        if (this.byteOff >= inEnd) break;
                        this.savedSecond = input[this.byteOff];
                        ++this.byteOff;
                        break;
                    }
                    if (this.savedSecond != 0) {
                        byte1 = this.savedSecond & 0xFF;
                        this.savedSecond = 0;
                    } else {
                        byte1 = input[this.byteOff + inputSize] & 0xFF;
                        ++inputSize;
                    }
                    byte2 = input[this.byteOff + inputSize] & 0xFF;
                    ++inputSize;
                    outputChar = this.decode0212(byte1 - 128, byte2 - 128);
                } else {
                    if (this.byteOff + inputSize >= inEnd) {
                        this.savedByte = (byte)byte1;
                        this.byteOff += inputSize;
                        break;
                    }
                    byte2 = input[this.byteOff + inputSize] & 0xFF;
                    ++inputSize;
                    outputChar = this.getUnicode(byte1 &= 0xFF, byte2);
                }
            }
            if (outputChar == 65533) {
                if (this.subMode) {
                    outputChar = this.subChars[0];
                } else {
                    this.badInputLength = inputSize;
                    throw new UnknownCharacterException();
                }
            }
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            output[this.charOff++] = outputChar;
            this.byteOff += inputSize;
        }
        return this.charOff - outOff;
    }
}

