/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgIdDSA;

public final class DSAPrivateKey
extends PKCS8Key
implements java.security.interfaces.DSAPrivateKey,
Serializable {
    private static final long serialVersionUID = -3244453684193605938L;
    private BigInteger x;

    public DSAPrivateKey() {
    }

    public DSAPrivateKey(BigInteger x, BigInteger p, BigInteger q, BigInteger g) throws InvalidKeyException {
        this.x = x;
        this.algid = new AlgIdDSA(p, q, g);
        try {
            this.key = new DerValue(2, x.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException e) {
            InvalidKeyException ike = new InvalidKeyException("could not DER encode x: " + e.getMessage());
            ike.initCause(e);
            throw ike;
        }
    }

    public DSAPrivateKey(byte[] encoded) throws InvalidKeyException {
        this.clearOldKey();
        this.decode(encoded);
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters algParams = this.algid.getParameters();
            if (algParams == null) {
                return null;
            }
            DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            return null;
        }
    }

    public BigInteger getX() {
        return this.x;
    }

    private void clearOldKey() {
        int i;
        if (this.encodedKey != null) {
            for (i = 0; i < this.encodedKey.length; ++i) {
                this.encodedKey[i] = 0;
            }
        }
        if (this.key != null) {
            for (i = 0; i < this.key.length; ++i) {
                this.key[i] = 0;
            }
        }
    }

    public String toString() {
        return "Sun DSA Private Key \nparameters:" + this.algid + "\nx: " + Debug.toHexString(this.x) + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.x = in.getBigInteger();
        }
        catch (IOException e) {
            InvalidKeyException ike = new InvalidKeyException(e.getMessage());
            ike.initCause(e);
            throw ike;
        }
    }
}

