/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsButtonUI;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class WindowsToggleButtonUI
extends BasicToggleButtonUI {
    protected static int dashedRectGapX;
    protected static int dashedRectGapY;
    protected static int dashedRectGapWidth;
    protected static int dashedRectGapHeight;
    protected Color focusColor;
    private static final WindowsToggleButtonUI windowsToggleButtonUI;
    private boolean defaults_initialized = false;
    private transient Color cachedSelectedColor = null;
    private transient Color cachedBackgroundColor = null;
    private transient Color cachedHighlightColor = null;

    public static ComponentUI createUI(JComponent b) {
        return windowsToggleButtonUI;
    }

    protected void installDefaults(AbstractButton b) {
        XPStyle xp;
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            String pp = this.getPropertyPrefix();
            dashedRectGapX = (Integer)UIManager.get("Button.dashedRectGapX");
            dashedRectGapY = (Integer)UIManager.get("Button.dashedRectGapY");
            dashedRectGapWidth = (Integer)UIManager.get("Button.dashedRectGapWidth");
            dashedRectGapHeight = (Integer)UIManager.get("Button.dashedRectGapHeight");
            this.focusColor = UIManager.getColor(pp + "focus");
            this.defaults_initialized = true;
        }
        if ((xp = XPStyle.getXP()) != null) {
            b.setBorder(xp.getBorder(b, WindowsButtonUI.getXPButtonType(b)));
            LookAndFeel.installProperty(b, "opaque", Boolean.FALSE);
            LookAndFeel.installProperty(b, "rolloverEnabled", Boolean.TRUE);
        }
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (XPStyle.getXP() == null && b.isContentAreaFilled()) {
            Color oldColor = g.getColor();
            Color c1 = b.getBackground();
            Color c2 = UIManager.getColor("ToggleButton.highlight");
            if (c1 != this.cachedBackgroundColor || c2 != this.cachedHighlightColor) {
                int r1 = c1.getRed();
                int r2 = c2.getRed();
                int g1 = c1.getGreen();
                int g2 = c2.getGreen();
                int b1 = c1.getBlue();
                int b2 = c2.getBlue();
                this.cachedSelectedColor = new Color(Math.min(r1, r2) + Math.abs(r1 - r2) / 2, Math.min(g1, g2) + Math.abs(g1 - g2) / 2, Math.min(b1, b2) + Math.abs(b1 - b2) / 2);
                this.cachedBackgroundColor = c1;
                this.cachedHighlightColor = c2;
            }
            g.setColor(this.cachedSelectedColor);
            g.fillRect(0, 0, b.getWidth(), b.getHeight());
            g.setColor(oldColor);
        }
    }

    public void paint(Graphics g, JComponent c) {
        if (XPStyle.getXP() != null) {
            WindowsButtonUI.paintXPButtonBackground(g, c);
        }
        super.paint(g, c);
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        WindowsGraphicsUtils.paintText(g, b, textRect, text, this.getTextShiftOffset());
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, dashedRectGapX, dashedRectGapY, b.getWidth() - dashedRectGapWidth, b.getHeight() - dashedRectGapHeight);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        AbstractButton b = (AbstractButton)c;
        if (d != null && b.isFocusPainted()) {
            if (d.width % 2 == 0) {
                ++d.width;
            }
            if (d.height % 2 == 0) {
                ++d.height;
            }
        }
        return d;
    }

    static {
        windowsToggleButtonUI = new WindowsToggleButtonUI();
    }
}

