/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.Component;
import java.awt.event.ComponentListener;
import java.beans.BeanInfo;
import java.beans.Encoder;
import java.beans.EventSetDescriptor;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MetaData;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EventListener;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import sun.reflect.misc.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistenceDelegate
extends PersistenceDelegate {
    private String[] constructor;
    private Boolean definesEquals;

    public DefaultPersistenceDelegate() {
        this(new String[0]);
    }

    public DefaultPersistenceDelegate(String[] constructorPropertyNames) {
        this.constructor = constructorPropertyNames;
    }

    private static boolean definesEquals(Class type) {
        try {
            return type == type.getMethod("equals", Object.class).getDeclaringClass();
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean definesEquals(Object instance) {
        if (this.definesEquals != null) {
            return this.definesEquals == Boolean.TRUE;
        }
        boolean result = DefaultPersistenceDelegate.definesEquals(instance.getClass());
        this.definesEquals = result ? Boolean.TRUE : Boolean.FALSE;
        return result;
    }

    @Override
    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
        return this.constructor.length == 0 || !this.definesEquals(oldInstance) ? super.mutatesTo(oldInstance, newInstance) : oldInstance.equals(newInstance);
    }

    @Override
    protected Expression instantiate(Object oldInstance, Encoder out) {
        int nArgs = this.constructor.length;
        Class<?> type = oldInstance.getClass();
        Object[] constructorArgs = new Object[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            try {
                Method method = this.findMethod(type, this.constructor[i]);
                constructorArgs[i] = MethodUtil.invoke(method, oldInstance, new Object[0]);
                continue;
            }
            catch (Exception e) {
                out.getExceptionListener().exceptionThrown(e);
            }
        }
        return new Expression(oldInstance, oldInstance.getClass(), "new", constructorArgs);
    }

    private Method findMethod(Class type, String property) throws IntrospectionException {
        if (property == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        BeanInfo info = Introspector.getBeanInfo(type);
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            if (!property.equals(pd.getName())) continue;
            Method method = pd.getReadMethod();
            if (method != null) {
                return method;
            }
            throw new IllegalStateException("Could not find getter for the property " + property);
        }
        throw new IllegalStateException("Could not find property by the name " + property);
    }

    private boolean isTransient(Class type, PropertyDescriptor pd) {
        if (type == null) {
            return false;
        }
        String pName = pd.getName();
        BeanInfo info = MetaData.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            Object value;
            PropertyDescriptor pd2 = propertyDescriptors[i];
            if (!pName.equals(pd2.getName()) || (value = pd2.getValue("transient")) == null) continue;
            return Boolean.TRUE.equals(value);
        }
        return this.isTransient(type.getSuperclass(), pd);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private void doProperty(Class type, PropertyDescriptor pd, Object oldInstance, Object newInstance, Encoder out) throws Exception {
        Method getter = pd.getReadMethod();
        Method setter = pd.getWriteMethod();
        if (getter != null && setter != null && !this.isTransient(type, pd)) {
            Expression oldGetExp = new Expression(oldInstance, getter.getName(), new Object[0]);
            Expression newGetExp = new Expression(newInstance, getter.getName(), new Object[0]);
            Object oldValue = oldGetExp.getValue();
            Object newValue = newGetExp.getValue();
            out.writeExpression(oldGetExp);
            if (!DefaultPersistenceDelegate.equals(newValue, out.get(oldValue))) {
                Object[] e = (Object[])pd.getValue("enumerationValues");
                if (e instanceof Object[] && Array.getLength(e) % 3 == 0) {
                    Object[] a = e;
                    for (int i = 0; i < a.length; i += 3) {
                        try {
                            Field f = type.getField((String)a[i]);
                            if (!f.get(null).equals(oldValue)) continue;
                            out.remove(oldValue);
                            out.writeExpression(new Expression(oldValue, f, "get", new Object[]{null}));
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                DefaultPersistenceDelegate.invokeStatement(oldInstance, setter.getName(), new Object[]{oldValue}, out);
            }
        }
    }

    static void invokeStatement(Object instance, String methodName, Object[] args, Encoder out) {
        out.writeStatement(new Statement(instance, methodName, args));
    }

    private void initBean(Class type, Object oldInstance, Object newInstance, Encoder out) {
        BeanInfo info = MetaData.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            try {
                this.doProperty(type, propertyDescriptors[i], oldInstance, newInstance, out);
                continue;
            }
            catch (Exception e) {
                out.getExceptionListener().exceptionThrown(e);
            }
        }
        if (!Component.class.isAssignableFrom(type)) {
            return;
        }
        EventSetDescriptor[] eventSetDescriptors = info.getEventSetDescriptors();
        for (int e = 0; e < eventSetDescriptors.length; ++e) {
            EventSetDescriptor d = eventSetDescriptors[e];
            Class<?> listenerType = d.getListenerType();
            if (listenerType == ComponentListener.class || listenerType == ChangeListener.class && type == JMenuItem.class) continue;
            EventListener[] oldL = new EventListener[]{};
            EventListener[] newL = new EventListener[]{};
            try {
                Method m = d.getGetListenerMethod();
                oldL = (EventListener[])MethodUtil.invoke(m, oldInstance, new Object[0]);
                newL = (EventListener[])MethodUtil.invoke(m, newInstance, new Object[0]);
            }
            catch (Throwable e2) {
                try {
                    Method m = type.getMethod("getListeners", Class.class);
                    oldL = (EventListener[])MethodUtil.invoke(m, oldInstance, new Object[]{listenerType});
                    newL = (EventListener[])MethodUtil.invoke(m, newInstance, new Object[]{listenerType});
                }
                catch (Exception e3) {
                    return;
                }
            }
            String addListenerMethodName = d.getAddListenerMethod().getName();
            for (int i = newL.length; i < oldL.length; ++i) {
                DefaultPersistenceDelegate.invokeStatement(oldInstance, addListenerMethodName, new Object[]{oldL[i]}, out);
            }
            String removeListenerMethodName = d.getRemoveListenerMethod().getName();
            for (int i = oldL.length; i < newL.length; ++i) {
                DefaultPersistenceDelegate.invokeStatement(oldInstance, removeListenerMethodName, new Object[]{newL[i]}, out);
            }
        }
    }

    @Override
    protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
        super.initialize(type, oldInstance, newInstance, out);
        if (oldInstance.getClass() == type) {
            this.initBean(type, oldInstance, newInstance, out);
        }
    }
}

