/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import sun.tools.jconsole.Resources;

class Formatter {
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final String cr = System.getProperty("line.separator");
    static final DateFormat timeDF = new SimpleDateFormat("HH:mm");
    private static final DateFormat timeWithSecondsDF = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat dateDF = new SimpleDateFormat("yyyy-MM-dd");
    private static final String decimalZero = new DecimalFormatSymbols().getDecimalSeparator() + "0";

    Formatter() {
    }

    static String formatTime(long t) {
        String str;
        if (t < 60000L) {
            String seconds = String.format("%.3f", (double)t / 1000.0);
            str = Resources.getText("DurationSeconds", seconds);
        } else {
            long remaining = t;
            long days = remaining / 86400000L;
            long hours = (remaining %= 86400000L) / 3600000L;
            long minutes = (remaining %= 3600000L) / 60000L;
            str = t >= 86400000L ? Resources.getText("DurationDaysHoursMinutes", days, hours, minutes) : (t >= 3600000L ? Resources.getText("DurationHoursMinutes", hours, minutes) : Resources.getText("DurationMinutes", minutes));
        }
        return str;
    }

    static String formatNanoTime(long t) {
        long ms = t / 1000000L;
        return Formatter.formatTime(ms);
    }

    static String formatClockTime(long time) {
        return timeDF.format(time);
    }

    static String formatDate(long time) {
        return dateDF.format(time);
    }

    static String formatDateTime(long time) {
        return dateDF.format(time) + " " + timeWithSecondsDF.format(time);
    }

    static DateFormat getDateTimeFormat(String key) {
        String dtfStr = Resources.getText(key, new Object[0]);
        int dateStyle = -1;
        int timeStyle = -1;
        if (dtfStr.startsWith("SHORT")) {
            dateStyle = 3;
        } else if (dtfStr.startsWith("MEDIUM")) {
            dateStyle = 2;
        } else if (dtfStr.startsWith("LONG")) {
            dateStyle = 1;
        } else if (dtfStr.startsWith("FULL")) {
            dateStyle = 0;
        }
        if (dtfStr.endsWith("SHORT")) {
            timeStyle = 3;
        } else if (dtfStr.endsWith("MEDIUM")) {
            timeStyle = 2;
        } else if (dtfStr.endsWith("LONG")) {
            timeStyle = 1;
        } else if (dtfStr.endsWith("FULL")) {
            timeStyle = 0;
        }
        if (dateStyle != -1 && timeStyle != -1) {
            return DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        }
        if (dtfStr.length() > 0) {
            return new SimpleDateFormat(dtfStr);
        }
        return DateFormat.getDateTimeInstance();
    }

    static double toExcelTime(long time) {
        GregorianCalendar cal = new GregorianCalendar(1899, 11, 30);
        GregorianCalendar tmpCal = new GregorianCalendar();
        tmpCal.setTimeInMillis(time);
        int dst = tmpCal.get(16);
        if (dst > 0) {
            cal.set(16, dst);
        }
        long millisSince1900 = time - cal.getTimeInMillis();
        double value = (double)millisSince1900 / 8.64E7;
        return value;
    }

    static String[] formatKByteStrings(long ... bytes) {
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            if (bytes[i] <= 0L) continue;
            int n2 = i;
            bytes[n2] = bytes[n2] / 1024L;
        }
        String[] strings = Formatter.formatLongs(bytes);
        for (int i = 0; i < n; ++i) {
            strings[i] = Resources.getText("kbytes", strings[i]);
        }
        return strings;
    }

    static String formatKBytes(long bytes) {
        if (bytes == -1L) {
            return Resources.getText("kbytes", "-1");
        }
        long kb = bytes / 1024L;
        return Resources.getText("kbytes", Formatter.justify(kb, 10));
    }

    static String formatBytes(long v, boolean html) {
        return Formatter.formatBytes(v, v, html);
    }

    static String formatBytes(long v, long vMax) {
        return Formatter.formatBytes(v, vMax, false);
    }

    static String formatBytes(long v, long vMax, boolean html) {
        int exp = (int)Math.log10(vMax);
        String s = exp < 3 ? Resources.getText("Size Bytes", v) : (exp < 6 ? Resources.getText("Size Kb", Formatter.trimDouble((double)v / Math.pow(10.0, 3.0))) : (exp < 9 ? Resources.getText("Size Mb", Formatter.trimDouble((double)v / Math.pow(10.0, 6.0))) : Resources.getText("Size Gb", Formatter.trimDouble((double)v / Math.pow(10.0, 9.0)))));
        if (html) {
            s = s.replace(" ", "&nbsp;");
        }
        return s;
    }

    private static String trimDouble(double d) {
        String s = String.format("%.1f", d);
        if (s.length() > 3 && s.endsWith(decimalZero)) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    static String formatLong(long value) {
        return String.format("%,d", value);
    }

    static String[] formatLongs(long ... longs) {
        int i;
        int n = longs.length;
        int size = 0;
        String[] strings = new String[n];
        for (i = 0; i < n; ++i) {
            strings[i] = Formatter.formatLong(longs[i]);
            size = Math.max(size, strings[i].length());
        }
        for (i = 0; i < n; ++i) {
            strings[i] = Formatter.justify(strings[i], size);
        }
        return strings;
    }

    static String justify(long value, int size) {
        return Formatter.justify(Formatter.formatLong(value), size);
    }

    static String justify(String str, int size) {
        StringBuffer buf = new StringBuffer();
        buf.append("<TT>");
        int n = size - str.length();
        for (int i = 0; i < n; ++i) {
            buf.append("&nbsp;");
        }
        buf.append(str);
        buf.append("</TT>");
        return buf.toString();
    }

    static String newRow(String label, String value) {
        return Formatter.newRow(label, value, 2);
    }

    static String newRow(String label, String value, int columnPerRow) {
        label = label == null ? "" : label + ":&nbsp;";
        label = "<th nowrap align=right valign=top>" + label;
        value = "<td colspan=" + (columnPerRow - 1) + "> <font size =-1>" + value;
        return "<tr>" + label + value + "</tr>";
    }

    static String newRow(String label1, String value1, String label2, String value2) {
        label1 = "<th nowrap align=right valign=top>" + label1 + ":&nbsp;";
        value1 = "<td><font size =-1>" + value1;
        label2 = "<th nowrap align=right valign=top>" + label2 + ":&nbsp;";
        value2 = "<td><font size =-1>" + value2;
        return "<tr>" + label1 + value1 + label2 + value2 + "</tr>";
    }
}

