/****************************************************************************
**
** Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtNetwork module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef NETWORKDISKCACHE_H
#define NETWORKDISKCACHE_H

#include <QtNetwork/qabstractnetworkcache.h>

class NetworkDiskCachePrivate;
class NetworkDiskCache : public QAbstractNetworkCache
{
    Q_OBJECT

public:
    explicit NetworkDiskCache(QObject *parent = 0);
    ~NetworkDiskCache();

    QString cacheDirectory() const;
    void setCacheDirectory(const QString &cacheDir);

    qint64 maximumCacheSize() const;
    void setMaximumCacheSize(qint64 size);

    qint64 cacheSize() const;
    QNetworkCacheMetaData metaData(const QUrl &url);
    void updateMetaData(const QNetworkCacheMetaData &metaData);
    QIODevice *data(const QUrl &url);
    bool remove(const QUrl &url);
    QIODevice *prepare(const QNetworkCacheMetaData &metaData);
    void insert(QIODevice *device);

    QNetworkCacheMetaData fileMetaData(const QString &fileName) const;

public Q_SLOTS:
    void clear();

protected:
    virtual qint64 expire();

private:
    friend class NetworkDiskCachePrivate;
    NetworkDiskCachePrivate *const d;
    Q_DISABLE_COPY(NetworkDiskCache)
};

#endif // NETWORKDISKCACHE_H
