/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "cookiejar.h"
#include "diskcache/networkdiskcache.h"
#include "extensions/profiling.h"
#include "thumbnail/thumbnailnetworkreply.h"
#include "networkaccessmanager.h"

#include <QDebug>
#include <QDesktopServices>
#include <QMessageBox>
#include <QNetworkReply>
#include <QSslError>
#ifndef Q_WS_MAEMO_5
#include <QNetworkConfigurationManager>
#include <QNetworkSession>
#endif

NetworkAccessManager::NetworkAccessManager(QObject *parent) :
    QNetworkAccessManager(parent) {
#ifndef Q_WS_MAEMO_5
    m_manager = new QNetworkConfigurationManager(this);
    m_session = new QNetworkSession(m_manager->defaultConfiguration(), this);
    m_session->open();
    connect(m_session, SIGNAL(newConfigurationActivated()), m_session, SLOT(accept())); // we don't have stateful connections, any network will do
    connect(m_session, SIGNAL(preferredConfigurationChanged(const QNetworkConfiguration&, bool)),
            this, SLOT(preferredNetworkConfigurationChanged(const QNetworkConfiguration&, bool)));
#endif
    NetworkDiskCache *cache = new NetworkDiskCache(this);
    cache->setMaximumCacheSize(50 * 1024 * 1024);
    cache->setCacheDirectory(QDesktopServices::storageLocation(QDesktopServices::CacheLocation) + "/cache");
    setCache(cache);

    setCookieJar(new CookieJar(this));

    connect(this, SIGNAL(sslErrors(QNetworkReply *, const QList<QSslError> &)),
            SLOT(sslErrors(QNetworkReply *, const QList<QSslError> &)));

    connect(this, SIGNAL(finished(QNetworkReply*)), SLOT(finished(QNetworkReply*)));
}

QNetworkReply *NetworkAccessManager::createRequest(NetworkAccessManager::Operation op, const QNetworkRequest &request, QIODevice *outgoingData) {

    if (request.url().scheme() == "thumb") {
        return new ThumbnailNetworkReply(request, this);
    }

    QNetworkReply *reply = QNetworkAccessManager::createRequest(op, request, outgoingData);
    if (request.url().scheme() != "file") {
#ifndef Q_WS_MAEMO_5
        if (!m_session->isOpen() && m_session->state() != QNetworkSession::Connecting && m_session->state() != QNetworkSession::Roaming) {
            qDebug() << "reopening network session...";
            m_session->open();
        }
#endif
        Profiling::instance()->startRequest(reply);
    }

    return reply;
}

#ifndef Q_WS_MAEMO_5
void NetworkAccessManager::preferredNetworkConfigurationChanged(const QNetworkConfiguration &config, bool isSeamless) {

    Q_UNUSED(isSeamless);
    Q_UNUSED(config);

    // as we don't maintain any stateful connection (yet) we can just switch to the
    // preferred network (e.g. wifi) as soon as it becomes available
    qDebug() << "migrating network session...";
    m_session->migrate();
}
#endif

void NetworkAccessManager::finished(QNetworkReply *reply) {

    if (reply->request().url().scheme() != "file" && reply->request().url().scheme() != "thumb") {
        Profiling::instance()->stopRequest(reply);
    }
}

void NetworkAccessManager::sslErrors(QNetworkReply *reply, const QList<QSslError> &errors) {

    foreach (const QSslError &error, errors) {
        QMessageBox::warning(0, tr("SSL error"), error.errorString());
    }

    reply->ignoreSslErrors();
}
