/*
 * Geolocation.h
 *
 *  Created on: Nov 24, 2009
 *      Author: nitobi-test
 */

#ifndef GEOLOCATION_H
#define GEOLOCATION_H

#include <QObject>
#include <QVariantMap>
#include <QGeoPositionInfo>
#include <QGeoPositionInfoSource>

QTM_USE_NAMESPACE


class Geolocation : public QObject {

    Q_OBJECT

    public:
        Geolocation(QObject *parent = 0);

        enum PositionError {
            ENoError = 0,
            EPermissionDenied = 1,
            EPositionUnavailable = 2,
            ETimeout = 3
        };

        bool highAccuracy() const;
        void setHighAccuracy(bool value);
        QVariantMap lastPosition();
        static QVariantMap positionToVariantMap(const QGeoPositionInfo &info);

        Q_PROPERTY(bool highAccuracy READ highAccuracy WRITE setHighAccuracy);
        Q_PROPERTY(QVariantMap lastPosition READ lastPosition);

    public slots:
        void update(int timeout = 0);
        void start();
        void stop();

    signals:
        void positionUpdated(const QVariantMap &position);
        void error(const QVariantMap &positionError);

    private:
        QGeoPositionInfoSource *m_source;
#ifdef Q_WS_MAEMO_5
        QGeoPositionInfo m_lastKnownPosition;
#endif
        bool m_watchingPosition;
        bool m_highAccuracy;

        bool initSource();
        void emitError(PositionError code, const QString &message);

    private slots:
        void onPositionUpdated(const QGeoPositionInfo &info);
        void onUpdateTimeout();
};

#endif // GEOLOCATION_H
