#include "stundenplanwidget.h"
#include "settingsdlg.h"

StundenplanWidget::StundenplanWidget(QWidget *parent) :
    QWidget(parent)
{
    setFixedSize(280,170);
    setAttribute(Qt::WA_TranslucentBackground);

    /* Labels */
    time_label = new LLabel();
    beschreibung_label = new LLabel();
    kurzbeschreibung_label = new LLabel();
    raum_label = new LLabel();
    time_label->setSpeed(500);
    time_label->setAlignment(Qt::AlignLeft);
    time_label->setMinimumHeight(40);
    time_label->setMaximumHeight(40);
    time_label->setStyleSheet("font: bold");
    beschreibung_label->setSpeed(500);
    beschreibung_label->setAlignment(Qt::AlignLeft);
    kurzbeschreibung_label->setSpeed(500);
    kurzbeschreibung_label->setAlignment(Qt::AlignLeft);
    raum_label->setSpeed(500);
    raum_label->setAlignment(Qt::AlignLeft);

    /* VBoxLayout */
    vbox = new QVBoxLayout();
    vbox->setMargin(15);
    vbox->setSpacing(0);
    vbox->addWidget(time_label);
    vbox->addWidget(beschreibung_label);
    vbox->addWidget(kurzbeschreibung_label);
    vbox->addWidget(raum_label);

    /* Layout dem Stundenplan Widget hinzufgen */
    setLayout(vbox);

    /* Update Timer erstellen */
    uintervall = 60000;
    update_timer = new QTimer();
    connect(update_timer,SIGNAL(timeout()),this,SLOT(updateWidget()));

    /* Stundenplanobjekt erstellen und falls vorhanden Stundenplan aus Datei lesen */
    plan = new Stundenplan("/home/user/stundenplan.ini");
    connect(plan,SIGNAL(settingsReaded()),this,SLOT(settingsReaded()));
    connect(plan,SIGNAL(planReaded()),this,SLOT(planReaded()));
    plan->readSettings();
}

QSize StundenplanWidget::sizeHint() const{
    return 1.3 * QWidget::sizeHint();
}

void StundenplanWidget::showSettingsDialog(){
    SettingsDlg dlg(plan);
    if(dlg.exec()==1){
        uintervall = dlg.updateintervall;
        if(update_timer->isActive()){
            update_timer->stop();
            update_timer->start(uintervall);
        }

    }

}

void StundenplanWidget::paintEvent(QPaintEvent *event){
    QPainter p(this);
    p.setBrush(QColor(0, 0, 0, 128));
    p.setPen(Qt::NoPen);
    p.drawRoundedRect(rect(), 25, 25);
    p.end();
    QWidget::paintEvent(event);
}

void StundenplanWidget::updateWidget(){
    StundenplanItem tmp = plan->getCurrenStundenplan();
    if(tmp.getDoppelstunde()<8){
        time_label->setLText(tmp.getDoppelstundeStart().toString("hh:mm") + " - " + tmp.getDoppelstundeEnde().toString("hh:mm") + " Uhr");
        beschreibung_label->setLText(tmp.getBeschreibung());
        kurzbeschreibung_label->setLText(tmp.getKurzbeschreibung());
        raum_label->setLText(tmp.getRaum());
    }
    else{
        time_label->setLText(tmp.getKurzbeschreibung());
        beschreibung_label->setLText("");
        kurzbeschreibung_label->setLText("");
        raum_label->setLText("");
    }
}

void StundenplanWidget::planReaded(){
    updateWidget();
    if(!update_timer->isActive()) update_timer->start(uintervall);
    plan->saveSettings();
}

void StundenplanWidget::settingsReaded(){
    updateWidget();
    if(!update_timer->isActive()) update_timer->start(uintervall);
}
