#ifndef STUNDENPLAN_H
#define STUNDENPLAN_H

#include <QObject>
#include <QByteArray>
#include <QUrl>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QList>
#include <QTime>
#include <QDate>
#include <QMetaType>
#include <QVariant>
#include <QVariantList>
#include <QSettings>



enum Kalenderwoche {
    gerade,
    ungerade
};

class StundenplanItem{
private:
    int ds; // 0 - 6
    QTime ds_start;
    QTime ds_end;
    int tag;
    QString text1;
    QString text2;
    QString text3;
public:
    StundenplanItem();
    StundenplanItem(int doppelstunde, int tag, QString beschreibung, QString kurzbeschreibung, QString raum);
    StundenplanItem(int doppelstunde, int tag, QStringList liste);
    StundenplanItem(const StundenplanItem& s);

    bool operator==(StundenplanItem vgl);
    bool operator!=(StundenplanItem vgl);
    StundenplanItem &operator=(const StundenplanItem &s);

    int getDoppelstunde() const; // 1 - 7
    QTime getDoppelstundeStart() const;
    QTime getDoppelstundeEnde() const;
    int getWochentag() const;
    QString getBeschreibung() const;
    QString getKurzbeschreibung() const;
    QString getRaum() const;
    QList<QString> getAllText() const;

    void setDoppelstunde(int doppelstunde); // 1 - 7
    //void setDoppelstundeTime(QTime startzeit, QTime ende);
    void setWochentag(int tag);
    void setBeschreibung(QString b);
    void setKurzbeschreibung(QString kb);
    void setRaum(QString r);
    void setAllText(QList<QString> liste);
    void setAll(int doppelstunde, int tag, QString beschreibung, QString kurzbeschreibung, QString raum);
    void setAll(int doppelstunde, int tag, QStringList liste);
};

Q_DECLARE_METATYPE(StundenplanItem);

QDataStream &operator<<(QDataStream &out, const StundenplanItem &obj);
QDataStream &operator>>(QDataStream &in, StundenplanItem &obj);

class Stundenplan : public QObject
{
    Q_OBJECT
public:
    explicit Stundenplan(QString fname, QObject *parent = 0);

    StundenplanItem getAenderung(Kalenderwoche kw, int index);
    QList<StundenplanItem> getAenderung(Kalenderwoche kw);

    StundenplanItem getStundenplan(Kalenderwoche kw, int tag, int ds);
    QList<StundenplanItem> getStundenplan(Kalenderwoche kw, int tag);

    StundenplanItem getCurrenStundenplan(int vorlaufzeit=0); // fehlt noch





private:
    QNetworkAccessManager *manager;
    QList<StundenplanItem> stundenplan[2][7];
    QList<StundenplanItem> aenderungen[2];

    int lastupdatekw;
    bool autoupdate;
    bool autowriteaenderungen;
    QString matrikelnummer;
    QString imm_jahr;
    QString studiengang;
    QString gruppe;

    QSettings *einstellungen;


signals:
    void connectionError();
    void planReaded();
    void settingsReaded();
    void saveToFileError();
    void readFromFileError();

public slots:
    void readPlan(QString imjahr, QString studiengang, QString gruppe);
    void readPlan(QString matnr);
    void readPlan();

    void clearPlan();

    void addAenderung(Kalenderwoche kw, StundenplanItem a);
    void removeAenderung(Kalenderwoche kw, int index);
    void removeAenderung(Kalenderwoche kw, StundenplanItem a);
    void removeAllAenderung();
    void writeAllAenderung();

    void setGruppe(QString imjahr,QString studieng, QString gr);
    void setMatNr(QString matnr);

    void setAutoUpdate(bool aktiv);
    void setAutoWriteAenderungen(bool aktiv);

    void saveSettings();
    void readSettings();

private slots:
    void replyFinished(QNetworkReply*);

};

#endif // STUNDENPLAN_H
