#!/bin/sh

# Part of h-e-n, this is not The Right Way(TM) to handle file system mounting.
# ke-recv always runs on Maemo 5 as a daemon, yet it does not properly handle
# mounting.
# Help would be appreciated with ke-recv.

# Thanks to debernardis for help with the script.

prefix=run-standalone.sh

loadmodules() {
	if [ -f /lib/modules/"`uname -r`"/ntfs.ko ]
		then modprobe ntfs
	fi

	if [ -f /lib/modules/"`uname -r`"/isofs.ko ]
		then modprobe isofs
	fi
} 

mountpartitions() {
list=`awk '$4~"[0-9]$"{print $4}' /proc/partitions | grep -v "mmcblk*" | grep -v "loop*"`
for partitions in $list
	do
		mkdir -p /media/$partitions
		loadmodules
		mount -o uid=29999,gid=29999,utf8,dmask=027,fmask=137 /dev/$partitions /media/$partitions
		if [ "$?" = "0" ]
			then 
				success=$partitions
				$prefix dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Successfully mounted /dev/$success on /media/$success!"
				# Set a return code here to be read later, useful for opening file manager,
				# otherwise file manager will be called multiple times!
				mounted=yes
		fi
done
}

unmount() {
lista=`awk '$4~"[0-9]$"{print $4}' /proc/partitions | grep -v "mmcblk*" | grep -v "loop*"`
for partitions in $lista
	do
		umount /media/$partitions
		# Don't clutter up /media, remove mount points one by one
		rmdir /media/$partitions
done
}   

if [ "$1" = "--mount" ]
	then
		mountpartitions
fi

if [ "$1" = "--unmount" ]
	then
		unmount
fi

if [ "$mounted" = "yes" ]
	then
		$prefix dbus-send --type=method_call --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:"filemanager"
fi
