#ifndef QEMAEMO5DYNAMICHOMESCREENWIDGET_H
#define QEMAEMO5DYNAMICHOMESCREENWIDGET_H

#include <QtCore>
#include <QtGui>

#define WIDGET_SETTINGS_BASE_APPLETID QApplication::applicationName() + "-widget-"
#define WIDGET_SETTINGS_POSITION_X "-position-x"
#define WIDGET_SETTINGS_POSITION_Y "-position-y"
#define WIDGET_SETTINGS_HOMESCREEN_N "-homescreen-n"

class QeMaemo5DynamicHomescreenWidget : public QWidget
{
    Q_OBJECT

    friend class QeMaemo5DynamicWidgetHelper;

private:

    bool _isPositionLoaded;
    bool _isPressed;
    bool _settingsDialogAvailable;
    bool _isVisibleOnCurrentHomescreen;
    bool _shouldRegister;
    bool _shouldSavePositionInMoveEvent;
    bool _shouldSavePosition;
    int _hackSequenceForSavingFromCallback;
    int _hackSequenceCount; // Hack needed because of Maemo.org bug 10725: https://bugs.maemo.org/show_bug.cgi?id=10725
    int _homescreenNumber; // Hack needed because of Maemo.org bug 10725: https://bugs.maemo.org/show_bug.cgi?id=10725
    QTimer *_focusHackTimer; // Hack needed because of a bug that the desktop doesn't retake focus.
    QString _appletId;

protected:

    virtual bool x11Event(XEvent *event);
    virtual void paintEvent(QPaintEvent *event);
    virtual void mousePressEvent(QMouseEvent *event);
    virtual void mouseReleaseEvent(QMouseEvent *event);
    virtual void mouseMoveEvent(QMouseEvent *event);
    virtual void showEvent(QShowEvent *event);
    virtual void closeEvent(QCloseEvent *event);
    virtual void moveEvent(QMoveEvent *event);

    virtual void showSettingsDialog();
    virtual bool restoreWidgetState();

protected Q_SLOTS:

    void enableSavePosition();
    void disableSavePosition();
    void checkFocusHack();

public:

    explicit QeMaemo5DynamicHomescreenWidget(bool settingsAvailable = false, QWidget *parent = 0);
    ~QeMaemo5DynamicHomescreenWidget();

    QString appletId();
    void saveSetting(const QString &key, const QVariant &data);
    QVariant loadSetting(const QString &key, const QVariant &defaultValue = QVariant());

    bool isVisibleOnCurrentHomescreen();
    bool settingsDialogAvailable();
    bool isPressed();
    bool isPositionLoaded();
    bool shouldRegister();
    void setShouldRegister(bool value);
    int homescreenNumber();
    bool restoreAppletId(const QString &restoredAppletId);

public Q_SLOTS:

    void savePosition();
    void loadPosition();
};

#endif // QEMAEMO5DYNAMICHOMESCREENWIDGET_H
