#include "home.h"
#include "ui_home.h"
#include "qsettings.h"
#include <qdir.h>
#include <qfileinfo.h>
#include <qtextstream.h>

QString hPath, tema;
QIcon ich;
QSettings hsettings("cepiperez", "homescreen-dockbar");


Home::Home(QWidget *parent, QString target, QString path) :
    QDialog(parent),
    ui(new Ui::Home)
{
    ui->setupUi(this);

    target1 = target;

    this->setWindowTitle(tr("Select image"));

    tema = "";
    QFile data2( "/etc/hildon/theme/index.theme" );
    if (data2.open(QFile::ReadOnly | QFile::Truncate))
    {
         QTextStream out(&data2);
         while ( !out.atEnd() )
         {
             QString line = out.readLine();
             if ( line.indexOf("IconTheme=") == 0 ) if ( tema=="") tema = line;
         }
     }
    data2.close();
    tema.replace("IconTheme=","");
    tema = tema.trimmed();

    ich = QPixmap("/usr/share/icons/" + tema + "/48x48/hildon/filemanager_folder_up.png");
    ui->pushButton->setIcon( ich );

    QFileInfo dr(path);

    ich = QPixmap("/usr/share/icons/" + tema + "/48x48/hildon/general_folder.png");
    ui->button->setIcon( ich );
    ui->button->setText( dr.fileName() );
    if ( path == "/") ui->button->setText( "/" );
    ui->button->setValueText( path );
    if ( path == "/") ui->button->setValueText( "" );

    CargarBrowser( path );


}

Home::~Home()
{
    delete ui;
}

void Home::CargarBrowser(QString directorio)
{
    hPath = directorio;
    QDir dir ( directorio, "*" );
    dir.setFilter ( QDir::Dirs | QDir::Hidden );
    if ( !dir.isReadable() )
          return;
    ui->button->setText( QFileInfo(directorio).fileName() );
    if ( directorio == "/") ui->button->setText( "/" );
    ui->button->setValueText( directorio );
    if ( directorio == "/") ui->button->setValueText( "" );

    ui->listWidget->clear();

    QStringList entries = dir.entryList();
    entries.sort();
    QStringList::ConstIterator it = entries.begin();

    dir.setFilter( QDir::AllEntries | QDir::Hidden | QDir::NoDotAndDotDot );

    dir.setSorting( QDir::Name | QDir::DirsFirst | QDir::IgnoreCase );

    QFileInfoList list = dir.entryInfoList();
    for (int i = 0; i < list.size(); ++i)
    {
      QFileInfo fileInfo = list.at(i);

        if ( fileInfo.isDir() )
        {

            QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );
            item1->setData(Qt::DisplayRole, fileInfo.fileName());
            ich = QPixmap("/usr/share/icons/" + tema + "/48x48/hildon/general_folder.png");
            item1->setData(Qt::DecorationRole, ich);
            ui->listWidget->insertItem( i, item1 );

        }
        else if ( fileInfo.completeSuffix() == "png" )
        {
            QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );
            item1->setData(Qt::DisplayRole, fileInfo.fileName());
            ich = QPixmap("/usr/share/icons/" + tema + "/48x48/hildon/general_image.png");
            item1->setData(Qt::DecorationRole, ich);
            ui->listWidget->insertItem( i, item1 );
        }
    }

    if ( ui->listWidget->count() > 0 ) {
        ui->listWidget->scrollToItem(ui->listWidget->item(0));
    }

}

void Home::on_listWidget_itemClicked(QListWidgetItem* item)
{
    QString temp = hPath;
    if ( temp != "/" ) temp.append("/");
    temp.append( item->text() );
    if ( temp == "//" ) temp="/";

    if ( QFileInfo(temp).isFile() )
    {
        hsettings.setValue(target1, temp);
        this->close();
    }

    CargarBrowser( temp );
}

void Home::on_pushButton_clicked()
{
    if ( hPath == "/" ) return;
    QString nPath = hPath;
    int i = nPath.lastIndexOf( "/" );
    nPath.remove ( i, nPath.length() - i );
    if ( nPath == "" ) nPath = "/";
    CargarBrowser( nPath );

}
