// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_PANNABLE_AREA_H
#define _HILDONMM_PANNABLE_AREA_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/adjustment.h>
#include <gtkmm/bin.h>
#include <gtkmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonPannableArea HildonPannableArea;
typedef struct _HildonPannableAreaClass HildonPannableAreaClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class PannableArea_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildonmmEnums Enums and Flags */

/**
 * @ingroup hildonmmEnums
 */
enum PannableAreaMode
{
  PANNABLE_AREA_MODE_PUSH,
  PANNABLE_AREA_MODE_ACCEL,
  PANNABLE_AREA_MODE_AUTO
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::PannableAreaMode> : public Glib::Value_Enum<Hildon::PannableAreaMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{

/**
 * @ingroup hildonmmEnums
 * @par Bitwise operators:
 * <tt>%MovementMode operator|(MovementMode, MovementMode)</tt><br>
 * <tt>%MovementMode operator&(MovementMode, MovementMode)</tt><br>
 * <tt>%MovementMode operator^(MovementMode, MovementMode)</tt><br>
 * <tt>%MovementMode operator~(MovementMode)</tt><br>
 * <tt>%MovementMode& operator|=(MovementMode&, MovementMode)</tt><br>
 * <tt>%MovementMode& operator&=(MovementMode&, MovementMode)</tt><br>
 * <tt>%MovementMode& operator^=(MovementMode&, MovementMode)</tt><br>
 */
enum MovementMode
{
  MOVEMENT_MODE_HORIZ = 1 << 1,
  MOVEMENT_MODE_VERT = 1 << 2,
  MOVEMENT_MODE_BOTH = 0x000006
};

/** @ingroup hildonmmEnums */
inline MovementMode operator|(MovementMode lhs, MovementMode rhs)
  { return static_cast<MovementMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup hildonmmEnums */
inline MovementMode operator&(MovementMode lhs, MovementMode rhs)
  { return static_cast<MovementMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup hildonmmEnums */
inline MovementMode operator^(MovementMode lhs, MovementMode rhs)
  { return static_cast<MovementMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup hildonmmEnums */
inline MovementMode operator~(MovementMode flags)
  { return static_cast<MovementMode>(~static_cast<unsigned>(flags)); }

/** @ingroup hildonmmEnums */
inline MovementMode& operator|=(MovementMode& lhs, MovementMode rhs)
  { return (lhs = static_cast<MovementMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup hildonmmEnums */
inline MovementMode& operator&=(MovementMode& lhs, MovementMode rhs)
  { return (lhs = static_cast<MovementMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup hildonmmEnums */
inline MovementMode& operator^=(MovementMode& lhs, MovementMode rhs)
  { return (lhs = static_cast<MovementMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::MovementMode> : public Glib::Value_Flags<Hildon::MovementMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{

/**
 * @ingroup hildonmmEnums
 */
enum MovementDirection
{
  MOVEMENT_UP,
  MOVEMENT_DOWN,
  MOVEMENT_LEFT,
  MOVEMENT_RIGHT
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::MovementDirection> : public Glib::Value_Enum<Hildon::MovementDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{

/**
 * @ingroup hildonmmEnums
 */
enum SizeRequestPolicy
{
  SIZE_REQUEST_MINIMUM,
  SIZE_REQUEST_CHILDREN
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::SizeRequestPolicy> : public Glib::Value_Enum<Hildon::SizeRequestPolicy>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{


/** A scrolling widget designed for touch screens.
 *
 * Hildon::PannableArea is a container widget that can be "panned" (scrolled)
 * up and down using the touchscreen with fingers. The widget has no scrollbars,
 * but it rather shows small scroll indicators to give an idea of the part of the
 * content that is visible at a time. The scroll indicators appear when a dragging
 * motion is started on the pannable area.
 *
 * The scrolling is "kinetic", meaning the motion can be "flicked" and it will
 * continue from the initial motion by gradually slowing down to an eventual stop.
 * The motion can also be stopped immediately by pressing the touchscreen over the
 * pannable area.
 *
 * @see Gtk::ScrolledWindow
 *
 * @ingroup HildonWidgets
 */

class PannableArea : public Gtk::Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PannableArea CppObjectType;
  typedef PannableArea_Class CppClassType;
  typedef HildonPannableArea BaseObjectType;
  typedef HildonPannableAreaClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~PannableArea();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class PannableArea_Class;
  static CppClassType pannablearea_class_;

  // noncopyable
  PannableArea(const PannableArea&);
  PannableArea& operator=(const PannableArea&);

protected:
  explicit PannableArea(const Glib::ConstructParams& construct_params);
  explicit PannableArea(HildonPannableArea* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonPannableArea*       gobj()       { return reinterpret_cast<HildonPannableArea*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonPannableArea* gobj() const { return reinterpret_cast<HildonPannableArea*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_horizontal_movement(MovementDirection direction, double x, double y);
  virtual void on_vertical_movement(MovementDirection direction, double x, double y);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  PannableArea();
  explicit PannableArea(PannableAreaMode mode, bool enabled, double velocity_min, double velocity_max,
                          double deceleration, guint sps);

  
  /** Convenience function used to add a child to a Gtk::Viewport, and add the
   * viewport to the scrolled window.
   * 
   * @newin2p2
   * @param child Child widget to add to the viewport.
   */

  virtual void add(Gtk::Widget& widget);

  
  /** Smoothly scrolls @a area to ensure that ( @a x, @a y) is a visible point
   * on the widget. To move in only one coordinate, you must set the other one
   * to -1. Notice that, in Hildon::PANNABLE_AREA_MODE_PUSH mode, this function
   * works just like jump_to().
   * 
   * This function is useful if you need to present the user with a particular
   * element inside a scrollable widget, like Gtk::TreeView. For instance,
   * the following example shows how to scroll inside a Gtk::TreeView to
   * make visible an item, indicated by the Gtk::TreeIter @a iter.
   * 
   * <example>
   * <programlisting>
   * GtkTreePath *path;
   * GdkRectangle *rect;
   * <!-- -->
   * path = gtk_tree_model_get_path (model, &iter);
   * gtk_tree_view_get_background_area (GTK_TREE_VIEW (treeview),
   * path, <tt>0</tt>, &rect);
   * gtk_tree_view_convert_bin_window_to_tree_coords (GTK_TREE_VIEW (treeview),
   * 0, rect.y, <tt>0</tt>, &y);
   * hildon_pannable_area_scroll_to (panarea, -1, y);
   * gtk_tree_path_free (path);
   * </programlisting>
   * </example>
   * 
   * If you want to present a child widget in simpler scenarios,
   * use scroll_to_child() instead.
   * 
   * There is a precondition to this function: the widget must be
   * already realized. Check the jump_to_child() for
   * more tips regarding how to call this function during
   * initialization.
   * 
   * @newin2p2
   * @param x The x coordinate of the destination point or -1 to ignore this axis.
   * @param y The y coordinate of the destination point or -1 to ignore this axis.
   */
  void scroll_to(int x, int y);
  
  /** Jumps the position of @a area to ensure that ( @a x, @a y) is a visible
   * point in the widget. In order to move in only one coordinate, you
   * must set the other one to -1. See scroll_to()
   * function for an example of how to calculate the position of
   * children in scrollable widgets like Gtk::Treeview.
   * 
   * There is a precondition to this function: the widget must be
   * already realized. Check the jump_to_child() for
   * more tips regarding how to call this function during
   * initialization.
   * 
   * @newin2p2
   * @param x The x coordinate of the destination point or -1 to ignore this axis.
   * @param y The y coordinate of the destination point or -1 to ignore this axis.
   */
  void jump_to(int x, int y);
  
  /** Smoothly scrolls until @a child is visible inside @a area. @a child must
   * be a descendant of @a area. If you need to scroll inside a scrollable
   * widget, e.g., Gtk::Treeview, see scroll_to().
   * 
   * There is a precondition to this function: the widget must be
   * already realized. Check the jump_to_child() for
   * more tips regarding how to call this function during
   * initialization.
   * 
   * @newin2p2
   * @param child A Gtk::Widget, descendant of @a area.
   */
  void scroll_to_child(const Gtk::Widget& child);
  
  /** Jumps to make sure @a child is visible inside @a area. @a child must
   * be a descendant of @a area. If you want to move inside a scrollable
   * widget, like, Gtk::Treeview, see scroll_to().
   * 
   * There is a precondition to this function: the widget must be
   * already realized. You can control if the widget is ready with the
   * GTK_WIDGET_REALIZED macro. If you want to call this function during
   * the initialization process of the widget do it inside a callback to
   * the ::realize signal, using Glib::signal_connect_after() function.
   * 
   * @newin2p2
   * @param child A Gtk::Widget, descendant of @a area.
   */
  void jump_to_child(const Gtk::Widget& child);

  
  /** Get the widget at the point (x, y) inside the pannable area. In
   * case no widget found it returns <tt>0</tt>.
   * @param area A Hildon::PannableArea.
   * @param x Horizontal coordinate of the point.
   * @param y Vertical coordinate of the point.
   * @return The Gtk::Widget if we find a widget, <tt>0</tt> in any other case
   * 
   * @newin2p2.
   */
  Gtk::Widget* get_child_at(double x, double y);
  
  /** Get the widget at the point (x, y) inside the pannable area. In
   * case no widget found it returns <tt>0</tt>.
   * @param area A Hildon::PannableArea.
   * @param x Horizontal coordinate of the point.
   * @param y Vertical coordinate of the point.
   * @return The Gtk::Widget if we find a widget, <tt>0</tt> in any other case
   * 
   * @newin2p2.
   */
  const Gtk::Widget* get_child_at(double x, double y) const;

  
  /** This function returns the current size request policy of the
   * widget. That policy controls the way the size_request is done in
   * the pannable area. Check
   * set_size_request_policy() for a more detailed
   * explanation.
   * @return The policy is currently being used in the widget
   * Hildon::SizeRequestPolicy.
   * 
   * @newin2p2.
   */
  SizeRequestPolicy get_size_request_policy() const;
  
  /** This function sets the pannable area size request policy. That
   * policy controls the way the size_request is done in the pannable
   * area. Pannable can use the size request of its children
   * (Hildon::SIZE_REQUEST_CHILDREN) or the minimum size required for
   * the area itself (Hildon::SIZE_REQUEST_MINIMUM), the latter is the
   * default. Recall this size depends on the scrolling policy you are
   * requesting to the pannable area, if you set Gtk::POLICY_NEVER this
   * parameter will not have any effect with
   * Hildon::SIZE_REQUEST_MINIMUM set.
   * 
   * @newin2p2
   * 
   * Deprecated: This method and the policy request is deprecated, DO
   * NOT use it in future code, the only policy properly supported in
   * gtk+ nowadays is the minimum size. Use #gtk_window_set_default_size
   * or #gtk_window_set_geometry_hints with the proper size in your case
   * to define the height of your dialogs.
   * @param size_request_policy One of the allowed Hildon::SizeRequestPolicy.
   */
  void set_size_request_policy(SizeRequestPolicy size_request_policy);

  
  /** returns: The horizontal Gtk::Adjustment
   * @return The horizontal Gtk::Adjustment
   * 
   * @newin2p2.
   */
  Gtk::Adjustment* get_hadjustment();
  
  /** returns: The horizontal Gtk::Adjustment
   * @return The horizontal Gtk::Adjustment
   * 
   * @newin2p2.
   */
  const Gtk::Adjustment* get_hadjustment() const;
  
  /** returns: The vertical Gtk::Adjustment
   * @return The vertical Gtk::Adjustment
   * 
   * @newin2p2.
   */
  Gtk::Adjustment* get_vadjustment();
  
  /** returns: The vertical Gtk::Adjustment
   * @return The vertical Gtk::Adjustment
   * 
   * @newin2p2.
   */
  const Gtk::Adjustment* get_vadjustment() const;

  
  /**
   * @par Prototype:
   * <tt>void on_my_%horizontal_movement(MovementDirection direction, double x, double y)</tt>
   */

  Glib::SignalProxy3< void,MovementDirection,double,double > signal_horizontal_movement();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%vertical_movement(MovementDirection direction, double x, double y)</tt>
   */

  Glib::SignalProxy3< void,MovementDirection,double,double > signal_vertical_movement();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Enable or disable finger-scroll.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_enabled() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Enable or disable finger-scroll.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_enabled() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Visual policy of the vertical scrollbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::PolicyType> property_vscrollbar_policy() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Visual policy of the vertical scrollbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::PolicyType> property_vscrollbar_policy() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Visual policy of the horizontal scrollbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::PolicyType> property_hscrollbar_policy() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Visual policy of the horizontal scrollbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::PolicyType> property_hscrollbar_policy() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Change the finger-scrolling mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<PannableAreaMode> property_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Change the finger-scrolling mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PannableAreaMode> property_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls if the widget can scroll vertically
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<MovementMode> property_mov_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls if the widget can scroll vertically
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<MovementMode> property_mov_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum distance the child widget should scroll per 'frame'
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_velocity_min() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum distance the child widget should scroll per 'frame'
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_velocity_min() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum distance the child widget should scroll per 'frame'
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_velocity_max() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum distance the child widget should scroll per 'frame'
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_velocity_max() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum velocity that is considered 'fast': children widgets won't receive button presses. Expressed as a fraction of the maximum velocity.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_velocity_fast_factor() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Minimum velocity that is considered 'fast': children widgets won't receive button presses. Expressed as a fraction of the maximum velocity.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_velocity_fast_factor() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The multiplier used when decelerating when in acceleration scrolling mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_deceleration() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The multiplier used when decelerating when in acceleration scrolling mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_deceleration() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Amount of scroll events to generate per second.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<unsigned int> property_sps() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Amount of scroll events to generate per second.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<unsigned int> property_sps() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Space we allow the widget to pass over its vertical limits whenhitting the edges
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_vovershoot_max() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Space we allow the widget to pass over its vertical limits whenhitting the edges
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_vovershoot_max() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Space we allow the widget to pass over its horizontal limits whenhitting the edges
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_hovershoot_max() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Space we allow the widget to pass over its horizontal limits whenhitting the edges
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_hovershoot_max() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The time to scroll to a position when calling the hildon_pannable_scroll_to function.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_scroll_time() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The time to scroll to a position when calling the hildon_pannable_scroll_to function.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_scroll_time() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to hint the user about the pannability of the container.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_initial_hint() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to hint the user about the pannability of the container.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_initial_hint() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Avoid decelerating the panning movement
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_low_friction_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Avoid decelerating the panning movement
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_low_friction_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls the size request policy of the widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<SizeRequestPolicy> property_size_request_policy() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Controls the size request policy of the widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SizeRequestPolicy> property_size_request_policy() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkAdjustment for the horizontal position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Adjustment*> property_hadjustment() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkAdjustment for the vertical position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Adjustment*> property_vadjustment() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::PannableArea
   */
  Hildon::PannableArea* wrap(HildonPannableArea* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_PANNABLE_AREA_H */

