// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_EDIT_TOOLBAR_H
#define _HILDONMM_EDIT_TOOLBAR_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/box.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonEditToolbar HildonEditToolbar;
typedef struct _HildonEditToolbarClass HildonEditToolbarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class EditToolbar_Class; } // namespace Hildon
namespace Hildon
{

/** A toolbar widget for editing.
 *
 * Hildon::EditToolbar is a toolbar which contains a label and two buttons, one
 * of them being an arrow pointing backwards.
 *
 * The label is a description of the action that the user is supposed to do.
 * The button is to be pressed when the user completes the action. The arrow is
 * used to go back to the previous view discarding any changes.
 *
 * Note that those widgets don't do anything themselves by default. To actually
 * peform actions the developer must provide signal handlers for them.
 *
 * To add a Hildon::EditToolbar to a window use
 * Hildon::Window::set_edit_toolbar().
 *
 * @ingroup HildonWidgets
 */

class EditToolbar : public Gtk::HBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef EditToolbar CppObjectType;
  typedef EditToolbar_Class CppClassType;
  typedef HildonEditToolbar BaseObjectType;
  typedef HildonEditToolbarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~EditToolbar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class EditToolbar_Class;
  static CppClassType edittoolbar_class_;

  // noncopyable
  EditToolbar(const EditToolbar&);
  EditToolbar& operator=(const EditToolbar&);

protected:
  explicit EditToolbar(const Glib::ConstructParams& construct_params);
  explicit EditToolbar(HildonEditToolbar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonEditToolbar*       gobj()       { return reinterpret_cast<HildonEditToolbar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonEditToolbar* gobj() const { return reinterpret_cast<HildonEditToolbar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  EditToolbar();

  
  /** Creates a new Hildon::EditToolbar, with the toolbar label set to
   *  @a label and the button label set to @a button.
   * @param label Text for the toolbar label.
   * @param button Text for the toolbar button.
   * @return A new Hildon::EditToolbar
   * 
   * @newin2p2.
   */

  EditToolbar(const Glib::ustring& label, const Glib::ustring& button);

  
  /** Sets the label of @a toolbar to @a label. This will clear any
   * previously set value.
   * 
   * @newin2p2
   * @param label A new text for the toolbar label.
   */
  void set_label(const Glib::ustring& label);
  
  /** Sets the label of the toolbar button to @a label. This will clear any
   * previously set value.
   * 
   * @newin2p2
   * @param label A new text for the label of the toolbar button.
   */
  void set_button_label(const Glib::ustring& label);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%button_clicked()</tt>
   */

  Glib::SignalProxy0< void > signal_button_clicked();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%arrow_clicked()</tt>
   */

  Glib::SignalProxy0< void > signal_arrow_clicked();


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::EditToolbar
   */
  Hildon::EditToolbar* wrap(HildonEditToolbar* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_EDIT_TOOLBAR_H */

