// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_ANIMATION_ACTOR_H
#define _HILDONMM_ANIMATION_ACTOR_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/window.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonAnimationActor HildonAnimationActor;
typedef struct _HildonAnimationActorClass HildonAnimationActorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class AnimationActor_Class; } // namespace Hildon
namespace Hildon
{

/** Animation actor widget for WM-assisted animation effects in the
 * Hildon framework.
 *
 * Hildon::AnimationActor is an animation actor
 * for WM-assisted animation effects in the Hildon framework. It derives
 * from Gtk::Window and can host any widgets much
 * like a normal window. The special features available to the
 * animation actor is the ability to set its position, scale factor
 * and rotation. These parameters are interpreted by Hildon's
 * compositing window manager to alter the on-screen representation of
 * the animation actor window. Bear in mind, however, that by design
 * decision, animation actors are not reactive -- the widgets placed
 * in such window will not receive keyboard, motion or button
 * events. Animation actors are input-transparent -- the input events
 * will be sent to the underlying real windows and widgets.
 *
 * The animation actors may exist in a parented or an unparented
 * state. To be displayed, animations actors must be parented to
 * another top-level window widget. Animation actors display on top
 * (in front) of the standard window contents unless the position
 * (depth, z-coordinate) is specifically adjusted. Animation actors in
 * an unparented state do not display at all.
 *
 * Parented animation actors are placed in the coordinate space of the
 * parent window and visually become a part of the parent window
 * iteslf -- they inherit the transformations and effects enforced by
 * the window manager on the parent window (task switcher animations,
 * minimize events, etc.).
 *
 * All animation actor settings (position, scale, rotation, opacity,
 * depth) can be applied to unparented actors, but will only take
 * effect as the actor is parented to a top-level window and that
 * window is shown. All settings are preserved during
 * unparenting/reparenting.
 *
 * The AnimationActor API closely follows the Clutter::Actor
 * API.  Please take a look at the Clutter::Actor description for the
 * modelview transformations order that applies to
 * Hildon::AnimationActor and Clutter::Actor alike.
 *
 * Animation actor widget controls the animation actor as it is
 * transformed by the window manager using ClientMessage X11
 * events. It tries to minimize the amount of such events and couples
 * conceptually related parameters (visibility and opacity, position
 * and depth) to the same message.  The API, however, offers
 * convenience functions for the programmer to be able to modify every
 * parameter individually.
 */

class AnimationActor : public Gtk::Window
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AnimationActor CppObjectType;
  typedef AnimationActor_Class CppClassType;
  typedef HildonAnimationActor BaseObjectType;
  typedef HildonAnimationActorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~AnimationActor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class AnimationActor_Class;
  static CppClassType animationactor_class_;

  // noncopyable
  AnimationActor(const AnimationActor&);
  AnimationActor& operator=(const AnimationActor&);

protected:
  explicit AnimationActor(const Glib::ConstructParams& construct_params);
  explicit AnimationActor(HildonAnimationActor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonAnimationActor*       gobj()       { return reinterpret_cast<HildonAnimationActor*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonAnimationActor* gobj() const { return reinterpret_cast<HildonAnimationActor*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  

  enum Axis
  {
    AXIS_X = 0,
    AXIS_Y = 1,
    AXIS_Z = 2
  };
  enum Gravity
  {
    GRAVITY_N      = 1,
    GRAVITY_NE     = 2,
    GRAVITY_E      = 3,
    GRAVITY_SE     = 4,
    GRAVITY_S      = 5,
    GRAVITY_SW     = 6,
    GRAVITY_W      = 7,
    GRAVITY_NW     = 8,
    GRAVITY_CENTER = 9
  };

  AnimationActor();

  
  /** Send a message to the window manager setting the visibility of
   * the animation actor. This will only affect the visibility of
   * the animation actor set by the compositing window manager in its own
   * rendering pipeline, after X has drawn the window to the off-screen
   * buffer. This setting, naturally, has no effect if the Hildon::AnimationActor
   * widget is not visible in X11 terms (i.e. realized and mapped).
   * 
   * Furthermore, if a widget is parented, its final visibility will be
   * affected by that of the parent window.
   * 
   * The opacity setting ranges from zero (0), being completely transparent
   * to 255 (0xff) being fully opaque.
   * 
   * If the animation actor WM-counterpart is not ready, the show message
   * will be queued until the WM is ready for it.
   * 
   * @newin2p2
   * @param show A boolean flag setting the visibility of the animation actor.
   * @param opacity Desired opacity setting.
   */
  void set_show(bool show, int opacity);
  
  /** This function sets the overall actor visibility without changing its opacity
   * setting.
   * 
   * @newin2p2
   * @param show A boolean flag setting the visibility of the animation actor.
   */
  void set_show(bool show = true);
  
  /** This function sets actor opacity without changing its overall visibility.
   * 
   * The opacity setting ranges from zero (0), being completely transparent to 255 (0xff) being fully opaque.
   * 
   * @newin2p2
   * @param opacity Desired opacity setting.
   */
  void set_opacity(int opacity);

  
  /** Send a message to the window manager setting the position of the
   * animation actor. This will set the position of the animation
   * actor off-screen bitmap as it is rendered to the screen. The
   * position of the actor is relative to the parent window. The actor
   * is also subject to the animation effects rendered by the compositing
   * window manager on that window (like those by task switcher).
   * 
   * The window depth affects the stacking of animation actors within
   * a parent window and, more generally, the stacking of clutter actors
   * within a stage/container. The default depth is 0 and a parent
   * window's container will have it's window texture stacked at that level.
   * The stacking at any depth level is sequential -- animation actor B
   * created/parented after animation actor A will obscure the latter
   * if they overlap.
   * 
   * Animation actors with non-zero depth settings are subject to scaling as
   * per the global scene perspective setup, which limits the depth setting
   * as the primary parameter to control the stacking order. Since the
   * stacking order follows the parenting order, it may be better to use
   * set_parent() for setting the stacking.
   * 
   * If the animation actor WM-counterpart is not ready, the show message
   * will be queued until the WM is ready for it.
   * 
   * @newin2p2
   * @param x Desired X coordinate.
   * @param y Desired Y coordinate.
   * @param depth Desired window depth (Z coordinate).
   */
  void set_position(int x, int y, int depth);
  
  /** Changes the window position, but preserves its depth setting.
   * 
   * @newin2p2
   * @param x Desired window X coordinate.
   * @param y Desired window Y coordinate.
   */
  void set_position(int x, int y);
  
  /** Changes the window depth, but preserves its position.
   * 
   * @newin2p2
   * @param depth Desired window depth (Z coordinate).
   */
  void set_depth(int depth);

  
  /** Send a message to the window manager setting the scale factors of the
   * animation actor. This will set the scale factors on the animation
   * actor off-screen bitmap as it is rendered to the screen. If the
   * animation actor is parented to another top-level window, the
   * animation effects rendered by the compositing window manager
   * on that top-level window (like those by task switcher) will
   * also affect the animation actor.
   * 
   * If the animation actor WM-counterpart is not ready, the show message
   * will be queued until the WM is ready for it.
   * 
   * @newin2p2
   * @param x_scale Window's desired scale factor along the X-axis.
   * @param y_scale Window's desired scale factor along the Y-axis.
   */
  void set_scale(double x_scale, double y_scale);
  
  /** Send a message to the window manager setting the animation actor
   * rotation around one of the three axes. The rotation center coordinates
   * depend on the axis of rotation:
   * 
   * * Hildon::AA_X_AXIS requires @a y and @a z coordinates.
   * * Hildon::AA_Y_AXIS requires @a x and @a z coordinates.
   * * Hildon::AA_Z_AXIS requires @a x and @a y coordinates.
   * 
   * If the animation actor WM-counterpart is not ready, the show message
   * will be queued until the WM is ready for it.
   * 
   * @newin2p2
   * @param axis The rotation axis.
   * @param degrees The rotation angle in degrees.
   * @param x Center of the rotation, X coordinate.
   * @param y Center of the rotation, Y coordinate.
   * @param z Center of the rotation, Z coordinate.
   */
  void set_rotation(Axis axis, double degrees, int x, int y, int z);

  
  /** Send a message to the window manager setting the anchor point for
   * the animation actor. The anchor point is the point to which the
   * actor position within its parent it is relative.
   * 
   * If the animation actor WM-counterpart is not ready, the show message
   * will be queued until the WM is ready for it.
   * 
   * @newin2p2
   * @param x The X coordinate of the anchor point.
   * @param y The Y coordinate of the anchor point.
   */
  void set_anchor(int x, int y);
  
  /** Send a message to the window manager setting the anchor point for
   * the animation actor. The anchor point is the point to which the
   * actor position within its parent it is relative. Instead of being
   * defined in (x, y)-coordinates, the anchor point is defined in the
   * relative "gravity" constant as:
   * 
   * * Hildon::AA_N_GRAVITY translates to (width / 2, 0) coordinate
   * * Hildon::AA_NE_GRAVITY translates to (width, 0) coordinate
   * * Hildon::AA_E_GRAVITY translates to (width, height / 2) coordinate
   * * Hildon::AA_SE_GRAVITY translates to (width, height) coordinate
   * * Hildon::AA_S_GRAVITY translates to (width / 2, height) coordinate
   * * Hildon::AA_SW_GRAVITY translates to (0, height) coordinate
   * * Hildon::AA_W_GRAVITY translates to (0, height / 2) coordinate
   * * Hildon::AA_NW_GRAVITY translates to (0, 0) coordinate
   * * Hildon::AA_CENTER_GRAVITY translates to (width / 2, height / 2) coordinate
   * 
   * If the animation actor WM-counterpart is not ready, the show message
   * will be queued until the WM is ready for it.
   * 
   * @newin2p2
   * @param gravity The gravity constant.
   */
  void set_anchor_from_gravity(Gravity gravity);

  // Ugly; overloads Gtk::Widget::set_parent()
  
  /** Send a message to the window manager setting the parent window
   * for the animation actor. Parenting an actor will not affect the
   * X window that the Hildon::AnimationActor represents, but its off-screen
   * bitmap as it is handled by the compositing window manager.
   * 
   * Parenting an animation actor will affect its visibility as set
   * by gtk_widget_show(), gtk_widget_hide() and
   * set_show(). The animation actor will only be
   * visible when its top-level window is parented and visible.
   * 
   * Passing <tt>0</tt> as a @a parent argument will unparent the animation actor.
   * This will restore the actor's visibility if it was suppressed by
   * being unparented or parented to an unmapped window.
   * 
   * If the animation actor WM-counterpart is not ready, the show message
   * will be queued until the WM is ready for it.
   * 
   * @newin2p2
   * @param parent A Gtk::Window that the actor will be parented to.
   */
  void set_parent(Gtk::Window& parent);

  // Same here but with Gtk::Widget::unparent(), so it's at least orthagonal
  /** Unparent the animation actor.
   * This will restore the actor's visibility if it was suppressed by
   * being unparented or parented to an unmapped window.
   */
  void unparent();


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::AnimationActor
   */
  Hildon::AnimationActor* wrap(HildonAnimationActor* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_ANIMATION_ACTOR_H */

