// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_TOUCH_SELECTOR_H
#define _HILDONMM_TOUCH_SELECTOR_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/touch-selector-column.h>
#include <gtkmm/cellrenderer.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treeselection.h>
#include <gtkmm/box.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonTouchSelector HildonTouchSelector;
typedef struct _HildonTouchSelectorClass HildonTouchSelectorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class TouchSelector_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildonmmEnums Enums and Flags */

/**
 * @ingroup hildonmmEnums
 */
enum TouchSelectorSelectionMode
{
  TOUCH_SELECTOR_SELECTION_MODE_SINGLE,
  TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::TouchSelectorSelectionMode> : public Glib::Value_Enum<Hildon::TouchSelectorSelectionMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{


/** A selector widget with several columns.
 *
 * Hildon::TouchSelector is a selector widget, that allows users to select items
 * from one to many predefined lists. It is very similar to Gtk::ComboBox, but
 * with several individual pannable columns.
 *
 * Normally, you would use Hildon::TouchSelector together with a
 * Hildon::PickerDialog activated from a button. For the most common cases, you
 * should use Hildon::PickerButton.
 *
 * The composition of each column in the selector is represented by a
 * Gtk::TreeModel. To add a new column to a Hildon::TouchSelector, use
 * Hildon::TouchSelector::append_column(). If you want to add a text-only
 * column, without special attributes, use Hildon::TouchSelector::append_text_column().
 *
 * It is highly recommended that you use only one column Hildon::TouchSelector<!-- -->s.
 * If you only need a text only, one column selector, you can create it with
 * Hildon::TouchSelector::append_text_column() and populate with
 * Hildon::TouchSelector::append_text(), Hildon::TouchSelector::prepend_text(),
 * and Hildon::TouchSelector::insert_text().
 *
 * If you need a selector widget that also accepts user inputs, you can use
 * Hildon::TouchSelectorEntry.
 *
 * The current selection has a string representation. In the most common cases,
 * each column model will contain a text column. You can configure which column
 * in particular using Hildon::TouchSelectorColumn::property_text_column().
 *
 * You can get this string representation using
 * Hildon::TouchSelector::get_current_text(). You can configure how the
 * selection is printed with Hildon::TouchSelector::set_print_func(), that sets
 * the current hildon touch selector print function. The widget has a default
 * print function, that uses the Hildon::TouchSelectorColumn::property_text_column()
 * on each Hildon::TouchSelectorColumn to compose the final representation.
 *
 * If you create the selector using Hildon_touch_selector_new_text() you don't
 * need to take care of this property, as the model is created internally. If
 * you create the selector using hildon_touch_selector_new(), you need to
 * specify properly the property for your custom model in order to get a
 * non-empty string representation, or define your custom print function.
 *
 */

class TouchSelector : public Gtk::VBox
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TouchSelector CppObjectType;
  typedef TouchSelector_Class CppClassType;
  typedef HildonTouchSelector BaseObjectType;
  typedef HildonTouchSelectorClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TouchSelector();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TouchSelector_Class;
  static CppClassType touchselector_class_;

  // noncopyable
  TouchSelector(const TouchSelector&);
  TouchSelector& operator=(const TouchSelector&);

protected:
  explicit TouchSelector(const Glib::ConstructParams& construct_params);
  explicit TouchSelector(HildonTouchSelector* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonTouchSelector*       gobj()       { return reinterpret_cast<HildonTouchSelector*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonTouchSelector* gobj() const { return reinterpret_cast<HildonTouchSelector*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_changed(int column);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

   
public:
  typedef TouchSelectorColumn Column;
  typedef TouchSelectorSelectionMode SelectionMode;

  TouchSelector();


  void append_text(const Glib::ustring& text);
  
  void prepend_text(const Glib::ustring& text);
  
  void insert_text(int position, const Glib::ustring& text);

  
  Glib::RefPtr<TouchSelectorColumn>
               append_text_column(const Glib::RefPtr<Gtk::TreeModel>& model, bool center = false);

  
  Glib::RefPtr<TouchSelectorColumn> append_column(const Glib::RefPtr<Gtk::TreeModel>& model,
                                                  Gtk::CellRenderer& cell_renderer);

  
  bool remove_column(int column);
  
  int get_num_columns() const;

  
  void set_column_selection_mode(TouchSelectorSelectionMode mode);
  
  TouchSelectorSelectionMode get_column_selection_mode() const;

  
  Glib::RefPtr<TouchSelectorColumn> get_column(int column);
  
  Glib::RefPtr<const TouchSelectorColumn> get_column(int column) const;

  
  void set_active(int column, int index);
  
  int get_active(int column) const;

  
  Gtk::TreeModel::iterator get_selected(int column);

  
  void select_iter(int column, const Gtk::TreeModel::iterator& iter, bool scroll_to);
  
  void unselect_iter(int column, const Gtk::TreeModel::iterator& iter);
  
  void unselect_all(int column);


  Gtk::TreeSelection::ListHandle_Path get_selected_rows(int column) const;

  
  void set_model(int column, const Glib::RefPtr<Gtk::TreeModel>& model);
  
  Glib::RefPtr<Gtk::TreeModel> get_model(int column);
  
  Glib::RefPtr<const Gtk::TreeModel> get_model(int column) const;

  
  Glib::ustring get_current_text() const;

   
  void set_print_func(const sigc::slot<Glib::ustring>& func);
  void unset_print_func();

  
  bool has_multiple_selection() const;
  
  void center_on_selected();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%changed(int column)</tt>
   */

  Glib::SignalProxy1< void,int > signal_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%columns_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_columns_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to scroll to thecurrent selection whenthe selector is firstshown.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_initial_scroll() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to scroll to thecurrent selection whenthe selector is firstshown.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_initial_scroll() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_model_vfunc(int column, const Glib::RefPtr<Gtk::TreeModel>& model);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool has_multiple_selection_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::TouchSelector
   */
  Hildon::TouchSelector* wrap(HildonTouchSelector* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_TOUCH_SELECTOR_H */

