// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_TOUCH_SELECTOR_ENTRY_H
#define _HILDONMM_TOUCH_SELECTOR_ENTRY_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildonmm/touch-selector.h>
#include <hildonmm/entry.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonTouchSelectorEntry HildonTouchSelectorEntry;
typedef struct _HildonTouchSelectorEntryClass HildonTouchSelectorEntryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class TouchSelectorEntry_Class; } // namespace Hildon
namespace Hildon
{

/** Selector widget with a text entry.
 *
 * Hildon::TouchSelectorEntry is a selector widget with a text entry, similar
 * in behaviour to Gtk::ComboBoxEntry, that allows user to select an item from
 * a predefined list or to enter a different one in a Hildon::Entry. Items can
 * also be searched and selected by typing in the entry. For more specific use
 * cases, the Hildon::Entry can be accessed directly with
 * Hildon::TouchSelectorEntry::get_entry().
 *
 * The main difference between the Gtk::TreeModel used by Hildon::TouchSelector
 * and Hildon::TouchSelectorEntry, is that the latter must always include a text
 * column. You should set it with Hildon::TouchSelectorEntry::set_text_column().
 *
 * Normally, you would use Hildon::TouchSelectorEntry together with a
 * Hildon::PickerDialog activated from a button. For the most common
 * cases, you should use Hildon::PickerButton.
 *
 * If you only need a text only, one column selector, you can create it with
 * Hildon::TouchSelector::append_text_column() and populate it with
 * Hildon::TouchSelector::append_text(), Hildon::TouchSelector::prepend_text(),
 * and Hildon::TouchSelector::insert_text().
 */

class TouchSelectorEntry : public TouchSelector
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TouchSelectorEntry CppObjectType;
  typedef TouchSelectorEntry_Class CppClassType;
  typedef HildonTouchSelectorEntry BaseObjectType;
  typedef HildonTouchSelectorEntryClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TouchSelectorEntry();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TouchSelectorEntry_Class;
  static CppClassType touchselectorentry_class_;

  // noncopyable
  TouchSelectorEntry(const TouchSelectorEntry&);
  TouchSelectorEntry& operator=(const TouchSelectorEntry&);

protected:
  explicit TouchSelectorEntry(const Glib::ConstructParams& construct_params);
  explicit TouchSelectorEntry(HildonTouchSelectorEntry* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonTouchSelectorEntry*       gobj()       { return reinterpret_cast<HildonTouchSelectorEntry*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonTouchSelectorEntry* gobj() const { return reinterpret_cast<HildonTouchSelectorEntry*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  TouchSelectorEntry();


  void set_text_column(int text_column);
  
  int get_text_column() const;

  
  Gtk::Hildon::InputMode get_input_mode() const;
  
  void set_input_mode(Gtk::Hildon::InputMode input_mode);

  
  Entry* get_entry();
  
  const Entry* get_entry() const;

 
};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::TouchSelectorEntry
   */
  Hildon::TouchSelectorEntry* wrap(HildonTouchSelectorEntry* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_TOUCH_SELECTOR_ENTRY_H */

