#!/usr/bin/env python

import dbus
import sys

bus = dbus.SessionBus()
obj = bus.get_object('org.hildon.eventfeed', '/org/hildon/eventfeed')
feed = dbus.Interface(obj, dbus_interface='org.hildon.eventfeed')

item = {}
item['icon'] = 'general_rss'
item['title'] = 'Example item'
item['body'] = 'This is an example item'
item['sourceName'] = 'example_feed'
item['sourceDisplayName'] = 'Example feed'
item['url'] = 'http://talk.maemo.org'

id = feed.addItem(item)

if id == -1:
    print 'Cannot add item to event feed'
    sys.exit(1)
else:
    print 'Added item id is %d' % id
    sys.exit(0)
