#ifndef EVENT_H
#define EVENT_H

#include <QString>
#include <QRegExp>

class Event {

public:
    explicit Event() :
        m_iconDownloaded(false),
        m_imageOneDownloaded(false),
        m_imageTwoDownloaded(false)
    {
    }

    inline qint64 eventId() const { return m_eventId; }
    inline void setEventId(qint64 id) { m_eventId = id; }
    inline QString sourceName() const { return m_sourceName; }
    inline void setSourceName(const QString &name) { m_sourceName = name; }
    inline QString sourceDisplayName() const { return m_sourceDisplayName; }
    inline void setSourceDisplayName(const QString &name) { m_sourceDisplayName = name; }
    inline QString iconPath() const { return m_iconPath; }
    inline void setIconPath(const QString &path) { m_iconPath = path; setIconFormat(path.section('.', -1).section(QRegExp("[^\\w]"), 0, 0)); }
    inline QString iconFormat() const { return m_iconFormat; }
    inline void setIconFormat(const QString &format) { m_iconFormat = format; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; }
    inline QString body() const { return m_body; }
    inline void setBody(const QString &body) { m_body = body; }
    inline QString imagePathOne() const { return m_imagePathOne; }
    inline void setImagePathOne(const QString &path) { m_imagePathOne = path; setImageFormatOne(path.section('.', -1).section(QRegExp("[^\\w]"), 0, 0)); }
    inline QString imageFormatOne() const { return m_imageFormatOne; }
    inline void setImageFormatOne(const QString &format) { m_imageFormatOne = format; }
    inline QString imagePathTwo() const { return m_imagePathTwo; }
    inline void setImagePathTwo(const QString &path) { m_imagePathTwo = path; setImageFormatTwo(path.section('.', -1).section(QRegExp("[^\\w]"), 0, 0)); }
    inline QString imageFormatTwo() const { return m_imageFormatTwo; }
    inline void setImageFormatTwo(const QString &format) { m_imageFormatTwo = format; }
    inline QString footer() const { return m_footer; }
    inline void setFooter(const QString &footer) { m_footer = footer; }
    inline qint64 timestamp() const { return m_timestamp; }
    inline void setTimestamp(qint64 msecs) { m_timestamp = msecs; }
    inline QString action() const { return m_action; }
    inline void setAction(const QString &action) { m_action = action; }
    inline QString refreshAction() const { return m_refreshAction; }
    inline void setRefreshAction(const QString &action) { m_refreshAction = action; }
    bool inline iconDownloaded() const { return (!iconPath().startsWith("http")) || (m_iconDownloaded); }
    inline void setIconDownloaded(bool downloaded) { m_iconDownloaded = downloaded; }
    bool inline imageOneDownloaded() const { return (!imagePathOne().startsWith("http")) || (m_imageOneDownloaded); }
    inline void setImageOneDownloaded(bool downloaded) { m_imageOneDownloaded = downloaded; }
    bool inline imageTwoDownloaded() const { return (!imagePathTwo().startsWith("http")) || (m_imageTwoDownloaded); }
    inline void setImageTwoDownloaded(bool downloaded) { m_imageTwoDownloaded = downloaded; }

private:
    qint64 m_eventId;
    QString m_sourceName;
    QString m_sourceDisplayName;
    QString m_iconPath;
    QString m_iconFormat;
    QString m_title;
    QString m_body;
    QString m_imagePathOne;
    QString m_imagePathTwo;
    QString m_imageFormatOne;
    QString m_imageFormatTwo;
    QString m_footer;
    qint64 m_timestamp;
    QString m_action;
    QString m_refreshAction;
    bool m_iconDownloaded;
    bool m_imageOneDownloaded;
    bool m_imageTwoDownloaded;
};

#endif // EVENT_H
