#include "listview.h"

ListView::ListView(QWidget *parent) :
    QListView(parent)
{
    setEditTriggers(QListView::NoEditTriggers);
    setAutoScroll(false);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setAttribute(Qt::WA_TranslucentBackground, true);
    setStyleSheet("background:transparent");
}

void ListView::positionAtBeginning() {
    scrollTo(model()->index(0, 0), QListView::PositionAtTop);
}

void ListView::moveUp() {
    scrollTo(indexAt(QPoint(0, - 5)), QListView::PositionAtTop);
}

void ListView::moveDown() {
    scrollTo(indexAt(QPoint(0, height() + 5)), QListView::PositionAtTop);
}

void ListView::mousePressEvent(QMouseEvent *event) {
    setCurrentIndex(indexAt(event->pos()));
    QListView::mousePressEvent(event);
}

void ListView::mouseReleaseEvent(QMouseEvent *event) {
    QListView::mouseReleaseEvent(event);
    setCurrentIndex(QModelIndex());
}
