#ifndef UTILS_H
#define UTILS_H

#include <QString>
#include <QDateTime>

class Utils
{

public:
    static QString durationFromSecs(int secs);
    static QString durationFromMSecs(int msecs);
    static QString fileSizeFromPath(const QString &filePath);
    static QString fileSizeFromBytes(double bytes);
    static QString dateFromSecs(qint64 secs, bool showTime = true);
    static QString dateFromMSecs(qint64 msecs, bool showTime = true);
    static QString localDateTimeFromString(const QString &dateTimeString, Qt::DateFormat = Qt::ISODate);
    static QString base64Id(const QString &artist, const QString &title);
    static void log(const QString &filePath, const QByteArray &message);
    inline static QString versionNumberString() { return QString("0.0.3"); }
};

#endif // UTILS_H
