#ifndef LISTVIEW_H
#define LISTVIEW_H

#include <QListView>
#include <QMouseEvent>
#include <QAbstractKineticScroller>

class ListView : public QListView
{
    Q_OBJECT

public:
    explicit ListView(QWidget *parent = 0);
    void keyPressEvent(QKeyEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

public slots:
    void positionAtBeginning();
    void positionAtEnd();

private:
    QAbstractKineticScroller *m_kineticScroller;
};

#endif // LISTVIEW_H
