#include "listview.h"
#include <QScrollBar>

ListView::ListView(QWidget *parent) :
    QListView(parent),
    m_kineticScroller(property("kineticScroller").value<QAbstractKineticScroller *>())
{
    setEditTriggers(QListView::NoEditTriggers);
    setAutoScroll(false);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setContextMenuPolicy(Qt::CustomContextMenu);
}

void ListView::positionAtBeginning() {
    scrollTo(model()->index(0, 0), QListView::PositionAtTop);
}

void ListView::positionAtEnd() {
    scrollTo(model()->index(model()->rowCount() - 1, 0), QListView::PositionAtBottom);
}

void ListView::keyPressEvent(QKeyEvent *event) {
    if (event->key() == Qt::Key_Down) {
        if (event->modifiers() == Qt::ShiftModifier) {
            positionAtEnd();
        }
        else {
            m_kineticScroller->scrollTo(QPoint(0, rectForIndex(indexAt(QPoint(0, height()))).y()));
        }

        event->accept();
    }
    else if (event->key() == Qt::Key_Up) {
        if (event->modifiers() == Qt::ShiftModifier) {
            positionAtBeginning();
        }
        else {
            m_kineticScroller->scrollTo(QPoint(0, rectForIndex(indexAt(QPoint(0, -height()))).y()));
        }

        event->accept();
    }
    else {
        event->ignore();
    }
}

void ListView::mousePressEvent(QMouseEvent *event) {
    setCurrentIndex(indexAt(event->pos()));
    QListView::mousePressEvent(event);
}

void ListView::mouseReleaseEvent(QMouseEvent *event) {
    QListView::mouseReleaseEvent(event);
    setCurrentIndex(QModelIndex());
}
